/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPresentationUtil {
    private JavaPresentationUtil() {
    }

    @NotNull
    public static ColoredItemPresentation getMethodPresentation(final @NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/psi/presentation/java/JavaPresentationUtil", "getMethodPresentation"));
        }
        ColoredItemPresentation coloredItemPresentation = new ColoredItemPresentation(){

            public String getPresentableText() {
                return PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, 257, 2);
            }

            public TextAttributesKey getTextAttributesKey() {
                if (psiMethod.isDeprecated()) {
                    return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                }
                return null;
            }

            public String getLocationString() {
                return JavaPresentationUtil.getJavaSymbolContainerText(psiMethod);
            }

            @Override
            public Icon getIcon(boolean open) {
                return psiMethod.getIcon(1);
            }
        };
        if (coloredItemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/presentation/java/JavaPresentationUtil", "getMethodPresentation"));
        }
        return coloredItemPresentation;
    }

    @NotNull
    public static ItemPresentation getFieldPresentation(final @NotNull PsiField psiField) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/intellij/psi/presentation/java/JavaPresentationUtil", "getFieldPresentation"));
        }
        ColoredItemPresentation coloredItemPresentation = new ColoredItemPresentation(){

            public String getPresentableText() {
                return psiField.getName();
            }

            public TextAttributesKey getTextAttributesKey() {
                if (psiField.isDeprecated()) {
                    return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                }
                return null;
            }

            public String getLocationString() {
                return JavaPresentationUtil.getJavaSymbolContainerText(psiField);
            }

            @Override
            public Icon getIcon(boolean open) {
                return psiField.getIcon(1);
            }
        };
        if (coloredItemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/presentation/java/JavaPresentationUtil", "getFieldPresentation"));
        }
        return coloredItemPresentation;
    }

    @Nullable
    private static String getJavaSymbolContainerText(@NotNull PsiElement element) {
        String qName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/presentation/java/JavaPresentationUtil", "getJavaSymbolContainerText"));
        }
        Object container2 = PsiTreeUtil.getParentOfType(element, PsiMember.class, PsiFile.class);
        String result2 = container2 instanceof PsiClass ? ((qName = ((PsiClass)container2).getQualifiedName()) != null ? qName : ((PsiClass)container2).getName()) : (container2 instanceof PsiJavaFile ? ((PsiJavaFile)container2).getPackageName() : null);
        if (result2 != null) {
            return PsiBundle.message("aux.context.display", result2);
        }
        return null;
    }
}

