/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.incremental;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LocationInfo;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupTracker;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.incremental.components.Position;
import kotlin.reflect.jvm.internal.impl.incremental.components.ScopeKind;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UtilsKt {
    public static final void record(@NotNull LookupTracker $receiver, @NotNull LookupLocation from, @NotNull DeclarationDescriptor scopeOwner, @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(scopeOwner, "scopeOwner");
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (Intrinsics.areEqual($receiver, LookupTracker.Companion.getDO_NOTHING()) || from instanceof NoLookupLocation) {
            return;
        }
        LocationInfo locationInfo = from.getLocation();
        if (locationInfo == null) {
            return;
        }
        LocationInfo location2 = locationInfo;
        ScopeKind scopeKind = UtilsKt.getScopeKind(scopeOwner);
        if (scopeKind == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected containing declaration type: " + scopeOwner.getClass())));
        }
        ScopeKind scopeKind2 = scopeKind;
        Position position = $receiver.getRequiresPosition() ? location2.getPosition() : Position.Companion.getNO_POSITION();
        String string = location2.getFilePath();
        String string2 = DescriptorUtilsKt.getFqNameUnsafe(scopeOwner).asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "scopeOwner.fqNameUnsafe.asString()");
        String string3 = name.asString();
        Intrinsics.checkExpressionValueIsNotNull(string3, "name.asString()");
        $receiver.record(string, position, string2, scopeKind2, string3);
    }

    @Nullable
    public static final ScopeKind getScopeKind(@NotNull DeclarationDescriptor scopeOwner) {
        Intrinsics.checkParameterIsNotNull(scopeOwner, "scopeOwner");
        DeclarationDescriptor declarationDescriptor = scopeOwner;
        return declarationDescriptor instanceof ClassifierDescriptor ? ScopeKind.CLASSIFIER : (declarationDescriptor instanceof PackageFragmentDescriptor ? ScopeKind.PACKAGE : (ScopeKind)null);
    }
}

