/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.relocated.com.google.common.collect.LinkedHashMultimap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Multimap;

public class GroupingMessageCollector
implements MessageCollector {
    private final MessageCollector delegate;
    private final Multimap<String, Message> groupedMessages;

    public GroupingMessageCollector(@NotNull MessageCollector delegate2) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "<init>"));
        }
        this.groupedMessages = LinkedHashMultimap.create();
        this.delegate = delegate2;
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location2) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (location2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (CompilerMessageSeverity.VERBOSE.contains((Object)severity)) {
            this.delegate.report(severity, message, location2);
        } else {
            this.groupedMessages.put(location2.getPath(), new Message(severity, message, location2));
        }
    }

    public void flush() {
        boolean hasError = false;
        Collection<String> keys = this.sortedKeys();
        for (String path : keys) {
            for (Message message : this.groupedMessages.get(path)) {
                hasError |= CompilerMessageSeverity.ERRORS.contains((Object)message.severity);
            }
        }
        for (String path : keys) {
            for (Message message : this.groupedMessages.get(path)) {
                if (hasError && !CompilerMessageSeverity.ERRORS.contains((Object)message.severity)) continue;
                this.delegate.report(message.severity, message.message, message.location);
            }
        }
        this.groupedMessages.clear();
    }

    @NotNull
    private Collection<String> sortedKeys() {
        ArrayList<String> sortedKeys = new ArrayList<String>(this.groupedMessages.keySet());
        Collections.sort(sortedKeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        ArrayList<String> arrayList = sortedKeys;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "sortedKeys"));
        }
        return arrayList;
    }

    private static class Message {
        private final CompilerMessageSeverity severity;
        private final String message;
        private final CompilerMessageLocation location;

        private Message(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location2) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            if (location2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            this.severity = severity;
            this.message = message;
            this.location = location2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message message1 = (Message)o;
            if (!this.location.equals(message1.location)) {
                return false;
            }
            if (!this.message.equals(message1.message)) {
                return false;
            }
            return this.severity == message1.severity;
        }

        public int hashCode() {
            int result2 = this.severity.hashCode();
            result2 = 31 * result2 + this.message.hashCode();
            result2 = 31 * result2 + this.location.hashCode();
            return result2;
        }
    }
}

