/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import com.intellij.openapi.Disposable;
import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.messages.MessageSeverityCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.modules.ModuleScriptData;
import org.jetbrains.kotlin.cli.jvm.PluginCliParser;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.repl.ReplFromTerminal;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionsKt;
import org.jetbrains.kotlin.compiler.plugin.PluginCliOptionProcessingException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.relocated.com.google.common.base.Predicates;
import org.jetbrains.kotlin.script.StandardScriptDefinition;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0014J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "()V", "createArguments", "createCoreEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "services", "Lorg/jetbrains/kotlin/config/Services;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Companion", "kotlin-compiler"})
public class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    private static long initStartNanos;
    private static final HashMap<String, Long> elapsedGCTime;
    private static long elapsedJITTime;
    public static final Companion Companion;

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments2, @NotNull Services services, @NotNull MessageCollector messageCollector, @NotNull Disposable rootDisposable) {
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(services, "services");
        Intrinsics.checkParameterIsNotNull(messageCollector, "messageCollector");
        Intrinsics.checkParameterIsNotNull(rootDisposable, "rootDisposable");
        MessageSeverityCollector messageSeverityCollector = new MessageSeverityCollector(messageCollector);
        KotlinPaths paths = arguments2.kotlinHome != null ? (KotlinPaths)new KotlinPathsFromHomeDir(new File(arguments2.kotlinHome)) : PathUtil.getKotlinPathsForCompiler();
        messageSeverityCollector.report(CompilerMessageSeverity.LOGGING, "Using Kotlin home directory " + paths.getHomePath(), CompilerMessageLocation.NO_LOCATION);
        PerformanceCounter.Companion.setTimeCounterEnabled(arguments2.reportPerf);
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageSeverityCollector);
        if (IncrementalCompilation.isEnabled()) {
            IncrementalCompilationComponents incrementalCompilationComponents = services.get(IncrementalCompilationComponents.class);
            configuration.put(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS, incrementalCompilationComponents);
        }
        CompilerJarLocator locator = services.get(CompilerJarLocator.class);
        configuration.put(JVMConfigurationKeys.COMPILER_JAR_LOCATOR, locator);
        try {
            if (!arguments2.noJdk) {
                List<File> list2 = PathUtil.getJdkClassesRoots();
                Intrinsics.checkExpressionValueIsNotNull(list2, "PathUtil.getJdkClassesRoots()");
                JvmContentRootsKt.addJvmClasspathRoots(configuration, list2);
            }
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageSeverityCollector, t);
            return ExitCode.INTERNAL_ERROR;
        }
        try {
            PluginCliParser.loadPlugins(arguments2, configuration);
        }
        catch (PluginCliOptionProcessingException e) {
            String message = e.getMessage() + "\n\n" + CliOptionsKt.cliPluginUsageString(e.getPluginId(), e.getOptions());
            messageSeverityCollector.report(CompilerMessageSeverity.ERROR, message, CompilerMessageLocation.NO_LOCATION);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (CliOptionProcessingException e) {
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            messageSeverityCollector.report(CompilerMessageSeverity.ERROR, string, CompilerMessageLocation.NO_LOCATION);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageSeverityCollector, t);
            return ExitCode.INTERNAL_ERROR;
        }
        if (arguments2.script) {
            if (arguments2.freeArgs.isEmpty()) {
                messageSeverityCollector.report(CompilerMessageSeverity.ERROR, "Specify script source path to evaluate", CompilerMessageLocation.NO_LOCATION);
                return ExitCode.COMPILATION_ERROR;
            }
            String string = (String)arguments2.freeArgs.get(0);
            Intrinsics.checkExpressionValueIsNotNull(string, "arguments.freeArgs.get(0)");
            ContentRootsKt.addKotlinSourceRoot(configuration, string);
        } else if (arguments2.module == null) {
            Iterator message = arguments2.freeArgs.iterator();
            while (message.hasNext()) {
                String arg;
                String string = arg = (String)message.next();
                Intrinsics.checkExpressionValueIsNotNull(string, "arg");
                ContentRootsKt.addKotlinSourceRoot(configuration, string);
                File file = new File(arg);
                if (!file.isDirectory()) continue;
                JvmContentRootsKt.addJavaSourceRoot$default(configuration, file, null, 2, null);
            }
        }
        KotlinPaths kotlinPaths = paths;
        Intrinsics.checkExpressionValueIsNotNull(kotlinPaths, "paths");
        JvmContentRootsKt.addJvmClasspathRoots(configuration, K2JVMCompiler.Companion.getClasspath(kotlinPaths, arguments2));
        String string = arguments2.moduleName;
        if (string == null) {
            string = "main";
        }
        configuration.put(JVMConfigurationKeys.MODULE_NAME, string);
        if (arguments2.module == null && arguments2.freeArgs.isEmpty() && !arguments2.version) {
            ReplFromTerminal.run(rootDisposable, configuration);
            return ExitCode.OK;
        }
        configuration.add(CommonConfigurationKeys.SCRIPT_DEFINITIONS_KEY, StandardScriptDefinition.INSTANCE);
        if (arguments2.skipMetadataVersionCheck) {
            JvmMetadataVersion.Companion.setSkipCheck(true);
        }
        K2JVMCompiler.Companion.putAdvancedOptions(configuration, arguments2);
        messageSeverityCollector.report(CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", CompilerMessageLocation.NO_LOCATION);
        try {
            KotlinCoreEnvironment environment22;
            Object friendPaths;
            File outputDir2;
            File jar;
            this.configureEnvironment(configuration, (CommonCompilerArguments)arguments2);
            String destination = arguments2.destination;
            if (destination != null) {
                boolean isJar = StringsKt.endsWith$default(destination, ".jar", false, 2, null);
                jar = isJar ? new File(destination) : (File)null;
                outputDir2 = isJar ? (File)null : new File(destination);
            } else {
                jar = null;
                outputDir2 = null;
            }
            Object object = arguments2.friendPaths;
            if (arguments2.friendPaths == null || (object = ArraysKt.toList((Object[])object)) == null) {
                object = friendPaths = CollectionsKt.emptyList();
            }
            if (arguments2.module != null) {
                FilteringMessageCollector sanitizedCollector = new FilteringMessageCollector(messageSeverityCollector, Predicates.in((Collection)CompilerMessageSeverity.VERBOSE));
                ModuleScriptData moduleScript = CompileEnvironmentUtil.loadModuleDescriptions(arguments2.module, sanitizedCollector);
                if (outputDir2 != null) {
                    messageSeverityCollector.report(CompilerMessageSeverity.WARNING, "The '-d' option with a directory destination is ignored because '-module' is specified", CompilerMessageLocation.NO_LOCATION);
                }
                File directory = new File(arguments2.module).getAbsoluteFile().getParentFile();
                List<Module> list3 = moduleScript.getModules();
                Intrinsics.checkExpressionValueIsNotNull(list3, "moduleScript.modules");
                File file = directory;
                Intrinsics.checkExpressionValueIsNotNull(file, "directory");
                CompilerConfiguration compilerConfiguration = KotlinToJVMBytecodeCompiler.INSTANCE.createCompilerConfiguration(configuration, list3, file);
                compilerConfiguration.put(JVMConfigurationKeys.MODULE_XML_FILE_PATH, arguments2.module);
                environment22 = this.createCoreEnvironment(rootDisposable, compilerConfiguration);
                if (messageSeverityCollector.anyReported(CompilerMessageSeverity.ERROR)) {
                    return ExitCode.COMPILATION_ERROR;
                }
                List<Module> list4 = moduleScript.getModules();
                Intrinsics.checkExpressionValueIsNotNull(list4, "moduleScript.modules");
                File file2 = directory;
                Intrinsics.checkExpressionValueIsNotNull(file2, "directory");
                KotlinToJVMBytecodeCompiler.INSTANCE.compileModules(environment22, configuration, list4, file2, jar, (List<String>)friendPaths, arguments2.includeRuntime);
            } else {
                if (arguments2.script) {
                    List<String> scriptArgs = arguments2.freeArgs.subList(1, arguments2.freeArgs.size());
                    KotlinCoreEnvironment environment22 = this.createCoreEnvironment(rootDisposable, configuration);
                    if (messageSeverityCollector.anyReported(CompilerMessageSeverity.ERROR)) {
                        return ExitCode.COMPILATION_ERROR;
                    }
                    KotlinPaths kotlinPaths2 = paths;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinPaths2, "paths");
                    return KotlinToJVMBytecodeCompiler.INSTANCE.compileAndExecuteScript(configuration, kotlinPaths2, environment22, scriptArgs);
                }
                environment22 = this.createCoreEnvironment(rootDisposable, configuration);
                if (messageSeverityCollector.anyReported(CompilerMessageSeverity.ERROR)) {
                    return ExitCode.COMPILATION_ERROR;
                }
                if (environment22.getSourceFiles().isEmpty()) {
                    if (arguments2.version) {
                        return ExitCode.OK;
                    }
                    messageSeverityCollector.report(CompilerMessageSeverity.ERROR, "No source files", CompilerMessageLocation.NO_LOCATION);
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinToJVMBytecodeCompiler.INSTANCE.compileBunchOfSources(environment22, jar, outputDir2, (List<String>)friendPaths, arguments2.includeRuntime);
            }
            if (arguments2.reportPerf) {
                Companion.reportGCTime(environment22.getConfiguration());
                Companion.reportCompilationTime(environment22.getConfiguration());
                PerformanceCounter.Companion.report((Function1<? super String, Unit>)new Function1<String, Unit>(environment22){
                    final /* synthetic */ KotlinCoreEnvironment $environment;

                    public final void invoke(@NotNull String s) {
                        Intrinsics.checkParameterIsNotNull(s, "s");
                        K2JVMCompiler.Companion.reportPerf(this.$environment.getConfiguration(), s);
                    }
                    {
                        this.$environment = kotlinCoreEnvironment;
                        super(1);
                    }
                });
            }
            return ExitCode.OK;
        }
        catch (CompilationException e) {
            messageSeverityCollector.report(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException(e), MessageUtil.psiElementToMessageLocation(e.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
    }

    private final KotlinCoreEnvironment createCoreEnvironment(Disposable rootDisposable, CompilerConfiguration configuration) {
        List<String> list2 = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        Intrinsics.checkExpressionValueIsNotNull(list2, "EnvironmentConfigFiles.JVM_CONFIG_FILES");
        KotlinCoreEnvironment result2 = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, list2);
        if (K2JVMCompiler.Companion.getInitStartNanos() != 0L) {
            long initNanos = System.nanoTime() - K2JVMCompiler.Companion.getInitStartNanos();
            Companion.reportPerf(configuration, "INIT: Compiler initialized in " + TimeUnit.NANOSECONDS.toMillis(initNanos) + " ms");
            K2JVMCompiler.Companion.setInitStartNanos(0L);
        }
        return result2;
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments result2 = new K2JVMCompilerArguments();
        if (System.getenv("KOTLIN_REPORT_PERF") != null) {
            result2.reportPerf = true;
        }
        return result2;
    }

    static {
        Companion = new Companion(null);
        initStartNanos = System.nanoTime();
        elapsedGCTime = MapsKt.hashMapOf(new Pair[0]);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001b\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010\"\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\u0019R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler$Companion;", "", "()V", "elapsedGCTime", "Ljava/util/HashMap;", "", "", "getElapsedGCTime", "()Ljava/util/HashMap;", "elapsedJITTime", "getElapsedJITTime", "()J", "setElapsedJITTime", "(J)V", "initStartNanos", "getInitStartNanos", "setInitStartNanos", "getClasspath", "", "Ljava/io/File;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "main", "", "args", "", "([Ljava/lang/String;)V", "putAdvancedOptions", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "reportCompilationTime", "reportGCTime", "reportPerf", "message", "resetInitStartTime", "kotlin-compiler"})
    public static final class Companion {
        private final long getInitStartNanos() {
            return initStartNanos;
        }

        private final void setInitStartNanos(long l) {
            initStartNanos = l;
        }

        private final HashMap<String, Long> getElapsedGCTime() {
            return elapsedGCTime;
        }

        private final long getElapsedJITTime() {
            return elapsedJITTime;
        }

        private final void setElapsedJITTime(long l) {
            elapsedJITTime = l;
        }

        public final void resetInitStartTime() {
            if (this.getInitStartNanos() == 0L) {
                this.setInitStartNanos(System.nanoTime());
            }
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull(args, "args");
            CLICompiler.doMain(new K2JVMCompiler(), args);
        }

        public final void reportPerf(@NotNull CompilerConfiguration configuration, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(message, "message");
            if (!configuration.get(CLIConfigurationKeys.REPORT_PERF, false).booleanValue()) {
                return;
            }
            MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            if (messageCollector == null) {
                Intrinsics.throwNpe();
            }
            MessageCollector collector2 = messageCollector;
            collector2.report(CompilerMessageSeverity.INFO, "PERF: " + message, CompilerMessageLocation.NO_LOCATION);
        }

        public final void reportGCTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Iterable $receiver$iv = ManagementFactory.getGarbageCollectorMXBeans();
            for (Object element$iv : $receiver$iv) {
                String string;
                String string2;
                GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
                long currentTime = it.getCollectionTime();
                Map map2 = Companion.getElapsedGCTime();
                Intrinsics.checkExpressionValueIsNotNull(it.getName(), "it.name");
                Object object = map2.get(string2);
                if (object == null) {
                    object = 0L;
                }
                long elapsedTime = ((Number)object).longValue();
                long time = currentTime - elapsedTime;
                Companion.reportPerf(configuration, "GC time for " + it.getName() + " is " + time + " ms");
                Map map3 = Companion.getElapsedGCTime();
                Intrinsics.checkExpressionValueIsNotNull(it.getName(), "it.name");
                Long l = currentTime;
                map3.put(string, l);
            }
        }

        public final void reportCompilationTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
            if (compilationMXBean == null) {
                return;
            }
            CompilationMXBean bean = compilationMXBean;
            long currentTime = bean.getTotalCompilationTime();
            this.reportPerf(configuration, "JIT time is " + (currentTime - this.getElapsedJITTime()) + " ms");
            this.setElapsedJITTime(currentTime);
        }

        private final void putAdvancedOptions(CompilerConfiguration configuration, K2JVMCompilerArguments arguments2) {
            configuration.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments2.noCallAssertions);
            configuration.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments2.noParamAssertions);
            configuration.put(JVMConfigurationKeys.DISABLE_INLINE, arguments2.noInline);
            configuration.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments2.noOptimize);
            configuration.put(JVMConfigurationKeys.DECLARATIONS_JSON_PATH, arguments2.declarationsOutputPath);
            configuration.put(JVMConfigurationKeys.INHERIT_MULTIFILE_PARTS, arguments2.inheritMultifileParts);
            configuration.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.allowKotlinPackage);
            configuration.put(CLIConfigurationKeys.REPORT_PERF, arguments2.reportPerf);
        }

        /*
         * WARNING - void declaration
         */
        private final List<File> getClasspath(KotlinPaths paths, K2JVMCompilerArguments arguments2) {
            ArrayList<File> classpath = CollectionsKt.arrayListOf(new File[0]);
            if (arguments2.classpath != null) {
                List list2;
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = StringsKt.split$default((CharSequence)arguments2.classpath, new char[]{File.pathSeparatorChar}, false, 0, 6, null);
                ArrayList<File> arrayList = classpath;
                void var6_6 = $receiver$iv;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    list2 = destination$iv$iv;
                    File file = new File((String)it);
                    list2.add(file);
                }
                list2 = (List)destination$iv$iv;
                arrayList.addAll(list2);
            }
            if (!arguments2.noStdlib) {
                classpath.add(paths.getRuntimePath());
            }
            return classpath;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

