/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import com.intellij.util.containers.StringInterner;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.EventManger;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.incremental.components.LookupInfo;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.Position;
import org.jetbrains.kotlin.incremental.components.ScopeKind;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J0\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001dH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/daemon/RemoteLookupTrackerClient;", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "eventManger", "Lorg/jetbrains/kotlin/daemon/EventManger;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/daemon/EventManger;Lorg/jetbrains/kotlin/daemon/common/Profiler;)V", "getEventManger", "()Lorg/jetbrains/kotlin/daemon/EventManger;", "getFacade", "()Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "interner", "Lcom/intellij/util/containers/StringInterner;", "isDoNothing", "", "lookups", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/incremental/components/LookupInfo;", "getProfiler", "()Lorg/jetbrains/kotlin/daemon/common/Profiler;", "requiresPosition", "getRequiresPosition", "()Z", "flush", "", "record", "filePath", "", "position", "Lorg/jetbrains/kotlin/incremental/components/Position;", "scopeFqName", "scopeKind", "Lorg/jetbrains/kotlin/incremental/components/ScopeKind;", "name", "kotlin-compiler"})
public final class RemoteLookupTrackerClient
implements LookupTracker {
    private final boolean isDoNothing;
    private final HashSet<LookupInfo> lookups;
    private final StringInterner interner;
    private final boolean requiresPosition;
    @NotNull
    private final CompilerCallbackServicesFacade facade;
    @NotNull
    private final EventManger eventManger;
    @NotNull
    private final Profiler profiler;

    @Override
    public boolean getRequiresPosition() {
        return this.requiresPosition;
    }

    @Override
    public void record(@NotNull String filePath, @NotNull Position position, @NotNull String scopeFqName, @NotNull ScopeKind scopeKind, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        Intrinsics.checkParameterIsNotNull(position, "position");
        Intrinsics.checkParameterIsNotNull(scopeFqName, "scopeFqName");
        Intrinsics.checkParameterIsNotNull((Object)scopeKind, "scopeKind");
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (this.isDoNothing) {
            return;
        }
        String internedFilePath = this.interner.intern(filePath);
        String internedScopeFqName = this.interner.intern(scopeFqName);
        String internedName = this.interner.intern(name);
        String string = internedFilePath;
        Intrinsics.checkExpressionValueIsNotNull(string, "internedFilePath");
        String string2 = internedScopeFqName;
        Intrinsics.checkExpressionValueIsNotNull(string2, "internedScopeFqName");
        String string3 = internedName;
        Intrinsics.checkExpressionValueIsNotNull(string3, "internedName");
        this.lookups.add(new LookupInfo(string, position, string2, scopeKind, string3));
    }

    private final void flush() {
        if (this.isDoNothing || this.lookups.isEmpty()) {
            return;
        }
        this.profiler.withMeasure(this, (Function0)new Function0<Unit>(this){
            final /* synthetic */ RemoteLookupTrackerClient this$0;

            public final void invoke() {
                this.this$0.getFacade().lookupTracker_record(RemoteLookupTrackerClient.access$getLookups$p(this.this$0));
            }
            {
                this.this$0 = remoteLookupTrackerClient;
                super(0);
            }
        });
        this.lookups.clear();
    }

    @NotNull
    public final CompilerCallbackServicesFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final EventManger getEventManger() {
        return this.eventManger;
    }

    @NotNull
    public final Profiler getProfiler() {
        return this.profiler;
    }

    public RemoteLookupTrackerClient(@NotNull CompilerCallbackServicesFacade facade, @NotNull EventManger eventManger, @NotNull Profiler profiler) {
        Intrinsics.checkParameterIsNotNull(facade, "facade");
        Intrinsics.checkParameterIsNotNull(eventManger, "eventManger");
        Intrinsics.checkParameterIsNotNull(profiler, "profiler");
        this.facade = facade;
        this.eventManger = eventManger;
        this.profiler = profiler;
        this.isDoNothing = (Boolean)this.profiler.withMeasure(this, (Function0)new Function0<Boolean>(this){
            final /* synthetic */ RemoteLookupTrackerClient this$0;

            public final boolean invoke() {
                return this.this$0.getFacade().lookupTracker_isDoNothing();
            }
            {
                this.this$0 = remoteLookupTrackerClient;
                super(0);
            }
        });
        this.lookups = SetsKt.hashSetOf(new LookupInfo[0]);
        this.interner = new StringInterner();
        this.requiresPosition = (Boolean)this.profiler.withMeasure(this, (Function0)new Function0<Boolean>(this){
            final /* synthetic */ RemoteLookupTrackerClient this$0;

            public final boolean invoke() {
                return this.this$0.getFacade().lookupTracker_requiresPosition();
            }
            {
                this.this$0 = remoteLookupTrackerClient;
                super(0);
            }
        });
        this.eventManger.onCompilationFinished(new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.flush();
            }
        });
    }

    public /* synthetic */ RemoteLookupTrackerClient(CompilerCallbackServicesFacade compilerCallbackServicesFacade, EventManger eventManger, Profiler profiler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            profiler = new DummyProfiler();
        }
        this(compilerCallbackServicesFacade, eventManger, profiler);
    }

    @NotNull
    public static final /* synthetic */ HashSet access$getLookups$p(RemoteLookupTrackerClient $this) {
        return $this.lookups;
    }
}

