/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoKt;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0001\u001a(\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a(\u0010\n\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u000b\u001a\u00020\f*\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0005H\u0002\u00a8\u0006\u000e"}, d2={"computeExplicitReceiversForInvoke", "Lorg/jetbrains/kotlin/js/translate/callTranslator/ExplicitReceivers;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "explicitReceivers", "translateCall", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "translateFunctionCall", "expectedReceivers", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "kotlin-compiler"})
public final class CallTranslatorKt {
    private static final boolean expectedReceivers(@NotNull ResolvedCall<? extends CallableDescriptor> $receiver) {
        return Intrinsics.areEqual((Object)$receiver.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.NO_EXPLICIT_RECEIVER) ^ true;
    }

    private static final JsExpression translateCall(TranslationContext context, ResolvedCall<? extends FunctionDescriptor> resolvedCall2, ExplicitReceivers explicitReceivers) {
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            Unit unit;
            boolean bl = explicitReceivers.getExtensionReceiver() == null;
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "VariableAsFunctionResolvedCall must have one receiver";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall();
            if (CallTranslatorKt.expectedReceivers(variableCall)) {
                JsExpression newReceiver = CallTranslator.INSTANCE.translateGet(context, variableCall, explicitReceivers.getExtensionOrDispatchReceiver());
                return CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), new ExplicitReceivers(newReceiver, null, 2, null));
            }
            JsExpression dispatchReceiver = CallTranslator.INSTANCE.translateGet(context, variableCall, null);
            if (explicitReceivers.getExtensionOrDispatchReceiver() == null) {
                return CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), new ExplicitReceivers(dispatchReceiver, null, 2, null));
            }
            return CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), new ExplicitReceivers(dispatchReceiver, explicitReceivers.getExtensionOrDispatchReceiver()));
        }
        Call call = resolvedCall2.getCall();
        if (Intrinsics.areEqual((Object)call.getCallType(), (Object)Call.CallType.INVOKE)) {
            Call call2 = call;
            Intrinsics.checkExpressionValueIsNotNull(call2, "call");
            if (!CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
                ExplicitReceivers explicitReceiversForInvoke = CallTranslatorKt.computeExplicitReceiversForInvoke(context, resolvedCall2, explicitReceivers);
                return CallTranslatorKt.translateFunctionCall(context, resolvedCall2, explicitReceiversForInvoke);
            }
        }
        return CallTranslatorKt.translateFunctionCall(context, resolvedCall2, explicitReceivers);
    }

    private static final JsExpression translateFunctionCall(TranslationContext context, ResolvedCall<? extends FunctionDescriptor> resolvedCall2, ExplicitReceivers explicitReceivers) {
        return FunctionCallCasesKt.translateFunctionCall(CallInfoKt.getCallInfo(context, resolvedCall2, explicitReceivers));
    }

    @NotNull
    public static final ExplicitReceivers computeExplicitReceiversForInvoke(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall2, @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        boolean bl;
        Unit unit;
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        KtElement callElement = resolvedCall2.getCall().getCallElement();
        boolean bl2 = explicitReceivers.getExtensionReceiver() == null;
        if (_Assertions.ENABLED) {
            if (!bl2) {
                String string = "'Invoke' call must have one receiver: " + callElement;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        Function1<ReceiverValue, JsExpression> translateReceiverAsExpression$ = new Function1<ReceiverValue, JsExpression>(context){
            final /* synthetic */ TranslationContext $context;

            @Nullable
            public final JsExpression invoke(@Nullable ReceiverValue receiver) {
                JsExpression jsExpression;
                ReceiverValue receiverValue = receiver;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
                if (expressionReceiver != null) {
                    ExpressionReceiver expressionReceiver2 = expressionReceiver;
                    ExpressionReceiver it = expressionReceiver2;
                    jsExpression = Translation.translateAsExpression(it.getExpression(), this.$context);
                } else {
                    jsExpression = null;
                }
                return jsExpression;
            }
            {
                this.$context = translationContext;
                super(1);
            }
        };
        ReceiverValue dispatchReceiver = resolvedCall2.getDispatchReceiver();
        Receiver extensionReceiver2 = resolvedCall2.getExtensionReceiver();
        if (dispatchReceiver != null && extensionReceiver2 != null && Intrinsics.areEqual((Object)resolvedCall2.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.BOTH_RECEIVERS)) {
            Unit unit2;
            bl = explicitReceivers.getExtensionOrDispatchReceiver() != null;
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "No explicit receiver for 'invoke' resolved call with both receivers: " + callElement + ", text: " + callElement.getText() + ("Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver2);
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = Unit.INSTANCE;
            }
        } else {
            Unit unit3;
            bl = explicitReceivers.getExtensionOrDispatchReceiver() == null;
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "Non trivial explicit receiver " + explicitReceivers.getExtensionOrDispatchReceiver() + "\n" + ("for 'invoke' resolved call: " + callElement + ", text: " + callElement.getText() + "\n") + ("Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver2);
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit3 = Unit.INSTANCE;
            } else {
                unit3 = Unit.INSTANCE;
            }
        }
        JsExpression dispatchReceiverExpression = translateReceiverAsExpression$.invoke(dispatchReceiver);
        Pair<Boolean, Boolean> pair = new Pair<Boolean, Boolean>(dispatchReceiver != null, extensionReceiver2 != null);
        if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, true))) {
            explicitReceivers2 = new ExplicitReceivers(dispatchReceiverExpression, explicitReceivers.getExtensionOrDispatchReceiver());
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, false))) {
            explicitReceivers2 = new ExplicitReceivers(dispatchReceiverExpression, null, 2, null);
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(false, true))) {
            Receiver receiver = extensionReceiver2;
            if (receiver == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue");
            }
            explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke((ReceiverValue)receiver), null, 2, null);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("'Invoke' resolved call without receivers: " + callElement)));
        }
        return explicitReceivers2;
    }

    @NotNull
    public static final /* synthetic */ JsExpression access$translateCall(@NotNull TranslationContext context, @NotNull ResolvedCall resolvedCall2, @NotNull ExplicitReceivers explicitReceivers) {
        return CallTranslatorKt.translateCall(context, resolvedCall2, explicitReceivers);
    }
}

