/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.CachedAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;

public class ArrayAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    @NotNull
    private final KtArrayAccessExpression expression;

    static ArrayAccessTranslator newInstance(@NotNull KtArrayAccessExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "newInstance"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "newInstance"));
        }
        return new ArrayAccessTranslator(expression, context);
    }

    protected ArrayAccessTranslator(@NotNull KtArrayAccessExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "<init>"));
        }
        super(context);
        this.expression = expression;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.translateAsGet(this.getArrayExpression());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @NotNull
    protected JsExpression translateAsGet(@NotNull JsExpression arrayExpression) {
        if (arrayExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayExpression", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "translateAsGet"));
        }
        JsExpression jsExpression = this.translateAsMethodCall(arrayExpression, null);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        if (setTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setTo", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "translateAsSet"));
        }
        JsExpression jsExpression = this.translateAsSet(this.getArrayExpression(), setTo);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @NotNull
    protected JsExpression translateAsSet(@NotNull JsExpression arrayExpression, @NotNull JsExpression toSetTo) {
        if (arrayExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayExpression", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "translateAsSet"));
        }
        if (toSetTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSetTo", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "translateAsSet"));
        }
        JsExpression jsExpression = this.translateAsMethodCall(arrayExpression, toSetTo);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateAsMethodCall(@NotNull JsExpression arrayExpression, @Nullable JsExpression toSetTo) {
        if (arrayExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayExpression", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "translateAsMethodCall"));
        }
        boolean isGetter = toSetTo == null;
        TranslationContext context = this.context();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getResolvedCallForArrayAccess(this.bindingContext(), this.expression, isGetter);
        if (!isGetter) {
            context = this.contextWithValueParameterAliasInArrayGetAccess(toSetTo);
        }
        JsExpression jsExpression = CallTranslator.translate(context, resolvedCall2, arrayExpression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "translateAsMethodCall"));
        }
        return jsExpression;
    }

    @NotNull
    protected JsExpression getArrayExpression() {
        KtExpression arrayExpression = this.expression.getArrayExpression();
        assert (arrayExpression != null) : "Code with parsing errors shouldn't be translated";
        JsExpression jsExpression = Translation.translateAsExpression(arrayExpression, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "getArrayExpression"));
        }
        return jsExpression;
    }

    @NotNull
    private TranslationContext contextWithValueParameterAliasInArrayGetAccess(@NotNull JsExpression toSetTo) {
        if (toSetTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSetTo", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "contextWithValueParameterAliasInArrayGetAccess"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getResolvedCallForArrayAccess(this.bindingContext(), this.expression, false);
        List<ResolvedValueArgument> arguments2 = resolvedCall2.getValueArgumentsByIndex();
        if (arguments2 == null) {
            throw new IllegalStateException("Failed to arrange value arguments by index: " + resolvedCall2.getResultingDescriptor());
        }
        ResolvedValueArgument lastArgument = arguments2.get(arguments2.size() - 1);
        assert (lastArgument instanceof ExpressionValueArgument) : "Last argument of array-like setter must be ExpressionValueArgument: " + lastArgument;
        ValueArgument valueArgument = ((ExpressionValueArgument)lastArgument).getValueArgument();
        assert (valueArgument != null);
        KtExpression element = valueArgument.getArgumentExpression();
        TranslationContext translationContext = this.context().innerContextWithAliasesForExpressions(Collections.singletonMap(element, toSetTo));
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "contextWithValueParameterAliasInArrayGetAccess"));
        }
        return translationContext;
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        ArrayList<TemporaryVariable> temporaries = new ArrayList<TemporaryVariable>();
        HashMap<KtExpression, JsExpression> aliases = new HashMap<KtExpression, JsExpression>();
        TemporaryVariable temporaryArrayExpression = this.context().declareTemporary(this.getArrayExpression());
        temporaries.add(temporaryArrayExpression);
        for (KtExpression ktExpression : this.expression.getIndexExpressions()) {
            JsExpression jsExpression = Translation.translateAsExpression(ktExpression, this.context());
            TemporaryVariable temporaryVariable = this.context().declareTemporary(jsExpression);
            temporaries.add(temporaryVariable);
            aliases.put(ktExpression, temporaryVariable.reference());
        }
        CachedArrayAccessTranslator cachedArrayAccessTranslator = new CachedArrayAccessTranslator(this.expression, this.context().innerContextWithAliasesForExpressions(aliases), temporaryArrayExpression, temporaries);
        if (cachedArrayAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator", "getCached"));
        }
        return cachedArrayAccessTranslator;
    }

    private static class CachedArrayAccessTranslator
    extends ArrayAccessTranslator
    implements CachedAccessTranslator {
        @NotNull
        private final TemporaryVariable temporaryArrayExpression;
        @NotNull
        private final List<TemporaryVariable> declaredTemporaries;

        protected CachedArrayAccessTranslator(@NotNull KtArrayAccessExpression expression, @NotNull TranslationContext context, @NotNull TemporaryVariable temporaryArrayExpression, @NotNull List<TemporaryVariable> temporaries) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator$CachedArrayAccessTranslator", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator$CachedArrayAccessTranslator", "<init>"));
            }
            if (temporaryArrayExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "temporaryArrayExpression", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator$CachedArrayAccessTranslator", "<init>"));
            }
            if (temporaries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "temporaries", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator$CachedArrayAccessTranslator", "<init>"));
            }
            super(expression, context);
            this.temporaryArrayExpression = temporaryArrayExpression;
            this.declaredTemporaries = temporaries;
        }

        @Override
        @NotNull
        protected JsExpression getArrayExpression() {
            JsNameRef jsNameRef = this.temporaryArrayExpression.reference();
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator$CachedArrayAccessTranslator", "getArrayExpression"));
            }
            return jsNameRef;
        }

        @Override
        @NotNull
        public List<TemporaryVariable> declaredTemporaries() {
            List<TemporaryVariable> list2 = this.declaredTemporaries;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator$CachedArrayAccessTranslator", "declaredTemporaries"));
            }
            return list2;
        }
    }
}

