/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.gnu.trove;

import java.io.Serializable;
import org.jetbrains.kotlin.relocated.gnu.trove.HashFunctions;
import org.jetbrains.kotlin.relocated.gnu.trove.TLongProcedure;

public class TLongArrayList
implements Serializable,
Cloneable {
    protected transient long[] _data;
    protected transient int _pos;

    public TLongArrayList() {
        this(4);
    }

    public TLongArrayList(int capacity) {
        this._data = new long[capacity];
        this._pos = 0;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            long[] tmp = new long[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public void add(long val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public long get(int offset2) {
        if (offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        return this._data[offset2];
    }

    public void clear() {
        this.clear(4);
    }

    public void clear(int capacity) {
        this._data = new long[capacity];
        this._pos = 0;
    }

    public Object clone() {
        TLongArrayList clone = null;
        try {
            clone = (TLongArrayList)super.clone();
            clone._data = (long[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public long[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public long[] toNativeArray(int offset2, int len) {
        long[] rv = new long[len];
        this.toNativeArray(rv, offset2, len);
        return rv;
    }

    public void toNativeArray(long[] dest, int offset2, int len) {
        if (len == 0) {
            return;
        }
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(this._data, offset2, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TLongArrayList) {
            TLongArrayList that = (TLongArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data[i] == that._data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data[i]);
        }
        return h;
    }

    public boolean forEach(TLongProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        final StringBuffer buf = new StringBuffer("{");
        this.forEach(new TLongProcedure(){

            @Override
            public boolean execute(long val) {
                buf.append(val);
                buf.append(", ");
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }
}

