/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class SmartCastManager {
    @NotNull
    public List<KotlinType> getSmartCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull ResolutionContext context) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        List<KotlinType> list2 = this.getSmartCastVariants(receiverToCast, context.trace.getBindingContext(), context.scope.getOwnerDescriptor(), context.dataFlowInfo);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        return list2;
    }

    @NotNull
    public List<KotlinType> getSmartCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule, @NotNull DataFlowInfo dataFlowInfo) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        ArrayList<KotlinType> variants = Lists.newArrayList();
        variants.add(receiverToCast.getType());
        variants.addAll(this.getSmartCastVariantsExcludingReceiver(bindingContext, containingDeclarationOrModule, dataFlowInfo, receiverToCast));
        ArrayList<KotlinType> arrayList = variants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        return arrayList;
    }

    @NotNull
    public List<KotlinType> getSmartCastVariantsWithLessSpecificExcluded(@NotNull ReceiverValue receiverToCast, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule, @NotNull DataFlowInfo dataFlowInfo) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        final List<KotlinType> variants = CollectionsKt.distinct(this.getSmartCastVariants(receiverToCast, bindingContext, containingDeclarationOrModule, dataFlowInfo));
        List<KotlinType> list2 = CollectionsKt.filter(variants, new Function1<KotlinType, Boolean>(){

            @Override
            public Boolean invoke(final KotlinType type2) {
                return CollectionsKt.none(variants, new Function1<KotlinType, Boolean>(){

                    @Override
                    public Boolean invoke(KotlinType another) {
                        return another != type2 && KotlinTypeChecker.DEFAULT.isSubtypeOf(another, type2);
                    }
                });
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        return list2;
    }

    @NotNull
    public Collection<KotlinType> getSmartCastVariantsExcludingReceiver(@NotNull ResolutionContext context, @NotNull ReceiverValue receiverToCast) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        Collection<KotlinType> collection = this.getSmartCastVariantsExcludingReceiver(context.trace.getBindingContext(), context.scope.getOwnerDescriptor(), context.dataFlowInfo, receiverToCast);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        return collection;
    }

    @NotNull
    public Collection<KotlinType> getSmartCastVariantsExcludingReceiver(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule, @NotNull DataFlowInfo dataFlowInfo, @NotNull ReceiverValue receiverToCast) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverToCast, bindingContext, containingDeclarationOrModule);
        Set<KotlinType> set = dataFlowInfo.getCollectedTypes(dataFlowValue);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        return set;
    }

    public boolean isSubTypeBySmartCastIgnoringNullability(@NotNull ReceiverValue receiverArgument, @NotNull KotlinType receiverParameterType, @NotNull ResolutionContext context) {
        if (receiverArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "isSubTypeBySmartCastIgnoringNullability"));
        }
        if (receiverParameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameterType", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "isSubTypeBySmartCastIgnoringNullability"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "isSubTypeBySmartCastIgnoringNullability"));
        }
        List<KotlinType> smartCastTypes = this.getSmartCastVariants(receiverArgument, context);
        return this.getSmartCastSubType(TypeUtils.makeNullable(receiverParameterType), smartCastTypes) != null;
    }

    @Nullable
    private KotlinType getSmartCastSubType(@NotNull KotlinType receiverParameterType, @NotNull Collection<KotlinType> smartCastTypes) {
        if (receiverParameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameterType", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastSubType"));
        }
        if (smartCastTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smartCastTypes", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastSubType"));
        }
        HashSet<KotlinType> subTypes = Sets.newHashSet();
        for (KotlinType smartCastType : smartCastTypes) {
            if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(smartCastType, receiverParameterType)) continue;
            subTypes.add(smartCastType);
        }
        if (subTypes.isEmpty()) {
            return null;
        }
        KotlinType intersection = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, subTypes);
        if (intersection == null || !intersection.getConstructor().isDenotable()) {
            return receiverParameterType;
        }
        return intersection;
    }

    private static void recordCastOrError(@NotNull KtExpression expression, @NotNull KotlinType type2, @NotNull BindingTrace trace, @NotNull DataFlowValue dataFlowValue, boolean recordExpressionType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "recordCastOrError"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "recordCastOrError"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "recordCastOrError"));
        }
        if (dataFlowValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowValue", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "recordCastOrError"));
        }
        if (KotlinBuiltIns.isNullableNothing(type2)) {
            return;
        }
        if (dataFlowValue.isPredictable()) {
            trace.record(BindingContext.SMARTCAST, expression, type2);
            if (recordExpressionType) {
                trace.recordType(expression, type2);
            }
        } else {
            trace.report(Errors.SMARTCAST_IMPOSSIBLE.on(expression, type2, expression.getText(), dataFlowValue.getKind().getDescription()));
        }
    }

    @Nullable
    public static SmartCastResult checkAndRecordPossibleCast(@NotNull DataFlowValue dataFlowValue, @NotNull KotlinType expectedType, @Nullable KtExpression expression, @NotNull ResolutionContext c, @Nullable KtExpression calleeExpression, boolean recordExpressionType) {
        if (dataFlowValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowValue", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "checkAndRecordPossibleCast"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "checkAndRecordPossibleCast"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "checkAndRecordPossibleCast"));
        }
        return SmartCastManager.checkAndRecordPossibleCast(dataFlowValue, expectedType, null, expression, c, calleeExpression, recordExpressionType);
    }

    @Nullable
    public static SmartCastResult checkAndRecordPossibleCast(@NotNull DataFlowValue dataFlowValue, @NotNull KotlinType expectedType, @Nullable Function1<KotlinType, Boolean> additionalPredicate, @Nullable KtExpression expression, @NotNull ResolutionContext c, @Nullable KtExpression calleeExpression, boolean recordExpressionType) {
        if (dataFlowValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowValue", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "checkAndRecordPossibleCast"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "checkAndRecordPossibleCast"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "checkAndRecordPossibleCast"));
        }
        for (KotlinType possibleType : c.dataFlowInfo.getCollectedTypes(dataFlowValue)) {
            if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(possibleType, expectedType) || additionalPredicate != null && !additionalPredicate.invoke(possibleType).booleanValue()) continue;
            if (expression != null) {
                SmartCastManager.recordCastOrError(expression, possibleType, c.trace, dataFlowValue, recordExpressionType);
            } else if (calleeExpression != null && dataFlowValue.isPredictable()) {
                c.trace.record(BindingContext.IMPLICIT_RECEIVER_SMARTCAST, calleeExpression, possibleType);
            }
            return new SmartCastResult(possibleType, dataFlowValue.isPredictable());
        }
        if (!c.dataFlowInfo.getCollectedNullability(dataFlowValue).canBeNull() && !expectedType.isMarkedNullable()) {
            boolean immanentlyNotNull = !dataFlowValue.getImmanentNullability().canBeNull();
            KotlinType nullableExpectedType = TypeUtils.makeNullable(expectedType);
            if (ArgumentTypeResolver.isSubtypeOfForArgumentType(dataFlowValue.getType(), nullableExpectedType) && (additionalPredicate == null || additionalPredicate.invoke(dataFlowValue.getType()).booleanValue())) {
                if (!immanentlyNotNull && expression != null) {
                    SmartCastManager.recordCastOrError(expression, dataFlowValue.getType(), c.trace, dataFlowValue, recordExpressionType);
                }
                return new SmartCastResult(dataFlowValue.getType(), immanentlyNotNull || dataFlowValue.isPredictable());
            }
            return SmartCastManager.checkAndRecordPossibleCast(dataFlowValue, nullableExpectedType, expression, c, calleeExpression, recordExpressionType);
        }
        return null;
    }
}

