/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.AbstractLazyMemberScope;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0014J\u001e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyPackageMemberScope;", "Lorg/jetbrains/kotlin/resolve/lazy/descriptors/AbstractLazyMemberScope;", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "declarationProvider", "thisPackage", "(Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;)V", "getContributedDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kindFilter", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "", "getNonDeclaredFunctions", "", "name", "result", "", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "getNonDeclaredProperties", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getScopeForMemberDeclarationResolution", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "toString", "", "kotlin-compiler"})
public final class LazyPackageMemberScope
extends AbstractLazyMemberScope<PackageFragmentDescriptor, PackageMemberDeclarationProvider> {
    private final ResolveSession resolveSession;

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkParameterIsNotNull(kindFilter, "kindFilter");
        Intrinsics.checkParameterIsNotNull(nameFilter, "nameFilter");
        return this.computeDescriptorsFromDeclaredElements(kindFilter, nameFilter, NoLookupLocation.WHEN_GET_ALL_DESCRIPTORS);
    }

    @Override
    @NotNull
    protected LexicalScope getScopeForMemberDeclarationResolution(@NotNull KtDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        return this.resolveSession.getFileScopeProvider().getFileResolutionScope(declaration.getContainingKtFile());
    }

    @Override
    protected void getNonDeclaredFunctions(@NotNull Name name, @NotNull Set<SimpleFunctionDescriptor> result2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(result2, "result");
    }

    @Override
    protected void getNonDeclaredProperties(@NotNull Name name, @NotNull Set<PropertyDescriptor> result2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(result2, "result");
    }

    @Override
    @NotNull
    public String toString() {
        return "lazy scope for package " + ((PackageFragmentDescriptor)this.getThisDescriptor()).getName();
    }

    public LazyPackageMemberScope(@NotNull ResolveSession resolveSession, @NotNull PackageMemberDeclarationProvider declarationProvider, @NotNull PackageFragmentDescriptor thisPackage) {
        Intrinsics.checkParameterIsNotNull(resolveSession, "resolveSession");
        Intrinsics.checkParameterIsNotNull(declarationProvider, "declarationProvider");
        Intrinsics.checkParameterIsNotNull(thisPackage, "thisPackage");
        LazyClassContext lazyClassContext = resolveSession;
        DeclarationProvider declarationProvider2 = declarationProvider;
        DeclarationDescriptor declarationDescriptor = thisPackage;
        BindingTrace bindingTrace = resolveSession.getTrace();
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "resolveSession.trace");
        super(lazyClassContext, declarationProvider2, declarationDescriptor, bindingTrace);
        this.resolveSession = resolveSession;
    }
}

