/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class ResolveClassUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.ResolveClassUtil");

    @Nullable
    public static PsiClass resolveClass(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiFile containingFile) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveClassUtil", "resolveClass"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveClassUtil", "resolveClass"));
        }
        if (ref instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)ref).getKind(containingFile) == 6) {
            PsiElement parent2 = ref.getParent();
            if (parent2 instanceof PsiAnonymousClass) {
                parent2 = parent2.getParent();
            }
            if (!(parent2 instanceof PsiNewExpression)) {
                if (parent2 instanceof PsiJavaCodeReferenceElement) {
                    return null;
                }
                LOG.assertTrue(false);
                return null;
            }
            PsiExpression qualifier = ((PsiNewExpression)parent2).getQualifier();
            LOG.assertTrue(qualifier != null);
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return null;
            }
            if (!(qualifierType instanceof PsiClassType)) {
                return null;
            }
            PsiClass qualifierClass = PsiUtil.resolveClassInType(qualifierType);
            if (qualifierClass == null) {
                return null;
            }
            String name = ref.getText();
            return qualifierClass.findInnerClassByName(name, true);
        }
        PsiElement classNameElement = ref.getReferenceNameElement();
        if (!(classNameElement instanceof PsiIdentifier)) {
            return null;
        }
        String className2 = classNameElement.getText();
        ClassResolverProcessor processor = new ClassResolverProcessor(className2, ref, containingFile);
        PsiScopesUtil.resolveAndWalk(processor, ref, null);
        return processor.getResult().length == 1 ? (PsiClass)processor.getResult()[0].getElement() : null;
    }
}

