/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ProtectedConstructorCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "kotlin-compiler"})
public final class ProtectedConstructorCallChecker
implements CallChecker {
    public static final ProtectedConstructorCallChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BasicCallResolutionContext context) {
        block9: {
            boolean bl;
            KtExpression calleeExpression;
            DeclarationDescriptor scopeOwner;
            ConstructorDescriptor descriptor2;
            block8: {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
                Intrinsics.checkParameterIsNotNull(context, "context");
                Object obj = resolvedCall2.getResultingDescriptor();
                if (!(obj instanceof ConstructorDescriptor)) {
                    obj = null;
                }
                ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)obj;
                if (constructorDescriptor == null) {
                    return;
                }
                descriptor2 = constructorDescriptor;
                ClassDescriptor constructorOwner = descriptor2.getContainingDeclaration().getOriginal();
                scopeOwner = context.scope.getOwnerDescriptor();
                if (Intrinsics.areEqual(descriptor2.getVisibility().normalize(), Visibilities.PROTECTED) ^ true) {
                    return;
                }
                if (!Visibilities.isVisibleWithAnyReceiver(descriptor2, scopeOwner)) {
                    return;
                }
                KtExpression ktExpression = resolvedCall2.getCall().getCalleeExpression();
                if (ktExpression == null) {
                    return;
                }
                calleeExpression = ktExpression;
                Object object = calleeExpression;
                if (object instanceof KtConstructorCalleeExpression ? ((KtConstructorCalleeExpression)calleeExpression).getParent() instanceof KtSuperTypeCallEntry : object instanceof KtConstructorDelegationReferenceExpression) {
                    return;
                }
                object = DescriptorUtilsKt.getParentsWithSelf(scopeOwner);
                for (Object element$iv : $receiver$iv) {
                    DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                    if (!(it.getOriginal() == constructorOwner)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
            if (!Intrinsics.areEqual(Visibilities.findInvisibleMember(Visibilities.FALSE_IF_PROTECTED, descriptor2, scopeOwner), descriptor2)) break block9;
            context.trace.report(Errors.PROTECTED_CONSTRUCTOR_NOT_IN_SUPER_CALL.on((KtExpression)((PsiElement)calleeExpression), descriptor2));
        }
    }

    private ProtectedConstructorCallChecker() {
        INSTANCE = this;
    }

    static {
        new ProtectedConstructorCallChecker();
    }
}

