/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeProjectionImpl;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaClassOnCompanionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "kotlin-compiler"})
public final class JavaClassOnCompanionChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BasicCallResolutionContext context) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (!(descriptor2 instanceof PropertyDescriptor) || Intrinsics.areEqual(((PropertyDescriptor)descriptor2).getName().asString(), "javaClass") ^ true) {
            return;
        }
        DeclarationDescriptor container = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
        if (!(container instanceof PackageFragmentDescriptor) || Intrinsics.areEqual(((PackageFragmentDescriptor)container).getFqName().asString(), "kotlin.jvm") ^ true) {
            return;
        }
        KotlinType actualType = ((PropertyDescriptor)descriptor2).getType();
        Object object = CollectionsKt.singleOrNull(actualType.getArguments());
        if (!((object != null && (object = object.getType()) != null && (object = object.getConstructor()) != null ? object.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor companionObject = classDescriptor;
        if (companionObject.isCompanionObject()) {
            DeclarationDescriptor declarationDescriptor = companionObject.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor containingClass = (ClassDescriptor)declarationDescriptor;
            ClassifierDescriptor classifierDescriptor2 = actualType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
                classifierDescriptor2 = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor2;
            if (classDescriptor2 == null) {
                return;
            }
            ClassDescriptor javaLangClass = classDescriptor2;
            KotlinTypeImpl expectedType = KotlinTypeImpl.Companion.create(Annotations.Companion.getEMPTY(), javaLangClass, actualType.isMarkedNullable(), CollectionsKt.listOf(new TypeProjectionImpl(containingClass.getDefaultType())));
            context.trace.report(ErrorsJvm.JAVA_CLASS_ON_COMPANION.on((KtElement)((PsiElement)resolvedCall2.getCall().getCallElement()), actualType, expectedType));
        }
    }
}

