/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.VariableAccessInfo;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a&\u0010\u0016\u001a\u00020\u0006*\u00020\u00172\u0006\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0019\u001a\u0012\u0010\u001a\u001a\u00020\u0006*\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0006\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u0010\u001a\n\u0010\u001e\u001a\u00020\u001f*\u00020\u000b\u001a\n\u0010 \u001a\u00020\u001f*\u00020\u0002\u001a\n\u0010!\u001a\u00020\u001f*\u00020\u0010\u001a\n\u0010\"\u001a\u00020\u001f*\u00020\u0002\u001a\n\u0010#\u001a\u00020\u001f*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\n*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;", "getCallableDescriptor", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;)Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "calleeOwner", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsExpression;", "getCalleeOwner", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;)Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "functionName", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsName;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "getFunctionName", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;)Lcom/google/dart/compiler/backend/js/ast/JsName;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;", "getVariableDescriptor", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;)Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "variableName", "getVariableName", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;)Lcom/google/dart/compiler/backend/js/ast/JsName;", "aliasOrValue", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "value", "Lkotlin/Function1;", "constructAccessExpression", "ref", "getAccessFunctionName", "", "hasSpreadOperator", "", "isExtension", "isGetAccess", "isNative", "isSuperInvocation", "kotlin-compiler"})
public final class CallInfoExtensionsKt {
    @NotNull
    public static final CallableDescriptor getCallableDescriptor(@NotNull CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        CallableDescriptor callableDescriptor = $receiver.getResolvedCall().getResultingDescriptor().getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "resolvedCall.resultingDescriptor.original");
        return callableDescriptor;
    }

    public static final boolean isExtension(@NotNull CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getExtensionReceiver() != null;
    }

    public static final boolean isNative(@NotNull CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return AnnotationsUtils.isNativeObject(CallInfoExtensionsKt.getCallableDescriptor($receiver));
    }

    public static final boolean isSuperInvocation(@NotNull CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ReceiverValue dispatchReceiver = $receiver.getResolvedCall().getDispatchReceiver();
        return dispatchReceiver instanceof ExpressionReceiver && ((ExpressionReceiver)dispatchReceiver).getExpression() instanceof KtSuperExpression;
    }

    @NotNull
    public static final JsExpression getCalleeOwner(@NotNull CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DeclarationDescriptor calleeOwner = $receiver.getResolvedCall().getResultingDescriptor().getContainingDeclaration();
        JsExpression jsExpression = ReferenceTranslator.translateAsFQReference(calleeOwner, $receiver.getContext());
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "ReferenceTranslator.tran\u2026nce(calleeOwner, context)");
        return jsExpression;
    }

    @NotNull
    public static final VariableDescriptor getVariableDescriptor(@NotNull VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        CallableDescriptor callableDescriptor = CallInfoExtensionsKt.getCallableDescriptor($receiver);
        if (callableDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
        }
        return (VariableDescriptor)callableDescriptor;
    }

    @NotNull
    public static final JsName getVariableName(@NotNull VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsName jsName = $receiver.getContext().getNameForDescriptor(CallInfoExtensionsKt.getVariableDescriptor($receiver));
        Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForDescriptor(variableDescriptor)");
        return jsName;
    }

    public static final boolean isGetAccess(@NotNull VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getValue() == null;
    }

    @NotNull
    public static final String getAccessFunctionName(@NotNull VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        VariableDescriptor descriptor2 = CallInfoExtensionsKt.getVariableDescriptor($receiver);
        if (descriptor2 instanceof PropertyDescriptor && DescriptorUtilsKt.isExtension(descriptor2)) {
            PropertyAccessorDescriptor propertyAccessorDescriptor = CallInfoExtensionsKt.isGetAccess($receiver) ? (PropertyAccessorDescriptor)((PropertyDescriptor)descriptor2).getGetter() : (PropertyAccessorDescriptor)((PropertyDescriptor)descriptor2).getSetter();
            TranslationContext translationContext = $receiver.getContext();
            PropertyAccessorDescriptor propertyAccessorDescriptor2 = propertyAccessorDescriptor;
            if (propertyAccessorDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            String string = translationContext.getNameForDescriptor(propertyAccessorDescriptor2).getIdent();
            Intrinsics.checkExpressionValueIsNotNull(string, "context.getNameForDescri\u2026cessorDescriptor!!).ident");
            return string;
        }
        String string = Namer.getNameForAccessor(CallInfoExtensionsKt.getVariableName($receiver).getIdent(), CallInfoExtensionsKt.isGetAccess($receiver), false);
        Intrinsics.checkExpressionValueIsNotNull(string, "Namer.getNameForAccessor\u2026nt, isGetAccess(), false)");
        return string;
    }

    @NotNull
    public static final JsExpression constructAccessExpression(@NotNull VariableAccessInfo $receiver, @NotNull JsExpression ref) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        if (CallInfoExtensionsKt.isGetAccess($receiver)) {
            jsExpression = ref;
        } else {
            JsExpression jsExpression2 = ref;
            if (!(jsExpression2 instanceof HasMetadata)) {
                jsExpression2 = null;
            }
            HasMetadata hasMetadata = (HasMetadata)((Object)jsExpression2);
            if (hasMetadata != null) {
                HasMetadata hasMetadata2 = hasMetadata;
                HasMetadata it = hasMetadata2;
                MetadataProperties.setSideEffects(it, SideEffectKind.PURE);
            }
            JsExpression jsExpression3 = $receiver.getValue();
            if (jsExpression3 == null) {
                Intrinsics.throwNpe();
            }
            JsExpression jsExpression4 = JsAstUtils.assignment(ref, jsExpression3);
            jsExpression = jsExpression4;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression4, "JsAstUtils.assignment(ref, value!!)");
        }
        return jsExpression;
    }

    @NotNull
    public static final JsName getFunctionName(@NotNull FunctionCallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsName jsName = $receiver.getContext().getNameForDescriptor(CallInfoExtensionsKt.getCallableDescriptor($receiver));
        Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForDescriptor(callableDescriptor)");
        return jsName;
    }

    public static final boolean hasSpreadOperator(@NotNull FunctionCallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getArgumentsInfo().getHasSpreadOperator();
    }

    @NotNull
    public static final JsExpression aliasOrValue(@NotNull TranslationContext $receiver, @NotNull CallableDescriptor callableDescriptor, @NotNull Function1<? super CallableDescriptor, ? extends JsExpression> value) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(callableDescriptor, "callableDescriptor");
        Intrinsics.checkParameterIsNotNull(value, "value");
        JsExpression alias = $receiver.getAliasForDescriptor(callableDescriptor);
        if (alias != null) {
            return alias;
        }
        return value.invoke(callableDescriptor);
    }
}

