/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.resolve.AllUnderImportScope;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.FunctionImportedFromObject;
import org.jetbrains.kotlin.resolve.PackageFragmentWithCustomSource;
import org.jetbrains.kotlin.resolve.PropertyImportedFromObject;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.SingleImportScope;
import org.jetbrains.kotlin.resolve.calls.CallExpressionElement;
import org.jetbrains.kotlin.resolve.calls.CallExpressionUnrollerKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TypeParameterQualifier;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004UVWXB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J8\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\b\u0010%\u001a\u0004\u0018\u00010&JB\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u000b\u001a\u00020\f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J.\u0010*\u001a\u00020+2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010,\u001a\u00020-2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J&\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00101\u001a\u0002022\u0006\u0010 \u001a\u00020!2\u0006\u00109\u001a\u00020\u000fJ\"\u0010:\u001a\u0004\u0018\u00010;2\u0006\u00100\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010>2\u0006\u00103\u001a\u00020?J\u001e\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J0\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u00152\u0006\u00100\u001a\u00020\u00172\u0006\u00103\u001a\u00020?2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020\u000f0GJD\u0010H\u001a\u0004\u0018\u00010\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010I\u001a\u0004\u0018\u0001022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002Jh\u0010J\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u00190K2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010I\u001a\u0004\u0018\u0001022\u0006\u0010\u0012\u001a\u00020\u00132\u0016\b\u0002\u0010F\u001a\u0010\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020\u000f\u0018\u00010GH\u0002J\"\u0010L\u001a\u0004\u0018\u00010;2\u0006\u0010 \u001a\u00020!2\u0006\u0010M\u001a\u00020<2\u0006\u0010\u0010\u001a\u00020\nH\u0002JB\u0010N\u001a\u00020+2\u0006\u0010 \u001a\u00020!2\u0006\u0010M\u001a\u00020<2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\n0#2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010P\u001a\u00020\u000fH\u0002J@\u0010N\u001a\u0004\u0018\u00010;2\u0006\u0010 \u001a\u00020!2\u0006\u0010M\u001a\u00020<2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010P\u001a\u00020\u000fH\u0002J(\u0010Q\u001a\u00020+2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010R\u001a\b\u0012\u0004\u0012\u00020\f0\u0015*\u00020SH\u0002J\u001e\u0010R\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0015\u0012\u0004\u0012\u00020\u000f0K*\u000208H\u0002J6\u0010T\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u00190K*\u00020\u001f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006Y"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "", "classifierUsageCheckers", "", "Lorg/jetbrains/kotlin/resolve/ClassifierUsageChecker;", "(Ljava/lang/Iterable;)V", "getClassifierUsageCheckers", "()Ljava/lang/Iterable;", "collectCandidateDescriptors", "Lorg/jetbrains/kotlin/com/intellij/util/SmartList;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "lastPart", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "packageOrClassDescriptor", "isVisible", "", "descriptor", "shouldBeVisibleFrom", "position", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPosition;", "mapToQualifierParts", "", "qualifiedExpressions", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "skipLast", "", "processImportReference", "Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "aliasImportNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "packageFragmentForVisibilityCheck", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "processSingleImport", "Lorg/jetbrains/kotlin/resolve/SingleImportScope;", "path", "recordPackageViews", "", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "resolveClassOrPackageInQualifiedExpression", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifiedExpressionResolveResult;", "expression", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolveDescriptorForType", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$TypeQualifierResolutionResult;", "userType", "Lorg/jetbrains/kotlin/psi/KtUserType;", "isDebuggerContext", "resolveNameExpressionAsQualifierForDiagnostics", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "resolvePackageHeader", "packageDirective", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "module", "resolveQualifierInExpressionAndUnroll", "Lorg/jetbrains/kotlin/resolve/calls/CallExpressionElement;", "isValue", "Lkotlin/Function1;", "resolveToPackageOrClass", "scopeForFirstPart", "resolveToPackageOrClassPrefix", "Lkotlin/Pair;", "storeQualifier", "referenceExpression", "storeResult", "descriptors", "isQualifier", "tryResolveDescriptorsWhichCannotBeImported", "asQualifierPartList", "Lorg/jetbrains/kotlin/psi/KtExpression;", "quickResolveToPackage", "QualifiedExpressionResolveResult", "QualifierPart", "QualifierPosition", "TypeQualifierResolutionResult", "kotlin-compiler"})
public final class QualifiedExpressionResolver {
    @NotNull
    private final Iterable<ClassifierUsageChecker> classifierUsageCheckers;

    public final void resolvePackageHeader(@NotNull KtPackageDirective packageDirective, @NotNull ModuleDescriptor module, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(packageDirective, "packageDirective");
        Intrinsics.checkParameterIsNotNull(module, "module");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        List<KtSimpleNameExpression> packageNames = packageDirective.getPackageNames();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)packageNames)) {
            KtSimpleNameExpression nameExpression;
            int index2 = indexedValue.component1();
            KtSimpleNameExpression ktSimpleNameExpression = nameExpression = (KtSimpleNameExpression)indexedValue.component2();
            Intrinsics.checkExpressionValueIsNotNull(ktSimpleNameExpression, "nameExpression");
            FqName fqName2 = packageDirective.getFqName(nameExpression);
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageDirective.getFqName(nameExpression)");
            this.storeResult(trace, ktSimpleNameExpression, module.getPackage(fqName2), (DeclarationDescriptor)null, QualifierPosition.PACKAGE_HEADER, index2 != CollectionsKt.getLastIndex(packageNames));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeQualifierResolutionResult resolveDescriptorForType(@NotNull KtUserType userType, @NotNull LexicalScope scope, @NotNull BindingTrace trace, boolean isDebuggerContext) {
        void qualifierPartList;
        void hasError;
        DeclarationDescriptor ownerDescriptor;
        Intrinsics.checkParameterIsNotNull(userType, "userType");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        DeclarationDescriptor declarationDescriptor = ownerDescriptor = !isDebuggerContext ? scope.getOwnerDescriptor() : (DeclarationDescriptor)null;
        if (userType.getQualifier() == null) {
            ClassifierDescriptor classifierDescriptor;
            KtSimpleNameExpression ktSimpleNameExpression = userType.getReferenceExpression();
            if (ktSimpleNameExpression != null) {
                KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
                KtSimpleNameExpression it = ktSimpleNameExpression2;
                HierarchicalScope hierarchicalScope = scope;
                Name name = it.getReferencedNameAsName();
                KtElement ktElement = it;
                Intrinsics.checkExpressionValueIsNotNull(ktElement, "it");
                ClassifierDescriptor classifier2 = ScopeUtilsKt.findClassifier(hierarchicalScope, name, new KotlinLookupLocation(ktElement));
                KtSimpleNameExpression ktSimpleNameExpression3 = it;
                Intrinsics.checkExpressionValueIsNotNull(ktSimpleNameExpression3, "it");
                this.storeResult(trace, ktSimpleNameExpression3, classifier2, ownerDescriptor, QualifierPosition.TYPE, false);
                classifierDescriptor = classifier2;
            } else {
                classifierDescriptor = null;
            }
            ClassifierDescriptor descriptor2 = classifierDescriptor;
            return new TypeQualifierResolutionResult(this.asQualifierPartList(userType).getFirst(), descriptor2);
        }
        ModuleDescriptor module = DescriptorUtilsKt.getModule(scope.getOwnerDescriptor());
        Pair<List<QualifierPart>, Boolean> classifier2 = this.asQualifierPartList(userType);
        List<QualifierPart> list2 = classifier2.component1();
        boolean it = classifier2.component2();
        classifier2 = null;
        if (hasError != false) {
            DeclarationDescriptor declarationDescriptor2 = this.resolveToPackageOrClass((List<QualifierPart>)qualifierPartList, module, trace, ownerDescriptor, scope, QualifierPosition.TYPE);
            if (!(declarationDescriptor2 instanceof ClassifierDescriptor)) {
                declarationDescriptor2 = null;
            }
            ClassifierDescriptor descriptor3 = (ClassifierDescriptor)declarationDescriptor2;
            return new TypeQualifierResolutionResult((List<QualifierPart>)qualifierPartList, descriptor3);
        }
        boolean descriptor3 = qualifierPartList.size() >= 1;
        if (_Assertions.ENABLED && !descriptor3) {
            String string = "Too short qualifier list for user type " + userType + " : " + CollectionsKt.joinToString$default((Iterable)qualifierPartList, null, null, null, 0, null, null, 63, null);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        DeclarationDescriptor declarationDescriptor3 = this.resolveToPackageOrClass(qualifierPartList.subList(0, qualifierPartList.size() - 1), module, trace, ownerDescriptor, scope, QualifierPosition.TYPE);
        if (declarationDescriptor3 == null) {
            return new TypeQualifierResolutionResult((List<QualifierPart>)qualifierPartList, null);
        }
        DeclarationDescriptor qualifier = declarationDescriptor3;
        QualifierPart lastPart = (QualifierPart)CollectionsKt.last(qualifierPartList);
        DeclarationDescriptor declarationDescriptor4 = qualifier;
        ClassifierDescriptor classifier3 = declarationDescriptor4 instanceof PackageViewDescriptor ? ((PackageViewDescriptor)qualifier).getMemberScope().getContributedClassifier(lastPart.getName(), lastPart.getLocation()) : (declarationDescriptor4 instanceof ClassDescriptor ? ((ClassDescriptor)qualifier).getUnsubstitutedInnerClassesScope().getContributedClassifier(lastPart.getName(), lastPart.getLocation()) : (ClassifierDescriptor)null);
        this.storeResult(trace, lastPart.getExpression(), classifier3, ownerDescriptor, QualifierPosition.TYPE, false);
        return new TypeQualifierResolutionResult((List<QualifierPart>)qualifierPartList, classifier3);
    }

    private final Pair<List<QualifierPart>, Boolean> asQualifierPartList(@NotNull KtUserType $receiver) {
        boolean hasError = false;
        SmartList<QualifierPart> result2 = new SmartList<QualifierPart>();
        for (KtUserType userType = $receiver; userType != null; userType = userType.getQualifier()) {
            KtSimpleNameExpression referenceExpression = userType.getReferenceExpression();
            if (referenceExpression != null) {
                result2.add(new QualifierPart(referenceExpression.getReferencedNameAsName(), referenceExpression, userType.getTypeArgumentList()));
                continue;
            }
            hasError = true;
        }
        return TuplesKt.to(CollectionsKt.asReversedMutable((List)result2), hasError);
    }

    @Nullable
    public final ImportingScope processImportReference(@NotNull KtImportDirective importDirective, @NotNull ModuleDescriptor moduleDescriptor, @NotNull BindingTrace trace, @NotNull Collection<FqName> aliasImportNames, @Nullable PackageFragmentDescriptor packageFragmentForVisibilityCheck) {
        PackageFragmentDescriptor packageFragmentForCheck;
        PackageFragmentDescriptor packageFragmentDescriptor;
        Intrinsics.checkParameterIsNotNull(importDirective, "importDirective");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(aliasImportNames, "aliasImportNames");
        KtExpression ktExpression = importDirective.getImportedReference();
        if (ktExpression == null) {
            return null;
        }
        KtExpression importedReference = ktExpression;
        List<QualifierPart> path = this.asQualifierPartList(importedReference);
        QualifierPart qualifierPart = CollectionsKt.lastOrNull(path);
        if (qualifierPart == null) {
            return null;
        }
        QualifierPart lastPart = qualifierPart;
        if (CodeFragmentUtilKt.suppressDiagnosticsInDebugMode(importDirective)) {
            packageFragmentDescriptor = null;
        } else if (packageFragmentForVisibilityCheck instanceof DeclarationDescriptorWithSource && Intrinsics.areEqual(packageFragmentForVisibilityCheck.getSource(), SourceElement.NO_SOURCE)) {
            KtElement ktElement = importDirective.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull(ktElement, "importDirective.getContainingKtFile()");
            packageFragmentDescriptor = new PackageFragmentWithCustomSource(packageFragmentForVisibilityCheck, new KotlinSourceElement(ktElement));
        } else {
            packageFragmentDescriptor = packageFragmentForCheck = packageFragmentForVisibilityCheck;
        }
        if (importDirective.isAllUnder()) {
            DeclarationDescriptor declarationDescriptor = this.resolveToPackageOrClass(path, moduleDescriptor, trace, packageFragmentForCheck, null, QualifierPosition.IMPORT);
            if (declarationDescriptor == null) {
                return null;
            }
            DeclarationDescriptor packageOrClassDescriptor = declarationDescriptor;
            if (packageOrClassDescriptor instanceof ClassDescriptor && ((ClassDescriptor)packageOrClassDescriptor).getKind().isSingleton()) {
                trace.report(Errors.CANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON.on((KtSimpleNameExpression)((PsiElement)lastPart.getExpression()), (ClassDescriptor)packageOrClassDescriptor));
                return null;
            }
            return new AllUnderImportScope(packageOrClassDescriptor, aliasImportNames);
        }
        return this.processSingleImport(moduleDescriptor, trace, importDirective, path, lastPart, packageFragmentForCheck);
    }

    /*
     * WARNING - void declaration
     */
    private final SingleImportScope processSingleImport(ModuleDescriptor moduleDescriptor, BindingTrace trace, KtImportDirective importDirective, List<QualifierPart> path, QualifierPart lastPart, PackageFragmentDescriptor packageFragmentForVisibilityCheck) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Name aliasName = KtPsiUtil.getAliasName(importDirective);
        if (aliasName == null) {
            this.resolveToPackageOrClass(path, moduleDescriptor, trace, packageFragmentForVisibilityCheck, null, QualifierPosition.IMPORT);
            return null;
        }
        DeclarationDescriptor declarationDescriptor = this.resolveToPackageOrClass(path.subList(0, path.size() - 1), moduleDescriptor, trace, packageFragmentForVisibilityCheck, null, QualifierPosition.IMPORT);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor packageOrClassDescriptor = declarationDescriptor;
        SmartList<DeclarationDescriptor> candidates = this.collectCandidateDescriptors(lastPart, packageOrClassDescriptor);
        Collection collection = candidates;
        if (!(!collection.isEmpty())) {
            this.tryResolveDescriptorsWhichCannotBeImported(trace, moduleDescriptor, packageOrClassDescriptor, lastPart);
            return null;
        }
        this.storeResult(trace, lastPart.getExpression(), (Collection<? extends DeclarationDescriptor>)candidates, (DeclarationDescriptor)packageFragmentForVisibilityCheck, QualifierPosition.IMPORT, false);
        Iterable iterable = candidates;
        void var12_12 = $receiver$iv;
        Collection collection2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            DeclarationDescriptor it;
            DeclarationDescriptor declarationDescriptor2 = it = (DeclarationDescriptor)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "it");
            if (!this.isVisible(declarationDescriptor2, packageFragmentForVisibilityCheck, QualifierPosition.IMPORT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = AddToStdlibKt.check((List)destination$iv$iv, processSingleImport.importedDescriptors.2.INSTANCE);
        if (list2 == null) {
            list2 = candidates;
        }
        List importedDescriptors2 = list2;
        return new SingleImportScope(aliasName, importedDescriptors2);
    }

    /*
     * WARNING - void declaration
     */
    private final SmartList<DeclarationDescriptor> collectCandidateDescriptors(QualifierPart lastPart, DeclarationDescriptor packageOrClassDescriptor) {
        SmartList<DeclarationDescriptor> descriptors = new SmartList<DeclarationDescriptor>();
        Name lastName = lastPart.getName();
        KotlinLookupLocation location2 = lastPart.getLocation();
        DeclarationDescriptor declarationDescriptor = packageOrClassDescriptor;
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            MemberScope packageScope = ((PackageViewDescriptor)packageOrClassDescriptor).getMemberScope();
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)descriptors, packageScope.getContributedClassifier(lastName, location2));
            descriptors.addAll(packageScope.getContributedVariables(lastName, location2));
            descriptors.addAll(packageScope.getContributedFunctions(lastName, location2));
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)descriptors, ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedInnerClassesScope().getContributedClassifier(lastName, location2));
            MemberScope staticClassScope = ((ClassDescriptor)packageOrClassDescriptor).getStaticScope();
            descriptors.addAll(staticClassScope.getContributedFunctions(lastName, location2));
            descriptors.addAll(staticClassScope.getContributedVariables(lastName, location2));
            if (Intrinsics.areEqual((Object)((ClassDescriptor)packageOrClassDescriptor).getKind(), (Object)ClassKind.OBJECT)) {
                Collection destination$iv$iv;
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Object object;
                void destination$iv$iv2;
                Iterable $receiver$iv$iv2;
                void $receiver$iv2;
                Iterable iterable = ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedMemberScope().getContributedFunctions(lastName, location2);
                Collection<DeclarationDescriptor> collection = descriptors;
                void var10_11 = $receiver$iv2;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void it;
                    SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)item$iv$iv;
                    object = destination$iv$iv2;
                    FunctionImportedFromObject functionImportedFromObject = new FunctionImportedFromObject((FunctionDescriptor)it);
                    object.add(functionImportedFromObject);
                }
                object = (List)destination$iv$iv2;
                ((AbstractCollection)collection).addAll((Collection)object);
                $receiver$iv$iv2 = ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedMemberScope().getContributedVariables(lastName, location2);
                destination$iv$iv2 = $receiver$iv;
                Collection collection3 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof PropertyDescriptor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    PropertyDescriptor $i$f$filterIsInstanceTo = (PropertyDescriptor)item$iv$iv;
                    collection = destination$iv$iv;
                    object = new PropertyImportedFromObject((PropertyDescriptor)it);
                    collection.add((DeclarationDescriptor)object);
                }
                List properties2 = (List)destination$iv$iv;
                descriptors.addAll(properties2);
            }
        } else {
            throw (Throwable)new IllegalStateException("Should be class or package: " + packageOrClassDescriptor);
        }
        return descriptors;
    }

    private final void tryResolveDescriptorsWhichCannotBeImported(BindingTrace trace, ModuleDescriptor moduleDescriptor, DeclarationDescriptor packageOrClassDescriptor, QualifierPart lastPart) {
        SmartList<DeclarationDescriptor> descriptors = new SmartList<DeclarationDescriptor>();
        Name lastName = lastPart.getName();
        DeclarationDescriptor declarationDescriptor = packageOrClassDescriptor;
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            FqName fqName2 = ((PackageViewDescriptor)packageOrClassDescriptor).getFqName().child(lastName);
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageOrClassDescriptor.fqName.child(lastName)");
            PackageViewDescriptor packageDescriptor = moduleDescriptor.getPackage(fqName2);
            if (!packageDescriptor.isEmpty()) {
                trace.report(Errors.PACKAGE_CANNOT_BE_IMPORTED.on((KtSimpleNameExpression)((PsiElement)lastPart.getExpression())));
                descriptors.add(packageOrClassDescriptor);
            }
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            MemberScope memberScope2 = ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedMemberScope();
            descriptors.addAll(memberScope2.getContributedFunctions(lastName, lastPart.getLocation()));
            descriptors.addAll(memberScope2.getContributedVariables(lastName, lastPart.getLocation()));
            Collection collection = descriptors;
            if (!collection.isEmpty()) {
                trace.report(Errors.CANNOT_BE_IMPORTED.on((KtSimpleNameExpression)((PsiElement)lastPart.getExpression()), lastName));
            }
        } else {
            throw (Throwable)new IllegalStateException("Should be class or package: " + packageOrClassDescriptor);
        }
        this.storeResult(trace, lastPart.getExpression(), (Collection<? extends DeclarationDescriptor>)descriptors, (DeclarationDescriptor)null, QualifierPosition.IMPORT, false);
    }

    private final List<QualifierPart> asQualifierPartList(@NotNull KtExpression $receiver) {
        SmartList<QualifierPart> result2 = new SmartList<QualifierPart>();
        KtExpression expression = $receiver;
        while (expression != null) {
            KtExpression ktExpression = expression;
            if (ktExpression instanceof KtSimpleNameExpression) {
                result2.add(new QualifierPart(((KtSimpleNameExpression)expression).getReferencedNameAsName(), (KtSimpleNameExpression)expression, null, 4, null));
                break;
            }
            if (ktExpression instanceof KtQualifiedExpression) {
                KtExpression ktExpression2 = ((KtQualifiedExpression)expression).getSelectorExpression();
                if (!(ktExpression2 instanceof KtSimpleNameExpression)) {
                    ktExpression2 = null;
                }
                if ((KtSimpleNameExpression)ktExpression2 != null) {
                    KtSimpleNameExpression ktSimpleNameExpression;
                    KtSimpleNameExpression it = ktSimpleNameExpression;
                    result2.add(new QualifierPart(it.getReferencedNameAsName(), it, null, 4, null));
                }
                expression = ((KtQualifiedExpression)expression).getReceiverExpression();
                continue;
            }
            expression = null;
        }
        return CollectionsKt.asReversedMutable((List)result2);
    }

    /*
     * WARNING - void declaration
     */
    private final DeclarationDescriptor resolveToPackageOrClass(List<QualifierPart> path, ModuleDescriptor moduleDescriptor, BindingTrace trace, DeclarationDescriptor shouldBeVisibleFrom, LexicalScope scopeForFirstPart, QualifierPosition position) {
        void packageOrClassDescriptor;
        void endIndex;
        Pair pair = QualifiedExpressionResolver.resolveToPackageOrClassPrefix$default(this, path, moduleDescriptor, trace, shouldBeVisibleFrom, scopeForFirstPart, position, null, 64, null);
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)pair.component1();
        int n = ((Number)pair.component2()).intValue();
        pair = null;
        if (endIndex != path.size()) {
            return null;
        }
        return packageOrClassDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<DeclarationDescriptor, Integer> resolveToPackageOrClassPrefix(List<QualifierPart> path, ModuleDescriptor moduleDescriptor, BindingTrace trace, DeclarationDescriptor shouldBeVisibleFrom, LexicalScope scopeForFirstPart, QualifierPosition position, Function1<? super KtSimpleNameExpression, Boolean> isValue) {
        void nextIndexAfterPrefix;
        void prefixDescriptor;
        ClassifierDescriptor classifierDescriptor;
        ClassifierDescriptor classifierDescriptor2;
        Object object;
        if (path.isEmpty()) {
            FqName fqName2 = FqName.ROOT;
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "FqName.ROOT");
            return new Pair<DeclarationDescriptor, Integer>(moduleDescriptor.getPackage(fqName2), 0);
        }
        QualifierPart firstPart = CollectionsKt.first(path);
        if (Intrinsics.areEqual((Object)position, (Object)QualifierPosition.EXPRESSION) && scopeForFirstPart != null && isValue != null && isValue.invoke(firstPart.getExpression()).booleanValue()) {
            return new Pair<Object, Integer>(null, 0);
        }
        LexicalScope lexicalScope = scopeForFirstPart;
        if (lexicalScope != null) {
            object = lexicalScope;
            LexicalScope it = object;
            classifierDescriptor2 = ScopeUtilsKt.findClassifier(it, firstPart.getName(), firstPart.getLocation());
        } else {
            classifierDescriptor2 = classifierDescriptor = null;
        }
        if (classifierDescriptor != null) {
            QualifiedExpressionResolver.storeResult$default(this, trace, firstPart.getExpression(), classifierDescriptor, shouldBeVisibleFrom, position, false, 32, null);
        }
        Pair<Object, Integer> $i$a$1$let = classifierDescriptor != null ? new Pair<Object, Integer>(classifierDescriptor, 1) : this.quickResolveToPackage(moduleDescriptor, path, trace, position);
        object = (DeclarationDescriptor)$i$a$1$let.component1();
        int it = ((Number)$i$a$1$let.component2()).intValue();
        $i$a$1$let = null;
        DeclarationDescriptor currentDescriptor = prefixDescriptor;
        void var13_14 = nextIndexAfterPrefix;
        int n = path.size() - 1;
        if (var13_14 <= n) {
            while (true) {
                DeclarationDescriptor nextPackageOrClassDescriptor;
                DeclarationDescriptor declarationDescriptor;
                void qualifierPartIndex;
                QualifierPart qualifierPart = path.get((int)qualifierPartIndex);
                DeclarationDescriptor declarationDescriptor2 = currentDescriptor;
                if (declarationDescriptor2 instanceof ClassDescriptor) {
                    declarationDescriptor = ((ClassDescriptor)currentDescriptor).getUnsubstitutedInnerClassesScope().getContributedClassifier(qualifierPart.getName(), qualifierPart.getLocation());
                } else if (declarationDescriptor2 instanceof PackageViewDescriptor) {
                    PackageViewDescriptor packageView;
                    PackageViewDescriptor packageViewDescriptor;
                    if (qualifierPart.getTypeArguments() == null) {
                        FqName fqName3 = ((PackageViewDescriptor)currentDescriptor).getFqName().child(qualifierPart.getName());
                        Intrinsics.checkExpressionValueIsNotNull(fqName3, "currentDescriptor.fqName.child(qualifierPart.name)");
                        packageViewDescriptor = moduleDescriptor.getPackage(fqName3);
                    } else {
                        packageViewDescriptor = packageView = (PackageViewDescriptor)null;
                    }
                    declarationDescriptor = packageView != null && !packageView.isEmpty() ? (DeclarationDescriptor)packageView : (DeclarationDescriptor)((PackageViewDescriptor)currentDescriptor).getMemberScope().getContributedClassifier(qualifierPart.getName(), qualifierPart.getLocation());
                } else {
                    declarationDescriptor = nextPackageOrClassDescriptor = (DeclarationDescriptor)null;
                }
                if (!Intrinsics.areEqual((Object)position, (Object)QualifierPosition.EXPRESSION) || nextPackageOrClassDescriptor != null) {
                    QualifiedExpressionResolver.storeResult$default(this, trace, qualifierPart.getExpression(), nextPackageOrClassDescriptor, shouldBeVisibleFrom, position, false, 32, null);
                }
                if (nextPackageOrClassDescriptor == null) {
                    return new Pair<DeclarationDescriptor, Integer>(currentDescriptor, (int)qualifierPartIndex);
                }
                currentDescriptor = nextPackageOrClassDescriptor;
                if (qualifierPartIndex == n) break;
                ++qualifierPartIndex;
            }
        }
        return new Pair<void, Integer>((void)currentDescriptor, path.size());
    }

    static /* bridge */ /* synthetic */ Pair resolveToPackageOrClassPrefix$default(QualifiedExpressionResolver qualifiedExpressionResolver, List list2, ModuleDescriptor moduleDescriptor, BindingTrace bindingTrace, DeclarationDescriptor declarationDescriptor, LexicalScope lexicalScope, QualifierPosition qualifierPosition, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveToPackageOrClassPrefix");
        }
        if ((n & 0x40) != 0) {
            function1 = null;
        }
        return qualifiedExpressionResolver.resolveToPackageOrClassPrefix(list2, moduleDescriptor, bindingTrace, declarationDescriptor, lexicalScope, qualifierPosition, function1);
    }

    @Nullable
    public final Qualifier resolveNameExpressionAsQualifierForDiagnostics(@NotNull KtSimpleNameExpression expression, @Nullable Receiver receiver, @NotNull ExpressionTypingContext context) {
        DeclarationDescriptor qualifierDescriptor2;
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Name name = expression.getReferencedNameAsName();
        KotlinLookupLocation location2 = new KotlinLookupLocation(expression);
        Receiver receiver2 = receiver;
        if (receiver2 instanceof PackageQualifier) {
            FqName childPackageFQN = ((PackageQualifier)receiver).getDescriptor().getFqName().child(name);
            ModuleDescriptor moduleDescriptor = ((PackageQualifier)receiver).getDescriptor().getModule();
            FqName fqName2 = childPackageFQN;
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "childPackageFQN");
            PackageViewDescriptor packageViewDescriptor = AddToStdlibKt.check(moduleDescriptor.getPackage(fqName2), resolveNameExpressionAsQualifierForDiagnostics.qualifierDescriptor.1.INSTANCE);
            declarationDescriptor = packageViewDescriptor != null ? (DeclarationDescriptor)packageViewDescriptor : (DeclarationDescriptor)((PackageQualifier)receiver).getDescriptor().getMemberScope().getContributedClassifier(name, location2);
        } else if (receiver2 instanceof ClassQualifier) {
            declarationDescriptor = ((ClassQualifier)receiver).getStaticScope().getContributedClassifier(name, location2);
        } else if (Intrinsics.areEqual(receiver2, null)) {
            ClassifierDescriptor classifierDescriptor = ScopeUtilsKt.findClassifier(context.scope, name, location2);
            if (classifierDescriptor != null) {
                declarationDescriptor = classifierDescriptor;
            } else {
                ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule(context.scope.getOwnerDescriptor());
                FqName fqName3 = FqName.ROOT.child(name);
                Intrinsics.checkExpressionValueIsNotNull(fqName3, "FqName.ROOT.child(name)");
                declarationDescriptor = AddToStdlibKt.check(moduleDescriptor.getPackage(fqName3), resolveNameExpressionAsQualifierForDiagnostics.qualifierDescriptor.2.INSTANCE);
            }
        } else {
            declarationDescriptor = qualifierDescriptor2 = receiver2 instanceof ReceiverValue ? (DeclarationDescriptor)ScopeUtilsKt.findClassifier(ScopeUtilsKt.memberScopeAsImportingScope$default(((ReceiverValue)receiver).getType().getMemberScope(), null, 1, null), name, location2) : (DeclarationDescriptor)null;
        }
        if (qualifierDescriptor2 != null) {
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            return QualifiedExpressionResolver.storeResult$default(this, bindingTrace, expression, qualifierDescriptor2, context.scope.getOwnerDescriptor(), QualifierPosition.EXPRESSION, false, 32, null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final QualifiedExpressionResolveResult resolveClassOrPackageInQualifiedExpression(@NotNull KtQualifiedExpression expression, @NotNull LexicalScope scope, @NotNull BindingContext context) {
        void index2;
        void result2;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(context, "context");
        List<KtQualifiedExpression> qualifiedExpressions = CallExpressionUnrollerKt.unrollToLeftMostQualifiedExpression(expression);
        List<QualifierPart> path = this.mapToQualifierParts(qualifiedExpressions, 0);
        DelegatingBindingTrace trace = new DelegatingBindingTrace(context, "Temp trace for resolving qualified expression");
        Pair pair = QualifiedExpressionResolver.resolveToPackageOrClassPrefix$default(this, path, DescriptorUtilsKt.getModule(scope.getOwnerDescriptor()), trace, scope.getOwnerDescriptor(), scope, QualifierPosition.EXPRESSION, null, 64, null);
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)pair.component1();
        int n = ((Number)pair.component2()).intValue();
        pair = null;
        if (result2 == null) {
            return QualifiedExpressionResolveResult.Companion.getUNRESOLVED();
        }
        void var7_8 = index2;
        return var7_8 == path.size() ? new QualifiedExpressionResolveResult((DeclarationDescriptor)result2, null) : (var7_8 == path.size() - 1 ? new QualifiedExpressionResolveResult((DeclarationDescriptor)result2, path.get((int)index2).getName()) : QualifiedExpressionResolveResult.Companion.getUNRESOLVED());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CallExpressionElement> resolveQualifierInExpressionAndUnroll(@NotNull KtQualifiedExpression expression, @NotNull ExpressionTypingContext context, @NotNull Function1<? super KtSimpleNameExpression, Boolean> isValue) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(isValue, "isValue");
        List<KtQualifiedExpression> qualifiedExpressions = CallExpressionUnrollerKt.unrollToLeftMostQualifiedExpression(expression);
        List<QualifierPart> maxPossibleQualifierPrefix = this.mapToQualifierParts(qualifiedExpressions, 1);
        ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule(context.scope.getOwnerDescriptor());
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        int nextIndexAfterPrefix = ((Number)this.resolveToPackageOrClassPrefix(maxPossibleQualifierPrefix, moduleDescriptor, bindingTrace, context.scope.getOwnerDescriptor(), context.scope, QualifierPosition.EXPRESSION, isValue).getSecond()).intValue();
        int nextExpressionIndexAfterQualifier = nextIndexAfterPrefix == 0 ? 0 : nextIndexAfterPrefix - 1;
        Iterable iterable = qualifiedExpressions.subList(nextExpressionIndexAfterQualifier, qualifiedExpressions.size());
        void var9_9 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)item$iv$iv;
            void var14_14 = destination$iv$iv;
            CallExpressionElement callExpressionElement = new CallExpressionElement((KtQualifiedExpression)it);
            var14_14.add(callExpressionElement);
        }
        return (List)destination$iv$iv;
    }

    private final List<QualifierPart> mapToQualifierParts(List<? extends KtQualifiedExpression> qualifiedExpressions, int skipLast) {
        if (qualifiedExpressions.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        KtQualifiedExpression first = CollectionsKt.first(qualifiedExpressions);
        if (!(first instanceof KtDotQualifiedExpression)) {
            return CollectionsKt.emptyList();
        }
        KtExpression firstReceiver = first.getReceiverExpression();
        if (!(firstReceiver instanceof KtSimpleNameExpression)) {
            return CollectionsKt.emptyList();
        }
        ArrayList<QualifierPart> qualifierParts = CollectionsKt.arrayListOf(new QualifierPart[0]);
        qualifierParts.add(new QualifierPart((KtSimpleNameExpression)firstReceiver));
        for (KtQualifiedExpression ktQualifiedExpression : CollectionsKt.dropLast(qualifiedExpressions, skipLast)) {
            KtExpression selector;
            if (!(ktQualifiedExpression instanceof KtDotQualifiedExpression) || !((selector = ktQualifiedExpression.getSelectorExpression()) instanceof KtSimpleNameExpression)) break;
            qualifierParts.add(new QualifierPart((KtSimpleNameExpression)selector));
        }
        return qualifierParts;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<PackageViewDescriptor, Integer> quickResolveToPackage(@NotNull ModuleDescriptor $receiver, List<QualifierPart> path, BindingTrace trace, QualifierPosition position) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        int n;
        Object item$iv2;
        block5: {
            void $receiver$iv2;
            List<QualifierPart> list2 = path;
            int index$iv = 0;
            for (Object item$iv2 : $receiver$iv2) {
                QualifierPart it = (QualifierPart)item$iv2;
                if (it.getTypeArguments() != null) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        int $receiver$iv2 = n;
        int it22 = $receiver$iv2;
        int possiblePackagePrefixSize = it22 == -1 ? path.size() : it22 + 1;
        Iterable it22 = path.subList(0, possiblePackagePrefixSize);
        void $i$a$2$let = $receiver$iv;
        item$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            QualifierPart $i$f$indexOfFirst = (QualifierPart)item$iv$iv;
            void var13_17 = destination$iv$iv;
            String string = it.getName().asString();
            var13_17.add(string);
        }
        FqName fqName2 = FqName.fromSegments((List)destination$iv$iv);
        int prefixSize = possiblePackagePrefixSize;
        while (!fqName2.isRoot()) {
            FqName fqName3 = fqName2;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName");
            PackageViewDescriptor packageDescriptor = $receiver.getPackage(fqName3);
            if (!packageDescriptor.isEmpty()) {
                this.recordPackageViews(path.subList(0, prefixSize), packageDescriptor, trace, position);
                return new Pair<PackageViewDescriptor, Integer>(packageDescriptor, prefixSize);
            }
            fqName2 = fqName2.parent();
            --prefixSize;
        }
        FqName fqName4 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull(fqName4, "FqName.ROOT");
        return new Pair<PackageViewDescriptor, Integer>($receiver.getPackage(fqName4), 0);
    }

    /*
     * WARNING - void declaration
     */
    private final void recordPackageViews(List<QualifierPart> path, PackageViewDescriptor packageView, BindingTrace trace, QualifierPosition position) {
        void $receiver$iv;
        List<QualifierPart> list2 = path;
        PackageViewDescriptor accumulator$iv = packageView;
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                void currentView;
                PackageViewDescriptor packageViewDescriptor = accumulator$iv;
                QualifierPart qualifierPart = (QualifierPart)iterator$iv.previous();
                QualifiedExpressionResolver.storeResult$default(this, trace, qualifierPart.getExpression(), (DeclarationDescriptor)currentView, null, position, false, 32, null);
                if (currentView.getContainingDeclaration() != null) continue;
                String string = "Containing Declaration must be not null for package with fqName: " + currentView.getFqName() + ", " + ("path: " + CollectionsKt.joinToString$default(path, null, null, null, 0, null, null, 63, null) + ", packageView fqName: " + packageView.getFqName());
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void storeResult(BindingTrace trace, KtSimpleNameExpression referenceExpression, Collection<? extends DeclarationDescriptor> descriptors, DeclarationDescriptor shouldBeVisibleFrom, QualifierPosition position, boolean isQualifier) {
        if (descriptors.size() > 1) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = descriptors;
            void var8_8 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                if (!this.isVisible(it, shouldBeVisibleFrom, position)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List visibleDescriptors = (List)destination$iv$iv;
            if (visibleDescriptors.isEmpty()) {
                Object t = CollectionsKt.first((Iterable)descriptors);
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility");
                }
                DeclarationDescriptorWithVisibility descriptor2 = (DeclarationDescriptorWithVisibility)t;
                trace.report(Errors.INVISIBLE_REFERENCE.on((KtSimpleNameExpression)((PsiElement)referenceExpression), descriptor2, descriptor2.getVisibility(), descriptor2));
            } else if (visibleDescriptors.size() > 1) {
                trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, referenceExpression, visibleDescriptors);
            } else {
                this.storeResult(trace, referenceExpression, (DeclarationDescriptor)CollectionsKt.single(visibleDescriptors), (DeclarationDescriptor)null, position, isQualifier);
            }
        } else {
            this.storeResult(trace, referenceExpression, (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)descriptors), shouldBeVisibleFrom, position, isQualifier);
        }
    }

    private final Qualifier storeResult(BindingTrace trace, KtSimpleNameExpression referenceExpression, DeclarationDescriptor descriptor2, DeclarationDescriptor shouldBeVisibleFrom, QualifierPosition position, boolean isQualifier) {
        if (descriptor2 == null) {
            trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)referenceExpression), referenceExpression));
            return null;
        }
        trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, descriptor2);
        if (descriptor2 instanceof ClassifierDescriptor) {
            for (ClassifierUsageChecker checker : this.classifierUsageCheckers) {
                checker.check((ClassifierDescriptor)descriptor2, trace, referenceExpression);
            }
        }
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility) {
            DeclarationDescriptor fromToCheck;
            DeclarationDescriptor declarationDescriptor = fromToCheck = shouldBeVisibleFrom instanceof PackageFragmentDescriptor && Intrinsics.areEqual(((PackageFragmentDescriptor)shouldBeVisibleFrom).getSource(), SourceElement.NO_SOURCE) && !(referenceExpression.getContainingFile() instanceof DummyHolder) ? (DeclarationDescriptor)new PackageFragmentWithCustomSource((PackageFragmentDescriptor)shouldBeVisibleFrom, new KotlinSourceElement(referenceExpression.getContainingKtFile())) : shouldBeVisibleFrom;
            if (!this.isVisible(descriptor2, fromToCheck, position)) {
                trace.report(Errors.INVISIBLE_REFERENCE.on((KtSimpleNameExpression)((PsiElement)referenceExpression), descriptor2, ((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), descriptor2));
            }
        }
        return isQualifier ? this.storeQualifier(trace, referenceExpression, descriptor2) : (Qualifier)null;
    }

    static /* bridge */ /* synthetic */ Qualifier storeResult$default(QualifiedExpressionResolver qualifiedExpressionResolver, BindingTrace bindingTrace, KtSimpleNameExpression ktSimpleNameExpression, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, QualifierPosition qualifierPosition, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: storeResult");
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return qualifiedExpressionResolver.storeResult(bindingTrace, ktSimpleNameExpression, declarationDescriptor, declarationDescriptor2, qualifierPosition, bl);
    }

    private final Qualifier storeQualifier(BindingTrace trace, KtSimpleNameExpression referenceExpression, DeclarationDescriptor descriptor2) {
        Qualifier qualifier;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            qualifier = new PackageQualifier(referenceExpression, (PackageViewDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            qualifier = new ClassQualifier(referenceExpression, (ClassDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof TypeParameterDescriptor) {
            qualifier = new TypeParameterQualifier(referenceExpression, (TypeParameterDescriptor)descriptor2);
        } else {
            return null;
        }
        Qualifier qualifier2 = qualifier;
        trace.record(BindingContext.QUALIFIER, QualifierKt.getExpression(qualifier2), qualifier2);
        return qualifier2;
    }

    private final boolean isVisible(DeclarationDescriptor descriptor2, DeclarationDescriptor shouldBeVisibleFrom, QualifierPosition position) {
        if (!(descriptor2 instanceof DeclarationDescriptorWithVisibility) || shouldBeVisibleFrom == null) {
            return true;
        }
        Visibility visibility = ((DeclarationDescriptorWithVisibility)descriptor2).getVisibility();
        if (Intrinsics.areEqual((Object)position, (Object)QualifierPosition.IMPORT)) {
            if (Visibilities.isPrivate(visibility)) {
                return false;
            }
            if (!visibility.mustCheckInImports()) {
                return true;
            }
        }
        return Visibilities.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)descriptor2, shouldBeVisibleFrom);
    }

    @NotNull
    public final Iterable<ClassifierUsageChecker> getClassifierUsageCheckers() {
        return this.classifierUsageCheckers;
    }

    public QualifiedExpressionResolver(@NotNull Iterable<? extends ClassifierUsageChecker> classifierUsageCheckers) {
        Intrinsics.checkParameterIsNotNull(classifierUsageCheckers, "classifierUsageCheckers");
        this.classifierUsageCheckers = classifierUsageCheckers;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J%\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$TypeQualifierResolutionResult;", "", "qualifierParts", "", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "classifierDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "(Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)V", "allProjections", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "getAllProjections", "()Ljava/util/List;", "getClassifierDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getQualifierParts", "component1", "component2", "copy", "kotlin-compiler"})
    public static final class TypeQualifierResolutionResult {
        @NotNull
        private final List<QualifierPart> qualifierParts;
        @Nullable
        private final ClassifierDescriptor classifierDescriptor;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtTypeProjection> getAllProjections() {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv = this.qualifierParts;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                QualifierPart it = (QualifierPart)element$iv$iv;
                KtTypeArgumentList ktTypeArgumentList = it.getTypeArguments();
                List<KtTypeProjection> list2 = ktTypeArgumentList != null ? ktTypeArgumentList.getArguments() : null;
                List<KtTypeProjection> list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            return (List)var3_3;
        }

        @NotNull
        public final List<QualifierPart> getQualifierParts() {
            return this.qualifierParts;
        }

        @Nullable
        public final ClassifierDescriptor getClassifierDescriptor() {
            return this.classifierDescriptor;
        }

        public TypeQualifierResolutionResult(@NotNull List<QualifierPart> qualifierParts, @Nullable ClassifierDescriptor classifierDescriptor) {
            Intrinsics.checkParameterIsNotNull(qualifierParts, "qualifierParts");
            this.qualifierParts = qualifierParts;
            this.classifierDescriptor = classifierDescriptor;
        }

        public /* synthetic */ TypeQualifierResolutionResult(List list2, ClassifierDescriptor classifierDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                classifierDescriptor = null;
            }
            this(list2, classifierDescriptor);
        }

        @NotNull
        public final List<QualifierPart> component1() {
            return this.qualifierParts;
        }

        @Nullable
        public final ClassifierDescriptor component2() {
            return this.classifierDescriptor;
        }

        @NotNull
        public final TypeQualifierResolutionResult copy(@NotNull List<QualifierPart> qualifierParts, @Nullable ClassifierDescriptor classifierDescriptor) {
            Intrinsics.checkParameterIsNotNull(qualifierParts, "qualifierParts");
            return new TypeQualifierResolutionResult(qualifierParts, classifierDescriptor);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ TypeQualifierResolutionResult copy$default(TypeQualifierResolutionResult typeQualifierResolutionResult, List list2, ClassifierDescriptor classifierDescriptor, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                list2 = typeQualifierResolutionResult.qualifierParts;
            }
            if ((n & 2) != 0) {
                classifierDescriptor = typeQualifierResolutionResult.classifierDescriptor;
            }
            return typeQualifierResolutionResult.copy(list2, classifierDescriptor);
        }

        public String toString() {
            return "TypeQualifierResolutionResult(qualifierParts=" + this.qualifierParts + ", classifierDescriptor=" + this.classifierDescriptor + ")";
        }

        public int hashCode() {
            List<QualifierPart> list2 = this.qualifierParts;
            ClassifierDescriptor classifierDescriptor = this.classifierDescriptor;
            return (list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (classifierDescriptor != null ? classifierDescriptor.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TypeQualifierResolutionResult)) break block3;
                    TypeQualifierResolutionResult typeQualifierResolutionResult = (TypeQualifierResolutionResult)object;
                    if (!Intrinsics.areEqual(this.qualifierParts, typeQualifierResolutionResult.qualifierParts) || !Intrinsics.areEqual(this.classifierDescriptor, typeQualifierResolutionResult.classifierDescriptor)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J)\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)V", "name", "Lorg/jetbrains/kotlin/name/Name;", "typeArguments", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "location", "Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "getLocation", "()Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getTypeArguments", "()Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "component1", "component2", "component3", "copy", "kotlin-compiler"})
    public static final class QualifierPart {
        @NotNull
        private final KotlinLookupLocation location;
        @NotNull
        private final Name name;
        @NotNull
        private final KtSimpleNameExpression expression;
        @Nullable
        private final KtTypeArgumentList typeArguments;

        @NotNull
        public final KotlinLookupLocation getLocation() {
            return this.location;
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        @NotNull
        public final KtSimpleNameExpression getExpression() {
            return this.expression;
        }

        @Nullable
        public final KtTypeArgumentList getTypeArguments() {
            return this.typeArguments;
        }

        public QualifierPart(@NotNull Name name, @NotNull KtSimpleNameExpression expression, @Nullable KtTypeArgumentList typeArguments2) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            this.name = name;
            this.expression = expression;
            this.typeArguments = typeArguments2;
            this.location = new KotlinLookupLocation(this.expression);
        }

        public /* synthetic */ QualifierPart(Name name, KtSimpleNameExpression ktSimpleNameExpression, KtTypeArgumentList ktTypeArgumentList, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                ktTypeArgumentList = null;
            }
            this(name, ktSimpleNameExpression, ktTypeArgumentList);
        }

        public QualifierPart(@NotNull KtSimpleNameExpression expression) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            this(expression.getReferencedNameAsName(), expression, null, 4, null);
        }

        @NotNull
        public final Name component1() {
            return this.name;
        }

        @NotNull
        public final KtSimpleNameExpression component2() {
            return this.expression;
        }

        @Nullable
        public final KtTypeArgumentList component3() {
            return this.typeArguments;
        }

        @NotNull
        public final QualifierPart copy(@NotNull Name name, @NotNull KtSimpleNameExpression expression, @Nullable KtTypeArgumentList typeArguments2) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            return new QualifierPart(name, expression, typeArguments2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ QualifierPart copy$default(QualifierPart qualifierPart, Name name, KtSimpleNameExpression ktSimpleNameExpression, KtTypeArgumentList ktTypeArgumentList, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                name = qualifierPart.name;
            }
            if ((n & 2) != 0) {
                ktSimpleNameExpression = qualifierPart.expression;
            }
            if ((n & 4) != 0) {
                ktTypeArgumentList = qualifierPart.typeArguments;
            }
            return qualifierPart.copy(name, ktSimpleNameExpression, ktTypeArgumentList);
        }

        public String toString() {
            return "QualifierPart(name=" + this.name + ", expression=" + this.expression + ", typeArguments=" + this.typeArguments + ")";
        }

        public int hashCode() {
            Name name = this.name;
            KtSimpleNameExpression ktSimpleNameExpression = this.expression;
            KtTypeArgumentList ktTypeArgumentList = this.typeArguments;
            return ((name != null ? ((Object)name).hashCode() : 0) * 31 + (ktSimpleNameExpression != null ? ktSimpleNameExpression.hashCode() : 0)) * 31 + (ktTypeArgumentList != null ? ktTypeArgumentList.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QualifierPart)) break block3;
                    QualifierPart qualifierPart = (QualifierPart)object;
                    if (!Intrinsics.areEqual(this.name, qualifierPart.name) || !Intrinsics.areEqual(this.expression, qualifierPart.expression) || !Intrinsics.areEqual(this.typeArguments, qualifierPart.typeArguments)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPosition;", "", "(Ljava/lang/String;I)V", "PACKAGE_HEADER", "IMPORT", "TYPE", "EXPRESSION", "kotlin-compiler"})
    private static final class QualifierPosition
    extends Enum<QualifierPosition> {
        public static final /* enum */ QualifierPosition PACKAGE_HEADER;
        public static final /* enum */ QualifierPosition IMPORT;
        public static final /* enum */ QualifierPosition TYPE;
        public static final /* enum */ QualifierPosition EXPRESSION;
        private static final /* synthetic */ QualifierPosition[] $VALUES;

        static {
            QualifierPosition[] qualifierPositionArray = new QualifierPosition[4];
            QualifierPosition[] qualifierPositionArray2 = qualifierPositionArray;
            qualifierPositionArray[0] = PACKAGE_HEADER = new QualifierPosition();
            qualifierPositionArray[1] = IMPORT = new QualifierPosition();
            qualifierPositionArray[2] = TYPE = new QualifierPosition();
            qualifierPositionArray[3] = EXPRESSION = new QualifierPosition();
            $VALUES = qualifierPositionArray;
        }

        public static QualifierPosition[] values() {
            return (QualifierPosition[])$VALUES.clone();
        }

        public static QualifierPosition valueOf(String string) {
            return Enum.valueOf(QualifierPosition.class, string);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\b\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifiedExpressionResolveResult;", "", "classOrPackage", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "memberName", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/name/Name;)V", "getClassOrPackage", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getMemberName", "()Lorg/jetbrains/kotlin/name/Name;", "component1", "component2", "copy", "Companion", "kotlin-compiler"})
    public static final class QualifiedExpressionResolveResult {
        @Nullable
        private final DeclarationDescriptor classOrPackage;
        @Nullable
        private final Name memberName;
        @NotNull
        private static final QualifiedExpressionResolveResult UNRESOLVED;
        public static final Companion Companion;

        @Nullable
        public final DeclarationDescriptor getClassOrPackage() {
            return this.classOrPackage;
        }

        @Nullable
        public final Name getMemberName() {
            return this.memberName;
        }

        public QualifiedExpressionResolveResult(@Nullable DeclarationDescriptor classOrPackage, @Nullable Name memberName) {
            this.classOrPackage = classOrPackage;
            this.memberName = memberName;
        }

        static {
            Companion = new Companion(null);
            UNRESOLVED = new QualifiedExpressionResolveResult(null, null);
        }

        @Nullable
        public final DeclarationDescriptor component1() {
            return this.classOrPackage;
        }

        @Nullable
        public final Name component2() {
            return this.memberName;
        }

        @NotNull
        public final QualifiedExpressionResolveResult copy(@Nullable DeclarationDescriptor classOrPackage, @Nullable Name memberName) {
            return new QualifiedExpressionResolveResult(classOrPackage, memberName);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ QualifiedExpressionResolveResult copy$default(QualifiedExpressionResolveResult qualifiedExpressionResolveResult, DeclarationDescriptor declarationDescriptor, Name name, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                declarationDescriptor = qualifiedExpressionResolveResult.classOrPackage;
            }
            if ((n & 2) != 0) {
                name = qualifiedExpressionResolveResult.memberName;
            }
            return qualifiedExpressionResolveResult.copy(declarationDescriptor, name);
        }

        public String toString() {
            return "QualifiedExpressionResolveResult(classOrPackage=" + this.classOrPackage + ", memberName=" + this.memberName + ")";
        }

        public int hashCode() {
            DeclarationDescriptor declarationDescriptor = this.classOrPackage;
            Name name = this.memberName;
            return (declarationDescriptor != null ? declarationDescriptor.hashCode() : 0) * 31 + (name != null ? ((Object)name).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QualifiedExpressionResolveResult)) break block3;
                    QualifiedExpressionResolveResult qualifiedExpressionResolveResult = (QualifiedExpressionResolveResult)object;
                    if (!Intrinsics.areEqual(this.classOrPackage, qualifiedExpressionResolveResult.classOrPackage) || !Intrinsics.areEqual(this.memberName, qualifiedExpressionResolveResult.memberName)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifiedExpressionResolveResult$Companion;", "", "()V", "UNRESOLVED", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifiedExpressionResolveResult;", "getUNRESOLVED", "()Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifiedExpressionResolveResult;", "kotlin-compiler"})
        public static final class Companion {
            @NotNull
            public final QualifiedExpressionResolveResult getUNRESOLVED() {
                return UNRESOLVED;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

