/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiParameterStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;

public class PsiParameterStubImpl
extends StubBase<PsiParameter>
implements PsiParameterStub {
    private StringRef myName;
    private final TypeInfo myType;
    private byte myFlags;

    private static byte packFlags(boolean isEllipsis, boolean generatedName) {
        byte flags = 0;
        flags = BitUtil.set(flags, (byte)1, isEllipsis);
        flags = BitUtil.set(flags, (byte)2, generatedName);
        return flags;
    }

    public PsiParameterStubImpl(StubElement parent2, @NotNull String name, @NotNull TypeInfo type2, boolean ellipsis, boolean generatedName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "<init>"));
        }
        this(parent2, StringRef.fromString(name), type2, PsiParameterStubImpl.packFlags(ellipsis, generatedName));
    }

    public PsiParameterStubImpl(StubElement parent2, @NotNull StringRef name, @NotNull TypeInfo type2, byte flags) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "<init>"));
        }
        super(parent2, JavaStubElementTypes.PARAMETER);
        this.myName = name;
        this.myType = type2;
        this.myFlags = flags;
    }

    @Override
    public boolean isParameterTypeEllipsis() {
        return BitUtil.isSet(this.myFlags, (byte)1);
    }

    @Override
    @NotNull
    public TypeInfo getType(boolean doResolve) {
        TypeInfo typeInfo = doResolve ? this.myType.applyAnnotations(this) : this.myType;
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "getType"));
        }
        return typeInfo;
    }

    @Override
    public PsiModifierListStub getModList() {
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiModifierListStub)) continue;
            return (PsiModifierListStub)child;
        }
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = StringRef.toString(this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "getName"));
        }
        return string;
    }

    public void setName(String name) {
        this.myName = StringRef.fromString(name);
        this.myFlags = BitUtil.set(this.myFlags, (byte)2, false);
    }

    public boolean isAutoGeneratedName() {
        return BitUtil.isSet(this.myFlags, (byte)2);
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Override
    public String toString() {
        return "PsiParameterStub[" + this.myName + ':' + this.myType + ']';
    }
}

