/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class NonClasspathDirectoriesScope
extends GlobalSearchScope {
    private final Set<VirtualFile> myRoots;

    public NonClasspathDirectoriesScope(@NotNull Collection<VirtualFile> roots2) {
        if (roots2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/psi/search/NonClasspathDirectoriesScope", "<init>"));
        }
        this.myRoots = ContainerUtil.newHashSet(roots2);
    }

    @Override
    public boolean isSearchOutsideRootModel() {
        return true;
    }

    @NotNull
    public static GlobalSearchScope compose(@NotNull List<VirtualFile> roots2) {
        if (roots2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/psi/search/NonClasspathDirectoriesScope", "compose"));
        }
        if (roots2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/NonClasspathDirectoriesScope", "compose"));
            }
            return globalSearchScope;
        }
        NonClasspathDirectoriesScope nonClasspathDirectoriesScope = new NonClasspathDirectoriesScope(roots2);
        if (nonClasspathDirectoriesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/NonClasspathDirectoriesScope", "compose"));
        }
        return nonClasspathDirectoriesScope;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/search/NonClasspathDirectoriesScope", "contains"));
        }
        return VfsUtilCore.isUnder(file, this.myRoots);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "org/jetbrains/kotlin/com/intellij/psi/search/NonClasspathDirectoriesScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "org/jetbrains/kotlin/com/intellij/psi/search/NonClasspathDirectoriesScope", "compare"));
        }
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "org/jetbrains/kotlin/com/intellij/psi/search/NonClasspathDirectoriesScope", "isSearchInModuleContent"));
        }
        return false;
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonClasspathDirectoriesScope)) {
            return false;
        }
        NonClasspathDirectoriesScope that = (NonClasspathDirectoriesScope)o;
        return this.myRoots.equals(that.myRoots);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myRoots.hashCode();
        return result2;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if (this.myRoots.size() == 1) {
            VirtualFile root = this.myRoots.iterator().next();
            String string = "Directory '" + root.getName() + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/NonClasspathDirectoriesScope", "getDisplayName"));
            }
            return string;
        }
        String string = "Directories " + StringUtil.join(this.myRoots, new Function<VirtualFile, String>(){

            @Override
            public String fun(VirtualFile file) {
                return "'" + file.getName() + "'";
            }
        }, ", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/NonClasspathDirectoriesScope", "getDisplayName"));
        }
        return string;
    }
}

