/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtBinaryExpression
extends KtExpressionImpl
implements KtOperationExpression {
    public KtBinaryExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtBinaryExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtBinaryExpression", "accept"));
        }
        return visitor2.visitBinaryExpression(this, data);
    }

    @IfNotParsed
    @Nullable
    public KtExpression getLeft() {
        for (ASTNode node = this.getOperationReference().getNode().getTreePrev(); node != null; node = node.getTreePrev()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof KtExpression)) continue;
            return (KtExpression)psi;
        }
        return null;
    }

    @IfNotParsed
    @Nullable
    public KtExpression getRight() {
        for (ASTNode node = this.getOperationReference().getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof KtExpression)) continue;
            return (KtExpression)psi;
        }
        return null;
    }

    @Override
    @NotNull
    public KtOperationReferenceExpression getOperationReference() {
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)this.findChildByType(KtNodeTypes.OPERATION_REFERENCE);
        if (ktOperationReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtBinaryExpression", "getOperationReference"));
        }
        return ktOperationReferenceExpression;
    }

    @NotNull
    public IElementType getOperationToken() {
        IElementType iElementType = this.getOperationReference().getReferencedNameElementType();
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtBinaryExpression", "getOperationToken"));
        }
        return iElementType;
    }
}

