/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtLambdaExpression
extends LazyParseablePsiElement
implements KtExpression {
    public KtLambdaExpression(CharSequence text) {
        super(KtNodeTypes.LAMBDA_EXPRESSION, text);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtLambdaExpression", "accept"));
        }
        return visitor2.visitLambdaExpression(this, data);
    }

    @NotNull
    public KtFunctionLiteral getFunctionLiteral() {
        KtFunctionLiteral ktFunctionLiteral = this.findChildByType(KtNodeTypes.FUNCTION_LITERAL).getPsi(KtFunctionLiteral.class);
        if (ktFunctionLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtLambdaExpression", "getFunctionLiteral"));
        }
        return ktFunctionLiteral;
    }

    @NotNull
    public List<KtParameter> getValueParameters() {
        List<KtParameter> list2 = this.getFunctionLiteral().getValueParameters();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtLambdaExpression", "getValueParameters"));
        }
        return list2;
    }

    @Nullable
    public KtBlockExpression getBodyExpression() {
        return this.getFunctionLiteral().getBodyExpression();
    }

    public boolean hasDeclaredReturnType() {
        return this.getFunctionLiteral().getTypeReference() != null;
    }

    @NotNull
    public KtElement asElement() {
        KtLambdaExpression ktLambdaExpression = this;
        if (ktLambdaExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtLambdaExpression", "asElement"));
        }
        return ktLambdaExpression;
    }

    @NotNull
    public ASTNode getLeftCurlyBrace() {
        ASTNode aSTNode = this.getFunctionLiteral().getNode().findChildByType(KtTokens.LBRACE);
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtLambdaExpression", "getLeftCurlyBrace"));
        }
        return aSTNode;
    }

    @Nullable
    public ASTNode getRightCurlyBrace() {
        return this.getFunctionLiteral().getNode().findChildByType(KtTokens.RBRACE);
    }

    @Override
    @NotNull
    public KtFile getContainingKtFile() {
        PsiFile file = this.getContainingFile();
        assert (file instanceof KtFile) : "KtElement not inside KtFile: " + file + " " + file.getText();
        KtFile ktFile = (KtFile)file;
        if (ktFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtLambdaExpression", "getContainingKtFile"));
        }
        return ktFile;
    }

    @Override
    public <D> void acceptChildren(@NotNull KtVisitor<Void, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtLambdaExpression", "acceptChildren"));
        }
        KtPsiUtil.visitChildren(this, visitor2, data);
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtLambdaExpression", "accept"));
        }
        if (visitor2 instanceof KtVisitor) {
            this.accept((KtVisitor)visitor2, null);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return this.getNode().getElementType().toString();
    }
}

