/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.callableReferences;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a<\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"createReflectionTypeForCallableDescriptor", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "lhsType", "reflectionTypes", "Lorg/jetbrains/kotlin/builtins/ReflectionTypes;", "ignoreReceiver", "", "scopeOwnerDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolvePossiblyAmbiguousCallableReference", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "callableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "resolutionMode", "Lorg/jetbrains/kotlin/resolve/calls/callResolverUtil/ResolveArgumentsMode;", "callResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "kotlin-compiler"})
public final class CallableReferencesResolutionUtilsKt {
    @Nullable
    public static final OverloadResolutionResults<CallableDescriptor> resolvePossiblyAmbiguousCallableReference(@NotNull KtCallableReferenceExpression callableReferenceExpression, @Nullable KotlinType lhsType, @NotNull ResolutionContext<?> context, @NotNull ResolveArgumentsMode resolutionMode, @NotNull CallResolver callResolver) {
        ClassQualifier qualifier;
        OverloadResolutionResults<CallableDescriptor> possibleStatic;
        KtSimpleNameExpression referenceExpression;
        Intrinsics.checkParameterIsNotNull(callableReferenceExpression, "callableReferenceExpression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull((Object)resolutionMode, "resolutionMode");
        Intrinsics.checkParameterIsNotNull(callResolver, "callResolver");
        KtSimpleNameExpression reference = callableReferenceExpression.getCallableReference();
        Function2<String, Receiver, OverloadResolutionResults<CallableDescriptor>> resolveWithReceiver$ = new Function2<String, Receiver, OverloadResolutionResults<CallableDescriptor>>(reference, context, resolutionMode, callResolver){
            final /* synthetic */ KtSimpleNameExpression $reference;
            final /* synthetic */ ResolutionContext $context;
            final /* synthetic */ ResolveArgumentsMode $resolutionMode;
            final /* synthetic */ CallResolver $callResolver;

            @Nullable
            public final OverloadResolutionResults<CallableDescriptor> invoke(@Nullable String traceTitle, @Nullable Receiver receiver) {
                boolean shouldCommitTrace;
                Call call = CallMaker.makeCall(this.$reference, receiver, null, this.$reference, CollectionsKt.<T>emptyList());
                TemporaryTraceAndCache temporaryTrace = TemporaryTraceAndCache.create(this.$context, traceTitle, this.$reference);
                Context newContext = Intrinsics.areEqual((Object)((Object)this.$resolutionMode), (Object)((Object)ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS)) ? ((ResolutionContext)this.$context.replaceTraceAndCache(temporaryTrace)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE) : this.$context.replaceTraceAndCache(temporaryTrace);
                OverloadResolutionResults resolutionResults = this.$callResolver.resolveCallForMember(this.$reference, BasicCallResolutionContext.create(newContext, call, CheckArgumentTypesMode.CHECK_CALLABLE_TYPE));
                boolean bl = Intrinsics.areEqual((Object)((Object)this.$resolutionMode), (Object)((Object)ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS)) ? resolutionResults.isSingleResult() : (shouldCommitTrace = !resolutionResults.isNothing());
                if (shouldCommitTrace) {
                    temporaryTrace.commit();
                }
                return resolutionResults.isNothing() ? (OverloadResolutionResults)null : resolutionResults;
            }
            {
                this.$reference = ktSimpleNameExpression;
                this.$context = resolutionContext;
                this.$resolutionMode = resolveArgumentsMode;
                this.$callResolver = callResolver;
                super(2);
            }
        };
        if (lhsType == null) {
            return resolveWithReceiver$.invoke("resolve callable reference with empty LHS", (Receiver)null);
        }
        ClassifierDescriptor classifier2 = lhsType.getConstructor().getDeclarationDescriptor();
        if (!(classifier2 instanceof ClassDescriptor)) {
            context.trace.report(Errors.CALLABLE_REFERENCE_LHS_NOT_A_CLASS.on((KtExpression)((PsiElement)callableReferenceExpression)));
            return null;
        }
        KtTypeReference ktTypeReference = callableReferenceExpression.getTypeReference();
        KtTypeElement ktTypeElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        if (!(ktTypeElement instanceof KtUserType)) {
            ktTypeElement = null;
        }
        KtUserType ktUserType = (KtUserType)ktTypeElement;
        KtSimpleNameExpression ktSimpleNameExpression = referenceExpression = ktUserType != null ? ktUserType.getReferenceExpression() : null;
        if (referenceExpression != null && (possibleStatic = resolveWithReceiver$.invoke("resolve unbound callable reference in static scope", (Receiver)(qualifier = new ClassQualifier(referenceExpression, (ClassDescriptor)classifier2)))) != null) {
            return possibleStatic;
        }
        return resolveWithReceiver$.invoke("trace to resolve ::" + reference.getReferencedName() + " with receiver", (Receiver)new TransientReceiver(lhsType));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final KotlinType createReflectionTypeForCallableDescriptor(@NotNull CallableDescriptor descriptor, @Nullable KotlinType lhsType, @NotNull ReflectionTypes reflectionTypes, boolean ignoreReceiver, @NotNull DeclarationDescriptor scopeOwnerDescriptor) {
        block18: {
            block17: {
                Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
                Intrinsics.checkParameterIsNotNull(reflectionTypes, "reflectionTypes");
                Intrinsics.checkParameterIsNotNull(scopeOwnerDescriptor, "scopeOwnerDescriptor");
                extensionReceiver = descriptor.getExtensionReceiverParameter();
                v0 = descriptor.getDispatchReceiverParameter();
                if (v0 != null) {
                    var6_6 = v0;
                    dispatchReceiver = var6_6;
                    v1 = descriptor;
                    if (!(v1 instanceof CallableMemberDescriptor)) {
                        v1 = null;
                    }
                    v2 = (CallableMemberDescriptor)v1;
                    v3 = Intrinsics.areEqual((Object)(v2 != null ? v2.getKind() : null), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE) != false ? DescriptorUtils.getDispatchReceiverParameterIfNeeded(descriptor.getContainingDeclaration()) : dispatchReceiver;
                } else {
                    v3 = dispatchReceiver = null;
                }
                if (!(extensionReceiver == null && dispatchReceiver == null || ignoreReceiver)) {
                    v4 = lhsType;
                    if (v4 == null) {
                        v5 = extensionReceiver;
                        v4 = v6 = v5 != null ? v5.getType() : null;
                    }
                    if (v4 == null) {
                        v7 = dispatchReceiver;
                        v6 = v7 != null ? v7.getType() : null;
                    }
                } else {
                    v6 = null;
                }
                receiverType = v6;
                var7_7 = descriptor;
                if (var7_7 instanceof FunctionDescriptor) {
                    v8 = ((FunctionDescriptor)descriptor).getReturnType();
                    if (v8 == null) {
                        return null;
                    }
                    returnType = v8;
                    valueParametersTypes = ExpressionTypingUtils.getValueParametersTypes(((FunctionDescriptor)descriptor).getValueParameters());
                    v9 = Annotations.Companion.getEMPTY();
                    v10 = valueParametersTypes;
                    Intrinsics.checkExpressionValueIsNotNull(v10, "valueParametersTypes");
                    v11 = returnType;
                    Intrinsics.checkExpressionValueIsNotNull(v11, "returnType");
                    return reflectionTypes.getKFunctionType(v9, receiverType, v10, v11);
                }
                if (!(var7_7 instanceof PropertyDescriptor)) break block17;
                if (!((PropertyDescriptor)descriptor).isVar()) ** GOTO lbl-1000
                setter = ((PropertyDescriptor)descriptor).getSetter();
                if (setter == null) ** GOTO lbl-1000
                v12 = receiverType;
                if (v12 != null) {
                    var11_13 = v12;
                    p1 = var11_13;
                    v13 = new TransientReceiver(p1);
                } else {
                    v13 = null;
                }
                if (Visibilities.isVisible(v13, setter, scopeOwnerDescriptor)) lbl-1000:
                // 2 sources

                {
                    v14 = true;
                } else {
                    v14 = false;
                }
                if (v14) {
                    v15 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v15 = false;
                }
                mutable = v15;
                v16 = Annotations.Companion.getEMPTY();
                v17 = ((PropertyDescriptor)descriptor).getType();
                Intrinsics.checkExpressionValueIsNotNull(v17, "descriptor.type");
                v18 = reflectionTypes.getKPropertyType(v16, receiverType, v17, mutable);
                break block18;
            }
            if (var7_7 instanceof VariableDescriptor) {
                v18 = null;
            } else {
                throw (Throwable)new UnsupportedOperationException("Callable reference resolved to an unsupported descriptor: " + descriptor);
            }
        }
        return v18;
    }
}

