/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.slicedMap;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.collect.ArrayListMultimap;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.util.slicedMap.AbstractWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.KeyWithSlice;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.RewritePolicy;
import org.jetbrains.kotlin.util.slicedMap.UserDataHolderImpl;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class SlicedMapImpl
implements MutableSlicedMap {
    private final Map<Object, UserDataHolderImpl> map = new THashMap<Object, UserDataHolderImpl>(0);
    private Multimap<WritableSlice<?, ?>, Object> collectiveSliceKeys = null;

    public static SlicedMapImpl create() {
        return new SlicedMapImpl();
    }

    @Override
    public <K, V> void put(WritableSlice<K, V> slice, K key, V value) {
        Object oldValue;
        if (!slice.check(key, value)) {
            return;
        }
        UserDataHolderImpl holder = this.map.get(key);
        if (holder == null) {
            holder = new UserDataHolderImpl();
            this.map.put(key, holder);
        }
        KeyWithSlice<K, V, WritableSlice<K, V>> sliceKey = slice.getKey();
        RewritePolicy rewritePolicy = slice.getRewritePolicy();
        if (rewritePolicy.rewriteProcessingNeeded(key) && (oldValue = holder.getUserData(sliceKey)) != null && !rewritePolicy.processRewrite(slice, key, oldValue, value)) {
            return;
        }
        if (slice.isCollective()) {
            if (this.collectiveSliceKeys == null) {
                this.collectiveSliceKeys = ArrayListMultimap.create();
            }
            this.collectiveSliceKeys.put(slice, key);
        }
        holder.putUserData(sliceKey, value);
        slice.afterPut(this, key, value);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.collectiveSliceKeys = null;
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        UserDataHolderImpl holder = this.map.get(key);
        Object value = holder == null ? null : (Object)holder.getUserData(slice.getKey());
        return slice.computeValue(this, key, value, value == null);
    }

    @Override
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        assert (slice.isCollective()) : "Keys are not collected for slice " + slice;
        if (this.collectiveSliceKeys == null) {
            return Collections.emptyList();
        }
        return this.collectiveSliceKeys.get(slice);
    }

    @Override
    public void forEach(@NotNull Function3<WritableSlice, Object, Object, Void> f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl", "forEach"));
        }
        for (Map.Entry<Object, UserDataHolderImpl> entry : this.map.entrySet()) {
            Object key = entry.getKey();
            UserDataHolderImpl holder = entry.getValue();
            if (holder == null) continue;
            for (Key<?> sliceKey : holder.getKeys()) {
                Object value = holder.getUserData(sliceKey);
                f.invoke((WritableSlice)((AbstractWritableSlice)sliceKey).getSlice(), key, value);
            }
        }
    }

    @Override
    @NotNull
    public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
        if (slice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl", "getSliceContents"));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Object, UserDataHolderImpl> entry : this.map.entrySet()) {
            UserDataHolder holder = entry.getValue();
            Object value = holder.getUserData(slice.getKey());
            if (value == null) continue;
            builder.put(entry.getKey(), value);
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl", "getSliceContents"));
        }
        return immutableMap;
    }
}

