/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.DelegatingClassBuilder;
import org.jetbrains.kotlin.codegen.optimization.OptimizationMethodVisitor;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class OptimizationClassBuilder
extends DelegatingClassBuilder {
    private final ClassBuilder delegate;
    private final boolean disableOptimization;

    public OptimizationClassBuilder(@NotNull ClassBuilder delegate2, boolean disableOptimization) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/codegen/optimization/OptimizationClassBuilder", "<init>"));
        }
        this.delegate = delegate2;
        this.disableOptimization = disableOptimization;
    }

    @Override
    @NotNull
    public ClassBuilder getDelegate() {
        ClassBuilder classBuilder2 = this.delegate;
        if (classBuilder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/OptimizationClassBuilder", "getDelegate"));
        }
        return classBuilder2;
    }

    @Override
    @NotNull
    public MethodVisitor newMethod(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/optimization/OptimizationClassBuilder", "newMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/optimization/OptimizationClassBuilder", "newMethod"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/optimization/OptimizationClassBuilder", "newMethod"));
        }
        OptimizationMethodVisitor optimizationMethodVisitor = new OptimizationMethodVisitor(super.newMethod(origin, access, name, desc, signature2, exceptions), this.disableOptimization, access, name, desc, signature2, exceptions);
        if (optimizationMethodVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/OptimizationClassBuilder", "newMethod"));
        }
        return optimizationMethodVisitor;
    }
}

