/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.mock;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.util.Function;

public class MockFileDocumentManagerImpl
extends FileDocumentManager {
    private static final Key<VirtualFile> MOCK_VIRTUAL_FILE_KEY = Key.create("MockVirtualFile");
    private final Function<CharSequence, Document> myFactory;
    @Nullable
    private final Key<Document> myCachedDocumentKey;
    private static final Key<Document> MOCK_DOC_KEY = Key.create("MOCK_DOC_KEY");

    public MockFileDocumentManagerImpl(Function<CharSequence, Document> factory, @Nullable Key<Document> cachedDocumentKey) {
        this.myFactory = factory;
        this.myCachedDocumentKey = cachedDocumentKey;
    }

    private static boolean isBinaryWithoutDecompiler(VirtualFile file) {
        FileType ft = file.getFileType();
        return ft.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) == null;
    }

    @Override
    public Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/mock/MockFileDocumentManagerImpl", "getDocument"));
        }
        Document document = file.getUserData(MOCK_DOC_KEY);
        if (document == null) {
            if (file.isDirectory() || MockFileDocumentManagerImpl.isBinaryWithoutDecompiler(file)) {
                return null;
            }
            CharSequence text = LoadTextUtil.loadText(file);
            document = this.myFactory.fun(text);
            document.putUserData(MOCK_VIRTUAL_FILE_KEY, file);
            document = file.putUserDataIfAbsent(MOCK_DOC_KEY, document);
        }
        return document;
    }

    @Override
    public Document getCachedDocument(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/mock/MockFileDocumentManagerImpl", "getCachedDocument"));
        }
        if (this.myCachedDocumentKey != null) {
            return file.getUserData(this.myCachedDocumentKey);
        }
        return null;
    }

    @Override
    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/mock/MockFileDocumentManagerImpl", "getFile"));
        }
        return document.getUserData(MOCK_VIRTUAL_FILE_KEY);
    }

    @Override
    public void saveDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/mock/MockFileDocumentManagerImpl", "saveDocument"));
        }
    }

    @Override
    public void saveDocumentAsIs(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/mock/MockFileDocumentManagerImpl", "saveDocumentAsIs"));
        }
    }

    @Override
    public boolean isDocumentUnsaved(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/mock/MockFileDocumentManagerImpl", "isDocumentUnsaved"));
        }
        return false;
    }

    @Override
    public boolean isFileModified(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/mock/MockFileDocumentManagerImpl", "isFileModified"));
        }
        return false;
    }

    @Override
    public void reloadFromDisk(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/mock/MockFileDocumentManagerImpl", "reloadFromDisk"));
        }
    }

    @Override
    @NotNull
    public String getLineSeparator(VirtualFile file, Project project) {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/mock/MockFileDocumentManagerImpl", "getLineSeparator"));
        }
        return "";
    }
}

