/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.gnu.trove.THashMap;

public class PsiPrimitiveType
extends PsiType.Stub {
    private static final Map<String, PsiPrimitiveType> ourQNameToUnboxed = new THashMap<String, PsiPrimitiveType>();
    private static final Map<PsiPrimitiveType, String> ourUnboxedToQName = new THashMap<PsiPrimitiveType, String>();
    private final String myName;

    PsiPrimitiveType(@NotNull String name, String boxedName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        this(name, TypeAnnotationProvider.EMPTY);
        if (boxedName != null) {
            ourQNameToUnboxed.put(boxedName, this);
            ourUnboxedToQName.put(this, boxedName);
        }
    }

    public PsiPrimitiveType(@NotNull String name, @NotNull PsiAnnotation[] annotations2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        super(annotations2);
        this.myName = name;
    }

    public PsiPrimitiveType(@NotNull String name, @NotNull TypeAnnotationProvider provider) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        super(provider);
        this.myName = name;
    }

    @Override
    @NotNull
    public PsiPrimitiveType annotate(@NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "annotate"));
        }
        PsiPrimitiveType psiPrimitiveType = (PsiPrimitiveType)super.annotate(provider);
        if (psiPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "annotate"));
        }
        return psiPrimitiveType;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = this.getText(false, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(true, annotated);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getText(true, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "getInternalCanonicalText"));
        }
        return string;
    }

    private String getText(boolean qualified, boolean annotated) {
        PsiAnnotation[] annotations2 = this.getAnnotations();
        if (!annotated || annotations2.length == 0) {
            return this.myName;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations(sb, annotations2, qualified);
        sb.append(this.myName);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "equalsToText"));
        }
        return this.myName.equals(text);
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "accept"));
        }
        return visitor2.visitPrimitiveType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return null;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "getSuperTypes"));
        }
        return EMPTY_ARRAY;
    }

    @Nullable
    public static PsiPrimitiveType getUnboxedType(PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        assert (type2.isValid()) : type2;
        LanguageLevel languageLevel = ((PsiClassType)type2).getLanguageLevel();
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        PsiClass psiClass = ((PsiClassType)type2).resolve();
        if (psiClass == null) {
            return null;
        }
        PsiPrimitiveType unboxed = ourQNameToUnboxed.get(psiClass.getQualifiedName());
        if (unboxed == null) {
            return null;
        }
        return unboxed.annotate(type2.getAnnotationProvider());
    }

    public String getBoxedTypeName() {
        return ourUnboxedToQName.get(this);
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "getBoxedType"));
        }
        PsiFile file = context.getContainingFile();
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(file);
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(file.getProject());
        PsiClass aClass2 = facade.findClass(boxedQName, file.getResolveScope());
        if (aClass2 == null) {
            return null;
        }
        PsiElementFactory factory = facade.getElementFactory();
        return factory.createType(aClass2, PsiSubstitutor.EMPTY, languageLevel).annotate(this.getAnnotationProvider());
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "getBoxedType"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType", "getBoxedType"));
        }
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        PsiClass aClass2 = JavaPsiFacade.getInstance(manager.getProject()).findClass(boxedQName, resolveScope);
        if (aClass2 == null) {
            return null;
        }
        return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(aClass2);
    }

    public static Collection<String> getAllBoxedTypeNames() {
        return Collections.unmodifiableCollection(ourQNameToUnboxed.keySet());
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PsiPrimitiveType && this.myName.equals(((PsiPrimitiveType)obj).myName);
    }
}

