/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterLazyParseableNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.LightStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;

public class JavaLightStubBuilder
extends LightStubBuilder {
    @Override
    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file, @NotNull LighterAST tree) {
        LighterASTNode ref;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightStubBuilder", "createStubForFile"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightStubBuilder", "createStubForFile"));
        }
        if (!(file instanceof PsiJavaFile)) {
            StubElement stubElement = super.createStubForFile(file, tree);
            if (stubElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightStubBuilder", "createStubForFile"));
            }
            return stubElement;
        }
        String refText = "";
        LighterASTNode pkg = LightTreeUtil.firstChildOfType(tree, tree.getRoot(), JavaElementType.PACKAGE_STATEMENT);
        if (pkg != null && (ref = LightTreeUtil.firstChildOfType(tree, pkg, JavaElementType.JAVA_CODE_REFERENCE)) != null) {
            refText = JavaSourceUtil.getReferenceText(tree, ref);
        }
        PsiJavaFileStubImpl psiJavaFileStubImpl = new PsiJavaFileStubImpl((PsiJavaFile)file, StringRef.fromString(refText), false);
        if (psiJavaFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightStubBuilder", "createStubForFile"));
        }
        return psiJavaFileStubImpl;
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent2, @NotNull ASTNode node) {
        IElementType nodeType;
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        IElementType parentType = parent2.getElementType();
        if (JavaLightStubBuilder.checkByTypes(parentType, nodeType = node.getElementType())) {
            return true;
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            CodeBlockVisitor visitor2 = new CodeBlockVisitor();
            ((TreeElement)node).acceptTree(visitor2);
            return visitor2.result;
        }
        return false;
    }

    @Override
    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent2, @NotNull LighterASTNode node) {
        IElementType nodeType;
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        IElementType parentType = parent2.getTokenType();
        if (JavaLightStubBuilder.checkByTypes(parentType, nodeType = node.getTokenType())) {
            return true;
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            CodeBlockVisitor visitor2 = new CodeBlockVisitor();
            ((LighterLazyParseableNode)node).accept(visitor2);
            return visitor2.result;
        }
        return false;
    }

    private static boolean checkByTypes(IElementType parentType, IElementType nodeType) {
        if (ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(parentType)) {
            return true;
        }
        if (nodeType == JavaElementType.RECEIVER_PARAMETER) {
            return true;
        }
        if (nodeType == JavaElementType.PARAMETER && parentType != JavaElementType.PARAMETER_LIST) {
            return true;
        }
        if (nodeType == JavaElementType.PARAMETER_LIST && parentType == JavaElementType.LAMBDA_EXPRESSION) {
            return true;
        }
        return nodeType == JavaDocElementType.DOC_COMMENT;
    }

    private static class CodeBlockVisitor
    extends RecursiveTreeElementWalkingVisitor
    implements LighterLazyParseableNode.Visitor {
        private static final TokenSet BLOCK_ELEMENTS = TokenSet.create(JavaElementType.ANNOTATION, JavaElementType.CLASS, JavaElementType.ANONYMOUS_CLASS);
        private boolean result = true;
        private IElementType last;
        private boolean seenNew;

        private CodeBlockVisitor() {
        }

        @Override
        protected void visitNode(TreeElement element) {
            if (BLOCK_ELEMENTS.contains(element.getElementType())) {
                this.result = false;
                this.stopWalking();
                return;
            }
            super.visitNode(element);
        }

        @Override
        public boolean visit(IElementType type2) {
            if (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type2)) {
                return true;
            }
            if (type2 == JavaTokenType.AT) {
                this.result = false;
                return false;
            }
            if (type2 == JavaTokenType.NEW_KEYWORD) {
                this.seenNew = true;
            } else if (this.seenNew && type2 == JavaTokenType.SEMICOLON) {
                this.seenNew = false;
            } else {
                if (this.seenNew && type2 == JavaTokenType.LBRACE && this.last != JavaTokenType.RBRACKET) {
                    this.result = false;
                    return false;
                }
                if (type2 == JavaTokenType.CLASS_KEYWORD && this.last != JavaTokenType.DOT) {
                    this.result = false;
                    return false;
                }
            }
            this.last = type2;
            return true;
        }
    }
}

