/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.DelegationTranslator;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J.\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0012H\u0002J&\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0012H\u0002J\u0014\u0010\u001e\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0012J&\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0012H\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "classDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "delegationBySpecifiers", "", "Lorg/jetbrains/kotlin/psi/KtDelegatedSuperTypeEntry;", "fields", "", "Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator$Field;", "addInitCode", "", "statements", "", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsStatement;", "generateDelegateCallForFunctionMember", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "overriddenDescriptor", "delegateName", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsName;", "properties", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsPropertyInitializer;", "generateDelegateCallForPropertyMember", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateDelegated", "generateDelegates", "toClass", "field", "getSuperClass", "specifier", "Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;", "Field", "kotlin-compiler"})
public final class DelegationTranslator
extends AbstractTranslator {
    private final ClassDescriptor classDescriptor;
    private final List<KtDelegatedSuperTypeEntry> delegationBySpecifiers;
    private final Map<KtDelegatedSuperTypeEntry, Field> fields;

    public final void addInitCode(@NotNull List<JsStatement> statements) {
        Intrinsics.checkParameterIsNotNull(statements, "statements");
        for (KtDelegatedSuperTypeEntry specifier : this.delegationBySpecifiers) {
            KtExpression expression;
            Field field;
            if (this.fields.get(specifier) == null) {
                Intrinsics.throwNpe();
            }
            if (!field.getGenerateField()) continue;
            if (specifier.getDelegateExpression() == null) {
                Intrinsics.throwNpe();
            }
            TranslationContext context = this.context().innerBlock();
            JsExpression delegateInitExpr = Translation.translateAsExpression(expression, context);
            Collection collection = statements;
            Iterable iterable = context.dynamicContext().jsBlock().getStatements();
            Intrinsics.checkExpressionValueIsNotNull(iterable, "context.dynamicContext().jsBlock().statements");
            Iterable iterable2 = iterable;
            CollectionsKt.addAll(collection, iterable2);
            JsNameRef lhs = JsAstUtils.pureFqn(field.getName(), (JsExpression)JsLiteral.THIS);
            iterable2 = statements;
            JsStatement jsStatement = JsAstUtils.assignment(lhs, delegateInitExpr).makeStmt();
            iterable2.add(jsStatement);
        }
    }

    public final void generateDelegated(@NotNull List<JsPropertyInitializer> properties2) {
        Intrinsics.checkParameterIsNotNull(properties2, "properties");
        for (KtDelegatedSuperTypeEntry specifier : this.delegationBySpecifiers) {
            ClassDescriptor classDescriptor = this.getSuperClass(specifier);
            Field field = this.fields.get(specifier);
            if (field == null) {
                Intrinsics.throwNpe();
            }
            this.generateDelegates(classDescriptor, field, properties2);
        }
    }

    private final ClassDescriptor getSuperClass(KtSuperTypeListEntry specifier) {
        BindingContext bindingContext = this.bindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "bindingContext()");
        return CodegenUtil.getSuperClassBySuperTypeListEntry(specifier, bindingContext);
    }

    private final void generateDelegates(ClassDescriptor toClass, Field field, List<JsPropertyInitializer> properties2) {
        Map map2 = CodegenUtil.getDelegates$default(this.classDescriptor, toClass, null, 4, null);
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)entry2.getKey();
            Object object = entry;
            CallableDescriptor overriddenDescriptor2 = (CallableDescriptor)object.getValue();
            object = descriptor2;
            if (object instanceof PropertyDescriptor) {
                this.generateDelegateCallForPropertyMember((PropertyDescriptor)descriptor2, field.getName(), properties2);
                continue;
            }
            if (object instanceof FunctionDescriptor) {
                CallableDescriptor callableDescriptor = overriddenDescriptor2;
                if (callableDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                }
                this.generateDelegateCallForFunctionMember((FunctionDescriptor)descriptor2, (FunctionDescriptor)callableDescriptor, field.getName(), properties2);
                continue;
            }
            throw (Throwable)new IllegalArgumentException("Expected property or function " + descriptor2);
        }
    }

    private final void generateDelegateCallForPropertyMember(PropertyDescriptor descriptor2, JsName delegateName, List<JsPropertyInitializer> properties2) {
        String string = descriptor2.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "descriptor.name.asString()");
        String propertyName = string;
        Function1<PropertyGetterDescriptor, JsFunction> generateDelegateGetterFunction$ = new Function1<PropertyGetterDescriptor, JsFunction>(this, delegateName, descriptor2, propertyName){
            final /* synthetic */ DelegationTranslator this$0;
            final /* synthetic */ JsName $delegateName;
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ String $propertyName;

            @NotNull
            public final JsFunction invoke(@NotNull PropertyGetterDescriptor getterDescriptor) {
                JsExpression jsExpression;
                Intrinsics.checkParameterIsNotNull(getterDescriptor, "getterDescriptor");
                JsNameRef delegateRef = new JsNameRef(this.$delegateName, (JsExpression)JsLiteral.THIS);
                if (DescriptorUtils.isExtension(this.$descriptor)) {
                    JsName getterName = DelegationTranslator.access$context(this.this$0).getNameForDescriptor(getterDescriptor);
                    String receiver = Namer.getReceiverParameterName();
                    jsExpression = new JsInvocation((JsExpression)new JsNameRef(getterName, (JsExpression)delegateRef), new JsNameRef(receiver));
                } else {
                    jsExpression = new JsNameRef(this.$propertyName, (JsExpression)delegateRef);
                }
                JsExpression returnExpression = jsExpression;
                JsFunction jsFunction = TranslationUtils.simpleReturnFunction(DelegationTranslator.access$context(this.this$0).getScopeForDescriptor(getterDescriptor.getContainingDeclaration()), returnExpression);
                if (DescriptorUtils.isExtension(this.$descriptor)) {
                    JsName receiverName = jsFunction.getScope().declareName(Namer.getReceiverParameterName());
                    jsFunction.getParameters().add(new JsParameter(receiverName));
                }
                JsFunction jsFunction2 = jsFunction;
                Intrinsics.checkExpressionValueIsNotNull(jsFunction2, "jsFunction");
                return jsFunction2;
            }
            {
                this.this$0 = delegationTranslator;
                this.$delegateName = jsName;
                this.$descriptor = propertyDescriptor;
                this.$propertyName = string;
                super(1);
            }
        };
        Function1<PropertySetterDescriptor, JsFunction> generateDelegateSetterFunction$ = new Function1<PropertySetterDescriptor, JsFunction>(this, delegateName, descriptor2, propertyName){
            final /* synthetic */ DelegationTranslator this$0;
            final /* synthetic */ JsName $delegateName;
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ String $propertyName;

            @NotNull
            public final JsFunction invoke(@NotNull PropertySetterDescriptor setterDescriptor) {
                JsExpression jsExpression;
                Intrinsics.checkParameterIsNotNull(setterDescriptor, "setterDescriptor");
                JsFunction jsFunction = new JsFunction(DelegationTranslator.access$context(this.this$0).program().getRootScope(), "setter for " + setterDescriptor.getName().asString());
                boolean bl = setterDescriptor.getValueParameters().size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Setter must have 1 parameter";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                JsParameter defaultParameter = new JsParameter(jsFunction.getScope().declareTemporary());
                JsNameRef defaultParameterRef = defaultParameter.getName().makeRef();
                JsNameRef delegateRef = new JsNameRef(this.$delegateName, (JsExpression)JsLiteral.THIS);
                if (DescriptorUtils.isExtension(this.$descriptor)) {
                    JsName setterName = DelegationTranslator.access$context(this.this$0).getNameForDescriptor(setterDescriptor);
                    JsNameRef setterNameRef = new JsNameRef(setterName, (JsExpression)delegateRef);
                    JsName extensionFunctionReceiverName = jsFunction.getScope().declareName(Namer.getReceiverParameterName());
                    jsFunction.getParameters().add(new JsParameter(extensionFunctionReceiverName));
                    jsExpression = new JsInvocation((JsExpression)setterNameRef, new JsNameRef(extensionFunctionReceiverName), defaultParameterRef);
                } else {
                    JsNameRef propertyNameRef = new JsNameRef(this.$propertyName, (JsExpression)delegateRef);
                    JsExpression jsExpression2 = JsAstUtils.assignment(propertyNameRef, defaultParameterRef);
                    jsExpression = jsExpression2;
                    Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "JsAstUtils.assignment(pr\u2026Ref, defaultParameterRef)");
                }
                JsExpression setExpression = jsExpression;
                jsFunction.getParameters().add(defaultParameter);
                jsFunction.setBody(new JsBlock(setExpression.makeStmt()));
                return jsFunction;
            }
            {
                this.this$0 = delegationTranslator;
                this.$delegateName = jsName;
                this.$descriptor = propertyDescriptor;
                this.$propertyName = string;
                super(1);
            }
        };
        Function2<PropertyAccessorDescriptor, JsFunction, JsPropertyInitializer> generateDelegateAccessor$ = new Function2<PropertyAccessorDescriptor, JsFunction, JsPropertyInitializer>(this){
            final /* synthetic */ DelegationTranslator this$0;

            @NotNull
            public final JsPropertyInitializer invoke(@NotNull PropertyAccessorDescriptor accessorDescriptor, @NotNull JsFunction function) {
                Intrinsics.checkParameterIsNotNull(accessorDescriptor, "accessorDescriptor");
                Intrinsics.checkParameterIsNotNull(function, "function");
                JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function, accessorDescriptor, DelegationTranslator.access$context(this.this$0));
                Intrinsics.checkExpressionValueIsNotNull(jsPropertyInitializer, "translateFunctionAsEcma5\u2026sorDescriptor, context())");
                return jsPropertyInitializer;
            }
            {
                this.this$0 = delegationTranslator;
                super(2);
            }
        };
        Function0<JsPropertyInitializer> generateDelegateGetter$ = new Function0<JsPropertyInitializer>(descriptor2, generateDelegateAccessor$, generateDelegateGetterFunction$){
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ generateDelegateCallForPropertyMember.3 $generateDelegateAccessor;
            final /* synthetic */ generateDelegateCallForPropertyMember.1 $generateDelegateGetterFunction;

            @NotNull
            public final JsPropertyInitializer invoke() {
                PropertyGetterDescriptor propertyGetterDescriptor = this.$descriptor.getGetter();
                if (propertyGetterDescriptor == null) {
                    throw (Throwable)new IllegalStateException("Getter descriptor should not be null");
                }
                PropertyGetterDescriptor getterDescriptor = propertyGetterDescriptor;
                PropertyAccessorDescriptor propertyAccessorDescriptor = getterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(propertyAccessorDescriptor, "getterDescriptor");
                PropertyGetterDescriptor propertyGetterDescriptor2 = getterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(propertyGetterDescriptor2, "getterDescriptor");
                return this.$generateDelegateAccessor.invoke(propertyAccessorDescriptor, this.$generateDelegateGetterFunction.invoke(propertyGetterDescriptor2));
            }
            {
                this.$descriptor = propertyDescriptor;
                this.$generateDelegateAccessor = var2_2;
                this.$generateDelegateGetterFunction = var3_3;
                super(0);
            }
        };
        Function0<JsPropertyInitializer> generateDelegateSetter$ = new Function0<JsPropertyInitializer>(descriptor2, generateDelegateAccessor$, generateDelegateSetterFunction$){
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ generateDelegateCallForPropertyMember.3 $generateDelegateAccessor;
            final /* synthetic */ generateDelegateCallForPropertyMember.2 $generateDelegateSetterFunction;

            @NotNull
            public final JsPropertyInitializer invoke() {
                PropertySetterDescriptor propertySetterDescriptor = this.$descriptor.getSetter();
                if (propertySetterDescriptor == null) {
                    throw (Throwable)new IllegalStateException("Setter descriptor should not be null");
                }
                PropertySetterDescriptor setterDescriptor = propertySetterDescriptor;
                PropertyAccessorDescriptor propertyAccessorDescriptor = setterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(propertyAccessorDescriptor, "setterDescriptor");
                PropertySetterDescriptor propertySetterDescriptor2 = setterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(propertySetterDescriptor2, "setterDescriptor");
                return this.$generateDelegateAccessor.invoke(propertyAccessorDescriptor, this.$generateDelegateSetterFunction.invoke(propertySetterDescriptor2));
            }
            {
                this.$descriptor = propertyDescriptor;
                this.$generateDelegateAccessor = var2_2;
                this.$generateDelegateSetterFunction = var3_3;
                super(0);
            }
        };
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        PropertyTranslatorKt.addGetterAndSetter(properties2, descriptor2, translationContext, (Function0<? extends JsPropertyInitializer>)new Function0<JsPropertyInitializer>(generateDelegateGetter$){
            final /* synthetic */ generateDelegateCallForPropertyMember.4 $generateDelegateGetter;

            @NotNull
            public final JsPropertyInitializer invoke() {
                return this.$generateDelegateGetter.invoke();
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "generateDelegateGetter";
            }

            public final String getSignature() {
                return "invoke()Lcom/google/dart/compiler/backend/js/ast/JsPropertyInitializer;";
            }
            {
                this.$generateDelegateGetter = var1_1;
                super(0);
            }
        }, (Function0<? extends JsPropertyInitializer>)new Function0<JsPropertyInitializer>(generateDelegateSetter$){
            final /* synthetic */ generateDelegateCallForPropertyMember.5 $generateDelegateSetter;

            @NotNull
            public final JsPropertyInitializer invoke() {
                return this.$generateDelegateSetter.invoke();
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "generateDelegateSetter";
            }

            public final String getSignature() {
                return "invoke()Lcom/google/dart/compiler/backend/js/ast/JsPropertyInitializer;";
            }
            {
                this.$generateDelegateSetter = var1_1;
                super(0);
            }
        });
    }

    private final void generateDelegateCallForFunctionMember(FunctionDescriptor descriptor2, FunctionDescriptor overriddenDescriptor2, JsName delegateName, List<JsPropertyInitializer> properties2) {
        JsNameRef delegateRef = new JsNameRef(delegateName, (JsExpression)JsLiteral.THIS);
        JsExpression jsExpression = delegateRef;
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        properties2.add(UtilsKt.generateDelegateCall(descriptor2, overriddenDescriptor2, jsExpression, translationContext));
    }

    /*
     * WARNING - void declaration
     */
    public DelegationTranslator(@NotNull KtClassOrObject classDeclaration, @NotNull TranslationContext context) {
        List list2;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(classDeclaration, "classDeclaration");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context.bindingContext(), classDeclaration);
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "BindingUtils.getClassDes\u2026text(), classDeclaration)");
        this.classDescriptor = classDescriptor;
        Iterable iterable = classDeclaration.getSuperTypeListEntries();
        DelegationTranslator delegationTranslator = this;
        Iterator<KtDelegatedSuperTypeEntry> iterator2 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtDelegatedSuperTypeEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        delegationTranslator.delegationBySpecifiers = list2 = (List)destination$iv$iv;
        this.fields = MapsKt.mutableMapOf(new Pair[0]);
        for (KtDelegatedSuperTypeEntry specifier : this.delegationBySpecifiers) {
            KtExpression expression;
            if (specifier.getDelegateExpression() == null) {
                throw (Throwable)new IllegalArgumentException("delegate expression should not be null: " + specifier.getText());
            }
            ClassDescriptor descriptor2 = this.getSuperClass(specifier);
            KtExpression ktExpression = expression;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression, "expression");
            BindingContext bindingContext = this.bindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "bindingContext()");
            PropertyDescriptor propertyDescriptor = CodegenUtil.getDelegatePropertyIfAny(ktExpression, this.classDescriptor, bindingContext);
            BindingContext bindingContext2 = this.bindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "bindingContext()");
            if (CodegenUtil.isFinalPropertyWithBackingField(propertyDescriptor, bindingContext2)) {
                PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
                if (propertyDescriptor2 == null) {
                    Intrinsics.throwNpe();
                }
                JsName delegateName = context.getNameForDescriptor(propertyDescriptor2);
                Map<KtDelegatedSuperTypeEntry, Field> $i$f$filterIsInstance = this.fields;
                JsName jsName = delegateName;
                Intrinsics.checkExpressionValueIsNotNull(jsName, "delegateName");
                Field field = new Field(jsName, false);
                $i$f$filterIsInstance.put(specifier, field);
                continue;
            }
            FqNameUnsafe classFqName = DescriptorUtils.getFqName(this.classDescriptor);
            String idForMangling = classFqName.asString();
            String string = Namer.getDelegatePrefix();
            Intrinsics.checkExpressionValueIsNotNull(string, "Namer.getDelegatePrefix()");
            String string2 = idForMangling;
            Intrinsics.checkExpressionValueIsNotNull(string2, "idForMangling");
            String suggestedName = NameSuggestion.Companion.getStableMangledName(string, string2);
            JsName delegateName = context.getScopeForDescriptor(this.classDescriptor).declareFreshName(suggestedName + "_0");
            Map<KtDelegatedSuperTypeEntry, Field> map2 = this.fields;
            JsName jsName = delegateName;
            Intrinsics.checkExpressionValueIsNotNull(jsName, "delegateName");
            Field field = new Field(jsName, true);
            map2.put(specifier, field);
        }
    }

    @NotNull
    public static final /* synthetic */ TranslationContext access$context(DelegationTranslator $this) {
        return $this.context();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator$Field;", "", "name", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsName;", "generateField", "", "(Lcom/google/dart/compiler/backend/js/ast/JsName;Z)V", "getGenerateField", "()Z", "getName", "()Lcom/google/dart/compiler/backend/js/ast/JsName;", "kotlin-compiler"})
    private static final class Field {
        @NotNull
        private final JsName name;
        private final boolean generateField;

        @NotNull
        public final JsName getName() {
            return this.name;
        }

        public final boolean getGenerateField() {
            return this.generateField;
        }

        public Field(@NotNull JsName name, boolean generateField) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.name = name;
            this.generateField = generateField;
        }
    }
}

