/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.operation.IncrementTranslator;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;

public final class IntrinsicIncrementTranslator
extends IncrementTranslator {
    @NotNull
    public static JsExpression doTranslate(@NotNull KtUnaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "doTranslate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "doTranslate"));
        }
        JsExpression jsExpression = new IntrinsicIncrementTranslator(expression, context).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "doTranslate"));
        }
        return jsExpression;
    }

    private IntrinsicIncrementTranslator(@NotNull KtUnaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "<init>"));
        }
        super(expression, context);
    }

    @NotNull
    private JsExpression translate() {
        if (this.isPrimitiveExpressionIncrement()) {
            JsExpression jsExpression = this.primitiveExpressionIncrement();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.translateIncrementExpression();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "translate"));
        }
        return jsExpression;
    }

    private boolean isPrimitiveExpressionIncrement() {
        return this.expression.getBaseExpression() instanceof KtSimpleNameExpression;
    }

    @NotNull
    private JsExpression primitiveExpressionIncrement() {
        JsUnaryOperator operator = OperatorTable.getUnaryOperator(PsiUtils.getOperationToken(this.expression));
        JsExpression getExpression = this.accessTranslator.translateAsGet();
        if (PsiUtils.isPrefix(this.expression)) {
            JsPrefixOperation jsPrefixOperation = new JsPrefixOperation(operator, getExpression);
            if (jsPrefixOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "primitiveExpressionIncrement"));
            }
            return jsPrefixOperation;
        }
        JsPostfixOperation jsPostfixOperation = new JsPostfixOperation(operator, getExpression);
        if (jsPostfixOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "primitiveExpressionIncrement"));
        }
        return jsPostfixOperation;
    }

    @Override
    @NotNull
    protected JsExpression operationExpression(@NotNull JsExpression receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "operationExpression"));
        }
        JsBinaryOperation jsBinaryOperation = this.unaryAsBinary(receiver);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "operationExpression"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsBinaryOperation unaryAsBinary(@NotNull JsExpression leftExpression) {
        if (leftExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftExpression", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "unaryAsBinary"));
        }
        JsNumberLiteral oneLiteral = this.program().getNumberLiteral(1);
        KtToken token = PsiUtils.getOperationToken(this.expression);
        if (token.equals(KtTokens.PLUSPLUS)) {
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ADD, leftExpression, oneLiteral);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "unaryAsBinary"));
            }
            return jsBinaryOperation;
        }
        if (token.equals(KtTokens.MINUSMINUS)) {
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.SUB, leftExpression, oneLiteral);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "unaryAsBinary"));
            }
            return jsBinaryOperation;
        }
        throw new AssertionError((Object)"This method should be called only for increment and decrement operators");
    }
}

