/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0002\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000b"}, d2={"toSourceElement", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getToSourceElement", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/descriptors/SourceElement;", "getSourceElement", "descriptor", "isContainedByCompiledPartOfOurModule", "", "outDirectory", "Ljava/io/File;", "kotlin-compiler"})
public final class ModuleVisibilityUtilsKt {
    public static final boolean isContainedByCompiledPartOfOurModule(@NotNull DeclarationDescriptor descriptor2, @Nullable File outDirectory) {
        VirtualFile file;
        KotlinJvmBinaryClass binaryClass;
        KotlinJvmBinaryClass kotlinJvmBinaryClass;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (outDirectory == null) {
            return false;
        }
        PackageFragmentDescriptor packageFragment = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class, false);
        if (!(packageFragment instanceof LazyJavaPackageFragment)) {
            return false;
        }
        SourceElement source = ModuleVisibilityUtilsKt.getSourceElement(descriptor2);
        SourceElement sourceElement = source;
        if (sourceElement instanceof KotlinJvmBinarySourceElement) {
            kotlinJvmBinaryClass = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
        } else if (sourceElement instanceof KotlinJvmBinaryPackageSourceElement) {
            if (descriptor2 instanceof DeserializedCallableMemberDescriptor) {
                kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedCallableMemberDescriptor)descriptor2);
                if (kotlinJvmBinaryClass == null) {
                    kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getRepresentativeBinaryClass();
                }
            } else {
                kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getRepresentativeBinaryClass();
            }
        } else {
            kotlinJvmBinaryClass = binaryClass = (KotlinJvmBinaryClass)null;
        }
        if (binaryClass instanceof VirtualFileKotlinClass && Intrinsics.areEqual((file = ((VirtualFileKotlinClass)binaryClass).getFile()).getFileSystem().getProtocol(), "file")) {
            File ioFile = VfsUtilCore.virtualToIoFile(file);
            return StringsKt.startsWith$default(ioFile.getAbsolutePath(), outDirectory.getAbsolutePath() + File.separator, false, 2, null);
        }
        return false;
    }

    @NotNull
    public static final SourceElement getSourceElement(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getSource() == SourceElement.NO_SOURCE ? ModuleVisibilityUtilsKt.getToSourceElement(((CallableMemberDescriptor)descriptor2).getContainingDeclaration()) : ModuleVisibilityUtilsKt.getToSourceElement(descriptor2);
    }

    private static final SourceElement getToSourceElement(@NotNull DeclarationDescriptor $receiver) {
        SourceElement sourceElement;
        if ($receiver instanceof DeclarationDescriptorWithSource) {
            SourceElement sourceElement2 = ((DeclarationDescriptorWithSource)$receiver).getSource();
            sourceElement = sourceElement2;
            Intrinsics.checkExpressionValueIsNotNull(sourceElement2, "source");
        } else {
            SourceElement sourceElement3 = SourceElement.NO_SOURCE;
            sourceElement = sourceElement3;
            Intrinsics.checkExpressionValueIsNotNull(sourceElement3, "SourceElement.NO_SOURCE");
        }
        return sourceElement;
    }
}

