/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyScriptDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

public class TopDownAnalysisContext
implements BodiesResolveContext {
    private final DataFlowInfo outerDataFlowInfo;
    private final Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> classes;
    private final Map<KtAnonymousInitializer, ClassDescriptorWithResolutionScopes> anonymousInitializers;
    private final Set<KtFile> files;
    private final Map<KtSecondaryConstructor, ConstructorDescriptor> secondaryConstructors;
    private final Map<KtNamedFunction, SimpleFunctionDescriptor> functions;
    private final Map<KtProperty, PropertyDescriptor> properties;
    private final Map<KtParameter, PropertyDescriptor> primaryConstructorParameterProperties;
    private Map<KtCallableDeclaration, CallableMemberDescriptor> members;
    private final Map<KtScript, LazyScriptDescriptor> scripts;
    private final TopDownAnalysisMode topDownAnalysisMode;
    private final DeclarationScopeProvider declarationScopeProvider;
    private StringBuilder debugOutput;

    public TopDownAnalysisContext(@NotNull TopDownAnalysisMode topDownAnalysisMode, @NotNull DataFlowInfo outerDataFlowInfo, @NotNull DeclarationScopeProvider declarationScopeProvider) {
        if (topDownAnalysisMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisMode", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "<init>"));
        }
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "<init>"));
        }
        if (declarationScopeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationScopeProvider", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "<init>"));
        }
        this.classes = Maps.newLinkedHashMap();
        this.anonymousInitializers = Maps.newLinkedHashMap();
        this.files = new LinkedHashSet<KtFile>();
        this.secondaryConstructors = Maps.newLinkedHashMap();
        this.functions = Maps.newLinkedHashMap();
        this.properties = Maps.newLinkedHashMap();
        this.primaryConstructorParameterProperties = Maps.newHashMap();
        this.members = null;
        this.scripts = Maps.newLinkedHashMap();
        this.topDownAnalysisMode = topDownAnalysisMode;
        this.outerDataFlowInfo = outerDataFlowInfo;
        this.declarationScopeProvider = declarationScopeProvider;
    }

    @Override
    @NotNull
    public TopDownAnalysisMode getTopDownAnalysisMode() {
        TopDownAnalysisMode topDownAnalysisMode = this.topDownAnalysisMode;
        if (topDownAnalysisMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getTopDownAnalysisMode"));
        }
        return topDownAnalysisMode;
    }

    public void debug(Object message) {
        if (this.debugOutput != null) {
            this.debugOutput.append(message).append("\n");
        }
    }

    @Override
    public Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> getDeclaredClasses() {
        return this.classes;
    }

    @Override
    public Map<KtAnonymousInitializer, ClassDescriptorWithResolutionScopes> getAnonymousInitializers() {
        return this.anonymousInitializers;
    }

    @Override
    public Map<KtSecondaryConstructor, ConstructorDescriptor> getSecondaryConstructors() {
        return this.secondaryConstructors;
    }

    @Override
    public Collection<KtFile> getFiles() {
        return this.files;
    }

    public void addFile(@NotNull KtFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "addFile"));
        }
        this.files.add(file);
    }

    @Override
    @NotNull
    public Map<KtScript, LazyScriptDescriptor> getScripts() {
        Map<KtScript, LazyScriptDescriptor> map2 = this.scripts;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getScripts"));
        }
        return map2;
    }

    public Map<KtParameter, PropertyDescriptor> getPrimaryConstructorParameterProperties() {
        return this.primaryConstructorParameterProperties;
    }

    @Override
    public Map<KtProperty, PropertyDescriptor> getProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public LexicalScope getDeclaringScope(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getDeclaringScope"));
        }
        return this.declarationScopeProvider.getResolutionScopeForDeclaration(declaration);
    }

    @Override
    public Map<KtNamedFunction, SimpleFunctionDescriptor> getFunctions() {
        return this.functions;
    }

    @NotNull
    public Map<KtCallableDeclaration, CallableMemberDescriptor> getMembers() {
        if (this.members == null) {
            this.members = Maps.newLinkedHashMap();
            this.members.putAll(this.functions);
            this.members.putAll(this.properties);
            this.members.putAll(this.primaryConstructorParameterProperties);
        }
        Map<KtCallableDeclaration, CallableMemberDescriptor> map2 = this.members;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getMembers"));
        }
        return map2;
    }

    @Override
    @NotNull
    public DataFlowInfo getOuterDataFlowInfo() {
        DataFlowInfo dataFlowInfo = this.outerDataFlowInfo;
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getOuterDataFlowInfo"));
        }
        return dataFlowInfo;
    }

    @NotNull
    public Collection<ClassDescriptorWithResolutionScopes> getAllClasses() {
        List<ClassDescriptorWithResolutionScopes> list2 = CollectionsKt.plus(this.getDeclaredClasses().values(), this.getScripts().values());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getAllClasses"));
        }
        return list2;
    }
}

