/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.data;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.extapi.psi.ASTDelegatePsiElement;
import org.jetbrains.kotlin.com.intellij.extapi.psi.StubBasedPsiElementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;

public abstract class KtClassOrObjectInfo<E extends KtClassOrObject>
implements KtClassLikeInfo {
    protected final E element;

    protected KtClassOrObjectInfo(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/lazy/data/KtClassOrObjectInfo", "<init>"));
        }
        this.element = element;
    }

    @Nullable
    public Name getName() {
        return ((KtTypeParameterListOwnerStub)this.element).getNameAsName();
    }

    @Override
    @NotNull
    public KtClassOrObject getCorrespondingClassOrObject() {
        E e = this.element;
        if (e == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/KtClassOrObjectInfo", "getCorrespondingClassOrObject"));
        }
        return e;
    }

    @Override
    @Nullable
    public KtModifierList getModifierList() {
        return ((KtModifierListOwnerStub)this.element).getModifierList();
    }

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations() {
        List<KtDeclaration> list2 = ((KtClassOrObject)this.element).getDeclarations();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/KtClassOrObjectInfo", "getDeclarations"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<KtObjectDeclaration> getCompanionObjects() {
        KtClassBody body = ((KtClassOrObject)this.element).getBody();
        if (body == null) {
            List<KtObjectDeclaration> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/KtClassOrObjectInfo", "getCompanionObjects"));
            }
            return list2;
        }
        List<KtObjectDeclaration> list3 = body.getAllCompanionObjects();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/KtClassOrObjectInfo", "getCompanionObjects"));
        }
        return list3;
    }

    @Override
    @NotNull
    public PsiElement getScopeAnchor() {
        E e = this.element;
        if (e == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/KtClassOrObjectInfo", "getScopeAnchor"));
        }
        return e;
    }

    @Override
    @NotNull
    public FqName getContainingPackageFqName() {
        PsiFile file = ((StubBasedPsiElementBase)this.element).getContainingFile();
        if (file instanceof KtFile) {
            KtFile jetFile = (KtFile)file;
            FqName fqName2 = jetFile.getPackageFqName();
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/KtClassOrObjectInfo", "getContainingPackageFqName"));
            }
            return fqName2;
        }
        throw new IllegalArgumentException("Not in a JetFile: " + this.element);
    }

    @Override
    @NotNull
    public List<KtAnnotationEntry> getDanglingAnnotations() {
        KtClassBody body = ((KtClassOrObject)this.element).getBody();
        List<Object> list2 = body == null ? Collections.emptyList() : body.getDanglingAnnotations();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/KtClassOrObjectInfo", "getDanglingAnnotations"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<? extends KtParameter> getPrimaryConstructorParameters() {
        List<KtParameter> list2 = ((KtClassOrObject)this.element).getPrimaryConstructorParameters();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/KtClassOrObjectInfo", "getPrimaryConstructorParameters"));
        }
        return list2;
    }

    public String toString() {
        return "info for " + ((ASTDelegatePsiElement)this.element).getText();
    }
}

