/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.kotlin.com.intellij.util.PathUtil;

public class VfsUtilCore {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.VfsUtilCore");

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file, boolean strict) {
        VirtualFile parent2;
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "isAncestor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "isAncestor"));
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile = parent2 = strict ? file.getParent() : file;
        while (parent2 != null) {
            if (parent2.equals(ancestor)) {
                return true;
            }
            parent2 = parent2.getParent();
        }
        return false;
    }

    public static boolean isUnder(@NotNull VirtualFile file, @Nullable Set<VirtualFile> roots2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "isUnder"));
        }
        if (roots2 == null || roots2.isEmpty()) {
            return false;
        }
        for (VirtualFile parent2 = file; parent2 != null; parent2 = parent2.getParent()) {
            if (!roots2.contains(parent2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path = entryVFile.getPath();
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        VirtualFile virtualFile = VfsUtilCore.copyFile(requestor, file, toDir, file.getName());
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull String newName2) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        if (newName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        VirtualFile newChild = toDir.createChildData(requestor, newName2);
        newChild.setBinaryContent(file.contentsToByteArray());
        VirtualFile virtualFile = newChild;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        return virtualFile;
    }

    @NotNull
    public static InputStream byteStreamSkippingBOM(@NotNull byte[] buf, @NotNull VirtualFile file) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "byteStreamSkippingBOM"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "byteStreamSkippingBOM"));
        }
        BufferExposingByteArrayInputStream stream2 = new BufferExposingByteArrayInputStream(buf);
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM(stream2, file);
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "byteStreamSkippingBOM"));
        }
        return inputStream;
    }

    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream2, @NotNull VirtualFile file) throws IOException {
        if (stream2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "inputStreamSkippingBOM"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "inputStreamSkippingBOM"));
        }
        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM(stream2);
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "inputStreamSkippingBOM"));
        }
        return inputStream;
    }

    @NotNull
    public static OutputStream outputStreamAddingBOM(@NotNull OutputStream stream2, @NotNull VirtualFile file) throws IOException {
        if (stream2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "outputStreamAddingBOM"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "outputStreamAddingBOM"));
        }
        byte[] bom = file.getBOM();
        if (bom != null) {
            stream2.write(bom);
        }
        OutputStream outputStream2 = stream2;
        if (outputStream2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "outputStreamAddingBOM"));
        }
        return outputStream2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor<?> visitor) throws VirtualFileVisitor.VisitorException {
        block27: {
            block26: {
                block25: {
                    block24: {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"file", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                        }
                        if (visitor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"visitor", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                        }
                        pushed = false;
                        visited = visitor.allowVisitFile(file);
                        if (visited) {
                            result = visitor.visitFileEx(file);
                            if (result.skipChildren) {
                                var5_5 = result;
                                v0 = var5_5;
                                if (v0 == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                                }
                                return v0;
                            }
                        }
                        childrenIterable = null;
                        children = null;
                        try {
                            if (file.isValid() && visitor.allowVisitChildren(file) && !visitor.depthLimitReached() && (childrenIterable = visitor.getChildrenIterable(file)) == null) {
                                children = file.getChildren();
                            }
                        }
                        catch (InvalidVirtualFileAccessException e) {
                            VfsUtilCore.LOG.info("Ignoring: " + e.getMessage());
                            var7_9 = VirtualFileVisitor.CONTINUE;
                            visitor.restoreValue(pushed);
                            v1 = var7_9;
                            if (v1 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                            }
                            return v1;
                        }
                        if (childrenIterable == null) break block24;
                        visitor.saveValue();
                        pushed = true;
                        var6_8 = childrenIterable.iterator();
                        break block25;
                    }
                    if (children == null || children.length == 0) break block26;
                    break block27;
                }
                while (var6_8.hasNext()) {
                    child = (VirtualFile)var6_8.next();
                    result = VfsUtilCore.visitChildrenRecursively(child, visitor);
                    if (result.skipToParent == null || Comparing.equal(result.skipToParent, child)) continue;
                    var9_14 = result;
                    v2 = var9_14;
                    if (v2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                    }
                    return v2;
                }
            }
            while (true) {
                if (visited) {
                    visitor.afterChildrenVisited(file);
                }
                var6_8 = VirtualFileVisitor.CONTINUE;
                v3 = var6_8;
                if (v3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                }
                return v3;
            }
            finally {
                visitor.restoreValue(pushed);
            }
        }
        visitor.saveValue();
        pushed = true;
        var6_8 = children;
        var7_11 = ((Object)var6_8).length;
        var8_13 = 0;
        while (true) {
            if (var8_13 >= var7_11) ** continue;
            child = var6_8[var8_13];
            result = VfsUtilCore.visitChildrenRecursively((VirtualFile)child, visitor);
            if (result.skipToParent != null && !Comparing.equal(result.skipToParent, child)) {
                var11_17 = result;
                v4 = var11_17;
                if (v4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                }
                return v4;
            }
            ++var8_13;
        }
    }

    public static boolean isInvalidLink(@NotNull VirtualFile link) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "isInvalidLink"));
        }
        VirtualFile target = link.getCanonicalFile();
        return target == null || target.equals(link) || VfsUtilCore.isAncestor(target, link, true);
    }

    @NotNull
    public static VirtualFile[] toVirtualFileArray(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "toVirtualFileArray"));
        }
        int size = files.size();
        if (size == 0) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "toVirtualFileArray"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] virtualFileArray = files.toArray(new VirtualFile[size]);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "toVirtualFileArray"));
        }
        return virtualFileArray;
    }

    @NotNull
    public static File virtualToIoFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "virtualToIoFile"));
        }
        File file2 = new File(PathUtil.toPresentableUrl(file.getUrl()));
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VfsUtilCore", "virtualToIoFile"));
        }
        return file2;
    }
}

