/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CliModuleVisibilityManagerImpl;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.JvmRuntimeVersionsConsistencyChecker;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.cli.jvm.compiler.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmCliVirtualFileFinderFactory;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmDependenciesIndex;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCliJavaFileManagerImpl;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.MockExternalAnnotationsManager;
import org.jetbrains.kotlin.cli.jvm.compiler.MockInferredAnnotationsManager;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRoot;
import org.jetbrains.kotlin.codegen.extensions.ClassBuilderInterceptorExtension;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.codeInsight.ContainerProvider;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExternalAnnotationsManager;
import org.jetbrains.kotlin.com.intellij.codeInsight.InferredAnnotationsManager;
import org.jetbrains.kotlin.com.intellij.codeInsight.runner.JavaMainMethodProvider;
import org.jetbrains.kotlin.com.intellij.core.CoreApplicationEnvironment;
import org.jetbrains.kotlin.com.intellij.core.CoreJavaFileManager;
import org.jetbrains.kotlin.com.intellij.core.JavaCoreApplicationEnvironment;
import org.jetbrains.kotlin.com.intellij.core.JavaCoreProjectEnvironment;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaParserDefinition;
import org.jetbrains.kotlin.com.intellij.mock.MockApplication;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuardImpl;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.PlainTextFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.PersistentFSConstants;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler;
import org.jetbrains.kotlin.com.intellij.psi.FileContextProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.augment.PsiAugmentProvider;
import org.jetbrains.kotlin.com.intellij.psi.augment.TypeAnnotationModifier;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClassFileDecompilers;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaClassSupersImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiElementFinderImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.JavaFileManager;
import org.jetbrains.kotlin.com.intellij.psi.meta.MetaDataContributor;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaClassSupers;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.config.AppendJavaSourceRootsHandlerKeyKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRoot;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.extensions.DeclarationAttributeAltererExtension;
import org.jetbrains.kotlin.extensions.StorageComponentContainerContributor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.load.kotlin.JvmVirtualFileFinderFactory;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CodeAnalyzerInitializer;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;
import org.jetbrains.kotlin.resolve.jvm.extensions.AnalysisHandlerExtension;
import org.jetbrains.kotlin.resolve.jvm.extensions.PackageFragmentProviderExtension;
import org.jetbrains.kotlin.resolve.lazy.declarations.CliDeclarationProviderFactoryService;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactoryService;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProvider;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 B2\u00020\u0001:\u0001BB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010*\u001a\u0004\u0018\u00010\u001b2\u0006\u0010+\u001a\u00020,H\u0002J\u0014\u0010-\u001a\u00020\r2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u000bJ\u0010\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020,J\u0014\u00103\u001a\u00020%2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000bJ\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u00105\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u000206H\u0002J\u0012\u00107\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020,H\u0002J\f\u00108\u001a\b\u0012\u0004\u0012\u00020#0\u000bJ\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0002J\b\u0010<\u001a\u00020=H\u0002J\u0018\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020;H\u0002R#\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010$\u001a\u00020%8F\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "", "parentDisposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "applicationEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/JavaCoreApplicationEnvironment;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/core/JavaCoreApplicationEnvironment;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "appendJavaSourceRootsHandler", "Lkotlin/Function1;", "", "Ljava/io/File;", "", "getAppendJavaSourceRootsHandler", "()Lkotlin/jvm/functions/Function1;", "application", "Lorg/jetbrains/kotlin/com/intellij/mock/MockApplication;", "getApplication", "()Lcom/intellij/mock/MockApplication;", "Lorg/jetbrains/kotlin/com/intellij/core/CoreApplicationEnvironment;", "getApplicationEnvironment", "()Lcom/intellij/core/CoreApplicationEnvironment;", "getConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "javaRoots", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/JavaRoot;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/JavaCoreProjectEnvironment;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "sourceLinesOfCode", "", "getSourceLinesOfCode", "()I", "sourceLinesOfCode$delegate", "Lkotlin/Lazy;", "addJavaRoot", "javaRoot", "Lorg/jetbrains/kotlin/cli/jvm/config/JvmContentRoot;", "addJavaSourceRoots", "newRoots", "Lorg/jetbrains/kotlin/cli/jvm/config/JavaSourceRoot;", "contentRootToVirtualFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "root", "countLinesOfCode", "fillClasspath", "findJarRoot", "Lorg/jetbrains/kotlin/cli/jvm/config/JvmClasspathRoot;", "findLocalDirectory", "getSourceFiles", "getSourceRootsCheckingForDuplicates", "", "", "initJvmDependenciesIndex", "Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmDependenciesIndex;", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "Companion", "kotlin-compiler"})
public final class KotlinCoreEnvironment {
    private final JavaCoreProjectEnvironment projectEnvironment;
    private final ArrayList<KtFile> sourceFiles;
    private final ArrayList<JavaRoot> javaRoots;
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final Lazy sourceLinesOfCode$delegate;
    @NotNull
    private final Function1<List<? extends File>, Unit> appendJavaSourceRootsHandler;
    private static final Object APPLICATION_LOCK;
    private static JavaCoreApplicationEnvironment ourApplicationEnvironment;
    private static int ourProjectCount;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final Companion Companion;

    @NotNull
    public final CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    private final CoreApplicationEnvironment getApplicationEnvironment() {
        CoreApplicationEnvironment coreApplicationEnvironment = this.projectEnvironment.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull(coreApplicationEnvironment, "projectEnvironment.environment");
        return coreApplicationEnvironment;
    }

    @NotNull
    public final MockApplication getApplication() {
        MockApplication mockApplication = this.getApplicationEnvironment().getApplication();
        Intrinsics.checkExpressionValueIsNotNull(mockApplication, "applicationEnvironment.application");
        return mockApplication;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.projectEnvironment.getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "projectEnvironment.project");
        return project;
    }

    public final int getSourceLinesOfCode() {
        Lazy lazy = this.sourceLinesOfCode$delegate;
        KotlinCoreEnvironment kotlinCoreEnvironment = this;
        KProperty kProperty = $$delegatedProperties[0];
        return ((Number)lazy.getValue()).intValue();
    }

    private final JvmDependenciesIndex initJvmDependenciesIndex() {
        CoreJavaFileManager fileManager;
        JvmDependenciesIndex index2 = new JvmDependenciesIndex((List<JavaRoot>)this.javaRoots);
        CoreJavaFileManager coreJavaFileManager = fileManager = ServiceManager.getService(this.getProject(), CoreJavaFileManager.class);
        if (coreJavaFileManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cli.jvm.compiler.KotlinCliJavaFileManagerImpl");
        }
        ((KotlinCliJavaFileManagerImpl)coreJavaFileManager).initIndex(index2);
        return index2;
    }

    @NotNull
    public final Function1<List<? extends File>, Unit> getAppendJavaSourceRootsHandler() {
        return this.appendJavaSourceRootsHandler;
    }

    public final void addJavaSourceRoots(@NotNull List<JavaSourceRoot> newRoots) {
        Intrinsics.checkParameterIsNotNull(newRoots, "newRoots");
        Iterable $receiver$iv = newRoots;
        for (Object element$iv : $receiver$iv) {
            JavaSourceRoot it = (JavaSourceRoot)element$iv;
            this.addJavaRoot(it);
        }
        this.initJvmDependenciesIndex();
    }

    /*
     * WARNING - void declaration
     */
    public final int countLinesOfCode(@NotNull List<? extends KtFile> sourceFiles2) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull(sourceFiles2, "sourceFiles");
        Iterable $receiver$iv = sourceFiles2;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void it;
            KtFile ktFile = (KtFile)element$iv;
            int n = sum$iv;
            String text = it.getText();
            int n2 = StringUtil.getLineBreakCount(it.getText()) + (StringUtil.endsWithLineBreak(text) ? 0 : 1);
            sum$iv = n + n2;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JavaRoot> fillClasspath(CompilerConfiguration configuration) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = configuration.getList(JVMConfigurationKeys.CONTENT_ROOTS);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        void var5_5 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            JavaRoot javaRoot;
            Object element$iv$iv = element$iv$iv$iv;
            ContentRoot root = (ContentRoot)element$iv$iv;
            if ((root instanceof JvmContentRoot ? this.addJavaRoot((JvmContentRoot)root) : (JavaRoot)null) == null) continue;
            javaRoot = javaRoot;
            JavaRoot it$iv$iv = javaRoot;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final JavaRoot addJavaRoot(JvmContentRoot javaRoot) {
        void $receiver;
        JavaRoot.RootType rootType;
        FqName fqName2;
        Object object;
        VirtualFile virtualFile = this.contentRootToVirtualFile(javaRoot);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        this.projectEnvironment.addSourcesToClasspath(virtualFile2);
        JvmContentRoot jvmContentRoot = javaRoot;
        if (!(jvmContentRoot instanceof JavaSourceRoot)) {
            jvmContentRoot = null;
        }
        if ((object = (JavaSourceRoot)jvmContentRoot) != null && (object = ((JavaSourceRoot)object).getPackagePrefix()) != null) {
            FqName fqName3;
            Object object2 = object;
            String it = (String)object2;
            if (FqNamesUtilKt.isValidJavaFqName(it)) {
                fqName3 = new FqName(it);
            } else {
                this.report(CompilerMessageSeverity.STRONG_WARNING, "Invalid package prefix name is ignored: " + it);
                fqName3 = null;
            }
            fqName2 = fqName3;
        } else {
            fqName2 = null;
        }
        FqName prefixPackageFqName = fqName2;
        Object object3 = javaRoot;
        if (object3 instanceof JavaSourceRoot) {
            rootType = JavaRoot.RootType.SOURCE;
        } else if (object3 instanceof JvmClasspathRoot) {
            rootType = JavaRoot.RootType.BINARY;
        } else {
            throw (Throwable)new IllegalStateException();
        }
        JavaRoot.RootType rootType2 = rootType;
        object3 = new JavaRoot(virtualFile2, rootType2, prefixPackageFqName);
        JavaRoot $i$a$1$let = (JavaRoot)object3;
        this.javaRoots.add((JavaRoot)$receiver);
        return (JavaRoot)object3;
    }

    @Nullable
    public final VirtualFile contentRootToVirtualFile(@NotNull JvmContentRoot root) {
        Intrinsics.checkParameterIsNotNull(root, "root");
        JvmContentRoot jvmContentRoot = root;
        if (jvmContentRoot instanceof JvmClasspathRoot) {
            return root.getFile().isFile() ? this.findJarRoot((JvmClasspathRoot)root) : this.findLocalDirectory(root);
        }
        if (jvmContentRoot instanceof JavaSourceRoot) {
            return root.getFile().isDirectory() ? this.findLocalDirectory(root) : (VirtualFile)null;
        }
        throw (Throwable)new IllegalStateException("Unexpected root: " + root);
    }

    private final VirtualFile findLocalDirectory(JvmContentRoot root) {
        File path = root.getFile();
        VirtualFile localFile = this.getApplicationEnvironment().getLocalFileSystem().findFileByPath(path.getAbsolutePath());
        if (localFile == null) {
            this.report(CompilerMessageSeverity.STRONG_WARNING, "Classpath entry points to a non-existent location: " + path);
            return null;
        }
        return localFile;
    }

    private final VirtualFile findJarRoot(JvmClasspathRoot root) {
        File path = root.getFile();
        VirtualFile jarFile = this.getApplicationEnvironment().getJarFileSystem().findFileByPath(path + "!/");
        if (jarFile == null) {
            this.report(CompilerMessageSeverity.STRONG_WARNING, "Classpath entry points to a file that is not a JAR archive: " + path);
            return null;
        }
        return jarFile;
    }

    private final Collection<String> getSourceRootsCheckingForDuplicates() {
        LinkedHashSet<String> uniqueSourceRoots = Sets.newLinkedHashSet();
        Iterable $receiver$iv = ContentRootsKt.getKotlinSourceRoots(this.configuration);
        for (Object element$iv : $receiver$iv) {
            String path = (String)element$iv;
            if (uniqueSourceRoots.add(path)) continue;
            this.report(CompilerMessageSeverity.STRONG_WARNING, "Duplicate source root: " + path);
        }
        Collection collection = uniqueSourceRoots;
        Intrinsics.checkExpressionValueIsNotNull(collection, "uniqueSourceRoots");
        return collection;
    }

    @NotNull
    public final List<KtFile> getSourceFiles() {
        return this.sourceFiles;
    }

    private final void report(CompilerMessageSeverity severity, String message) {
        MessageCollector messageCollector = this.configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        messageCollector.report(severity, message, CompilerMessageLocation.NO_LOCATION);
    }

    /*
     * WARNING - void declaration
     */
    private KotlinCoreEnvironment(Disposable parentDisposable, JavaCoreApplicationEnvironment applicationEnvironment, CompilerConfiguration configuration) {
        MessageCollector messageCollector;
        void $receiver;
        this.projectEnvironment = new KotlinCoreProjectEnvironment(parentDisposable, applicationEnvironment, parentDisposable, applicationEnvironment){
            final /* synthetic */ Disposable $parentDisposable;
            final /* synthetic */ JavaCoreApplicationEnvironment $applicationEnvironment;

            protected void preregisterServices() {
                ExtensionsArea extensionsArea = Extensions.getArea(this.getProject());
                Intrinsics.checkExpressionValueIsNotNull(extensionsArea, "Extensions.getArea(getProject())");
                org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$registerProjectExtensionPoints(KotlinCoreEnvironment.Companion, extensionsArea);
            }
            {
                this.$parentDisposable = $captured_local_variable$0;
                this.$applicationEnvironment = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
        this.sourceFiles = new ArrayList();
        this.javaRoots = new ArrayList();
        CompilerConfiguration compilerConfiguration = configuration.copy();
        Object object = this;
        CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
        $receiver.setReadOnly(true);
        Object object2 = compilerConfiguration;
        CompilerConfiguration compilerConfiguration3 = object2;
        Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration3, "configuration.copy().apply { setReadOnly(true) }");
        ((KotlinCoreEnvironment)object).configuration = compilerConfiguration3;
        PersistentFSConstants.setMaxIntellisenseFileSize(FileUtilRt.LARGE_FOR_CONTENT_LOADING);
        MockProject project = this.projectEnvironment.getProject();
        project.registerService(DeclarationProviderFactoryService.class, new CliDeclarationProviderFactoryService((Collection<? extends KtFile>)this.sourceFiles));
        project.registerService(ModuleVisibilityManager.class, new CliModuleVisibilityManagerImpl());
        KotlinCoreEnvironment.Companion.registerProjectServicesForCLI(this.projectEnvironment);
        Companion.registerProjectServices(this.projectEnvironment);
        List<JavaRoot> javaClasspathRoots = this.fillClasspath(configuration);
        JvmDependenciesIndex index2 = this.initJvmDependenciesIndex();
        this.sourceFiles.addAll((Collection<KtFile>)CompileEnvironmentUtil.getKtFiles(project, this.getSourceRootsCheckingForDuplicates(), this.configuration, new Function1<String, Unit>(){

            @Override
            public final void invoke(String message) {
                String string = message;
                Intrinsics.checkExpressionValueIsNotNull(string, "message");
                this.report(CompilerMessageSeverity.ERROR, string);
            }
        }));
        CollectionsKt.sortedWith((Iterable)this.sourceFiles, (Comparator)new Comparator<KtFile>(){

            @Override
            public int compare(@NotNull KtFile o1, @NotNull KtFile o2) {
                Intrinsics.checkParameterIsNotNull(o1, "o1");
                Intrinsics.checkParameterIsNotNull(o2, "o2");
                String string = o1.getVirtualFile().getPath();
                String string2 = o2.getVirtualFile().getPath();
                Intrinsics.checkExpressionValueIsNotNull(string2, "o2.virtualFile.path");
                return StringsKt.compareTo(string, string2, true);
            }
        });
        KotlinScriptDefinitionProvider.getInstance(project).setScriptDefinitions(configuration.getList(JVMConfigurationKeys.SCRIPT_DEFINITIONS));
        project.registerService(JvmVirtualFileFinderFactory.class, new JvmCliVirtualFileFinderFactory(index2));
        if (!configuration.getBoolean(JVMConfigurationKeys.SKIP_RUNTIME_VERSION_CHECK) && (messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY)) != null) {
            void destination$iv$iv;
            void $receiver$iv$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = javaClasspathRoots;
            CompilerConfiguration compilerConfiguration4 = configuration;
            object2 = messageCollector;
            object = JvmRuntimeVersionsConsistencyChecker.INSTANCE;
            void var12_12 = $receiver$iv;
            Collection collection = new ArrayList();
            void var14_14 = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                VirtualFile virtualFile;
                Object element$iv$iv = element$iv$iv$iv;
                JavaRoot root = (JavaRoot)element$iv$iv;
                if ((Intrinsics.areEqual((Object)root.getType(), (Object)JavaRoot.RootType.BINARY) ? root.getFile() : (VirtualFile)null) == null) continue;
                virtualFile = virtualFile;
                VirtualFile it$iv$iv = virtualFile;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            ((JvmRuntimeVersionsConsistencyChecker)object).checkCompilerClasspathConsistency((MessageCollector)object2, compilerConfiguration4, list2);
        }
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull(project2, "project");
        ExpressionCodegenExtension.Companion.registerExtensionPoint(project2);
        Project project3 = project;
        Intrinsics.checkExpressionValueIsNotNull(project3, "project");
        ClassBuilderInterceptorExtension.Companion.registerExtensionPoint(project3);
        Project project4 = project;
        Intrinsics.checkExpressionValueIsNotNull(project4, "project");
        AnalysisHandlerExtension.Companion.registerExtensionPoint(project4);
        Project project5 = project;
        Intrinsics.checkExpressionValueIsNotNull(project5, "project");
        PackageFragmentProviderExtension.Companion.registerExtensionPoint(project5);
        Project project6 = project;
        Intrinsics.checkExpressionValueIsNotNull(project6, "project");
        StorageComponentContainerContributor.Companion.registerExtensionPoint(project6);
        Project project7 = project;
        Intrinsics.checkExpressionValueIsNotNull(project7, "project");
        DeclarationAttributeAltererExtension.Companion.registerExtensionPoint(project7);
        for (ComponentRegistrar registrar : configuration.getList(ComponentRegistrar.Companion.getPLUGIN_COMPONENT_REGISTRARS())) {
            MockProject mockProject = project;
            Intrinsics.checkExpressionValueIsNotNull(mockProject, "project");
            registrar.registerProjectComponents(mockProject, configuration);
        }
        this.sourceLinesOfCode$delegate = LazyKt.lazy((Function0)new Function0<Integer>(this){
            final /* synthetic */ KotlinCoreEnvironment this$0;

            public final int invoke() {
                return this.this$0.countLinesOfCode(KotlinCoreEnvironment.access$getSourceFiles$p(this.this$0));
            }
            {
                this.this$0 = kotlinCoreEnvironment;
                super(0);
            }
        });
        this.appendJavaSourceRootsHandler = new Function1<List<? extends File>, Unit>(this){
            final /* synthetic */ KotlinCoreEnvironment this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<? extends File> roots2) {
                List list2;
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull(roots2, "roots");
                Iterable iterable = roots2;
                KotlinCoreEnvironment kotlinCoreEnvironment = this.this$0;
                void var4_4 = $receiver$iv;
                Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    list2 = destination$iv$iv;
                    JavaSourceRoot javaSourceRoot = new JavaSourceRoot((File)it, null);
                    list2.add(javaSourceRoot);
                }
                list2 = (List)destination$iv$iv;
                kotlinCoreEnvironment.addJavaSourceRoots(list2);
            }
            {
                this.this$0 = kotlinCoreEnvironment;
                super(1);
            }
        };
        this.getProject().putUserData(AppendJavaSourceRootsHandlerKeyKt.getAPPEND_JAVA_SOURCE_ROOTS_HANDLER_KEY(), this.appendJavaSourceRootsHandler);
    }

    static {
        Companion = new Companion(null);
        KotlinCoreEnvironment.Companion.setCompatibleBuild();
        APPLICATION_LOCK = new Object();
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(KotlinCoreEnvironment.class), "sourceLinesOfCode", "getSourceLinesOfCode()I"))};
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getSourceFiles$p(KotlinCoreEnvironment $this) {
        return $this.sourceFiles;
    }

    public /* synthetic */ KotlinCoreEnvironment(@NotNull Disposable parentDisposable, @NotNull JavaCoreApplicationEnvironment applicationEnvironment, @NotNull CompilerConfiguration configuration, DefaultConstructorMarker $constructor_marker) {
        this(parentDisposable, applicationEnvironment, configuration);
    }

    @JvmStatic
    @NotNull
    public static final KotlinCoreEnvironment createForProduction(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> configFilePaths) {
        Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(configFilePaths, "configFilePaths");
        return Companion.createForProduction(parentDisposable, configuration, configFilePaths);
    }

    @JvmStatic
    @NotNull
    public static final KotlinCoreEnvironment createForTests(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> extensionConfigs) {
        Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(extensionConfigs, "extensionConfigs");
        return Companion.createForTests(parentDisposable, configuration, extensionConfigs);
    }

    @JvmStatic
    public static final void registerApplicationServices(@NotNull JavaCoreApplicationEnvironment applicationEnvironment) {
        Intrinsics.checkParameterIsNotNull(applicationEnvironment, "applicationEnvironment");
        Companion.registerApplicationServices(applicationEnvironment);
    }

    @JvmStatic
    public static final void registerProjectServices(@NotNull JavaCoreProjectEnvironment projectEnvironment2) {
        Intrinsics.checkParameterIsNotNull(projectEnvironment2, "projectEnvironment");
        Companion.registerProjectServices(projectEnvironment2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J&\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J\u0006\u0010!\u001a\u00020\"J\u001e\u0010#\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\b\u0010$\u001a\u00020\"H\u0002J\u0018\u0010%\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001cH\u0002J\u0010\u0010'\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010(\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0007J\u0010\u0010/\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0002J\b\u00100\u001a\u00020\"H\u0003R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment$Companion;", "", "()V", "APPLICATION_LOCK", "Ljava/lang/Object;", "getAPPLICATION_LOCK", "()Ljava/lang/Object;", "applicationEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/JavaCoreApplicationEnvironment;", "getApplicationEnvironment", "()Lcom/intellij/core/JavaCoreApplicationEnvironment;", "ourApplicationEnvironment", "getOurApplicationEnvironment", "setOurApplicationEnvironment", "(Lcom/intellij/core/JavaCoreApplicationEnvironment;)V", "ourProjectCount", "", "getOurProjectCount", "()I", "setOurProjectCount", "(I)V", "createApplicationEnvironment", "parentDisposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "configFilePaths", "", "", "createForProduction", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "createForTests", "extensionConfigs", "disposeApplicationEnvironment", "", "getOrCreateApplicationEnvironmentForProduction", "registerAppExtensionPoints", "registerApplicationExtensionPointsAndExtensionsFrom", "configFilePath", "registerApplicationServices", "registerApplicationServicesForCLI", "registerProjectExtensionPoints", "area", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/ExtensionsArea;", "registerProjectServices", "projectEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/JavaCoreProjectEnvironment;", "registerProjectServicesForCLI", "setCompatibleBuild", "kotlin-compiler"})
    public static final class Companion {
        private final Object getAPPLICATION_LOCK() {
            return APPLICATION_LOCK;
        }

        private final JavaCoreApplicationEnvironment getOurApplicationEnvironment() {
            return ourApplicationEnvironment;
        }

        private final void setOurApplicationEnvironment(JavaCoreApplicationEnvironment javaCoreApplicationEnvironment) {
            ourApplicationEnvironment = javaCoreApplicationEnvironment;
        }

        private final int getOurProjectCount() {
            return ourProjectCount;
        }

        private final void setOurProjectCount(int n) {
            ourProjectCount = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final KotlinCoreEnvironment createForProduction(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> configFilePaths) {
            Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(configFilePaths, "configFilePaths");
            this.setCompatibleBuild();
            JavaCoreApplicationEnvironment appEnv = this.getOrCreateApplicationEnvironmentForProduction(configuration, configFilePaths);
            Boolean bl = PropertiesKt.toBooleanLenient(System.getProperty(PropertiesKt.getKOTLIN_COMPILER_ENVIRONMENT_KEEPALIVE_PROPERTY()));
            if (!(bl != null ? bl : false)) {
                Disposer.register(parentDisposable, new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        Object object = org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getAPPLICATION_LOCK$p(KotlinCoreEnvironment.Companion);
                        synchronized (object) {
                            Companion companion = KotlinCoreEnvironment.Companion;
                            org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$setOurProjectCount$p(companion, org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getOurProjectCount$p(companion) + -1);
                            if (org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getOurProjectCount$p(companion) <= 0) {
                                KotlinCoreEnvironment.Companion.disposeApplicationEnvironment();
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
            }
            KotlinCoreEnvironment environment2 = new KotlinCoreEnvironment(parentDisposable, appEnv, configuration, null);
            Object object = this.getAPPLICATION_LOCK();
            synchronized (object) {
                Companion companion = Companion;
                int n = companion.getOurProjectCount();
                companion.setOurProjectCount(n + 1);
                int n2 = n;
            }
            return environment2;
        }

        @JvmStatic
        private final void setCompatibleBuild() {
            System.getProperties().setProperty("idea.plugins.compatible.build", "162.9999");
        }

        @JvmStatic
        @NotNull
        public final KotlinCoreEnvironment createForTests(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> extensionConfigs) {
            Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(extensionConfigs, "extensionConfigs");
            return new KotlinCoreEnvironment(parentDisposable, this.createApplicationEnvironment(parentDisposable, configuration, extensionConfigs), configuration, null);
        }

        @Nullable
        public final JavaCoreApplicationEnvironment getApplicationEnvironment() {
            return Companion.getOurApplicationEnvironment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final JavaCoreApplicationEnvironment getOrCreateApplicationEnvironmentForProduction(CompilerConfiguration configuration, List<String> configFilePaths) {
            Object object = this.getAPPLICATION_LOCK();
            synchronized (object) {
                Disposable parentDisposable;
                block6: {
                    if (Companion.getOurApplicationEnvironment() == null) break block6;
                    JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = Companion.getOurApplicationEnvironment();
                    if (javaCoreApplicationEnvironment == null) {
                        Intrinsics.throwNpe();
                    }
                    JavaCoreApplicationEnvironment javaCoreApplicationEnvironment2 = javaCoreApplicationEnvironment;
                    return javaCoreApplicationEnvironment2;
                }
                Disposable disposable = parentDisposable = Disposer.newDisposable();
                Intrinsics.checkExpressionValueIsNotNull(disposable, "parentDisposable");
                Companion.setOurApplicationEnvironment(Companion.createApplicationEnvironment(disposable, configuration, configFilePaths));
                Companion.setOurProjectCount(0);
                Disposer.register(parentDisposable, new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        Object object = org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getAPPLICATION_LOCK$p(KotlinCoreEnvironment.Companion);
                        synchronized (object) {
                            org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$setOurApplicationEnvironment$p(KotlinCoreEnvironment.Companion, null);
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = Companion.getOurApplicationEnvironment();
                if (javaCoreApplicationEnvironment == null) {
                    Intrinsics.throwNpe();
                }
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment3 = javaCoreApplicationEnvironment;
                return javaCoreApplicationEnvironment3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void disposeApplicationEnvironment() {
            Object object = this.getAPPLICATION_LOCK();
            synchronized (object) {
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = Companion.getOurApplicationEnvironment();
                if (javaCoreApplicationEnvironment == null) {
                    return;
                }
                JavaCoreApplicationEnvironment environment2 = javaCoreApplicationEnvironment;
                Companion.setOurApplicationEnvironment(null);
                Disposer.dispose(environment2.getParentDisposable());
                ZipHandler.clearFileAccessorCache();
                Unit unit = Unit.INSTANCE;
            }
        }

        private final JavaCoreApplicationEnvironment createApplicationEnvironment(Disposable parentDisposable, CompilerConfiguration configuration, List<String> configFilePaths) {
            Extensions.cleanRootArea(parentDisposable);
            this.registerAppExtensionPoints();
            JavaCoreApplicationEnvironment applicationEnvironment = new JavaCoreApplicationEnvironment(parentDisposable);
            for (String configPath : configFilePaths) {
                this.registerApplicationExtensionPointsAndExtensionsFrom(configuration, configPath);
            }
            this.registerApplicationServicesForCLI(applicationEnvironment);
            this.registerApplicationServices(applicationEnvironment);
            return applicationEnvironment;
        }

        private final void registerAppExtensionPoints() {
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), "org.jetbrains.kotlin.com.intellij.filetype.stubBuilder", FileTypeExtensionPoint.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), FileContextProvider.EP_NAME, FileContextProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), MetaDataContributor.EP_NAME, MetaDataContributor.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), JavaMainMethodProvider.EP_NAME, JavaMainMethodProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ContainerProvider.EP_NAME, ContainerProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClsCustomNavigationPolicy.EP_NAME, ClsCustomNavigationPolicy.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClassFileDecompilers.EP_NAME, ClassFileDecompilers.Decompiler.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), TypeAnnotationModifier.EP_NAME, TypeAnnotationModifier.class);
        }

        private final void registerApplicationExtensionPointsAndExtensionsFrom(CompilerConfiguration configuration, String configFilePath) {
            CompilerJarLocator locator = configuration.get(CLIConfigurationKeys.COMPILER_JAR_LOCATOR);
            File pluginRoot = locator == null ? PathUtil.getPathUtilJar() : locator.getCompilerJar();
            Application app = ApplicationManager.getApplication();
            File parentFile = pluginRoot.getParentFile();
            if (pluginRoot.isDirectory() && app != null && app.isUnitTestMode() && StringsKt.endsWith$default(FileUtil.toCanonicalPath(parentFile.getPath()), "out/production", false, 2, null)) {
                File srcDir = parentFile.getParentFile().getParentFile();
                pluginRoot = new File(srcDir, "idea/src");
            }
            CoreApplicationEnvironment.registerExtensionPointAndExtensions(pluginRoot, configFilePath, Extensions.getRootArea());
        }

        private final void registerApplicationServicesForCLI(JavaCoreApplicationEnvironment applicationEnvironment) {
            applicationEnvironment.registerFileType(PlainTextFileType.INSTANCE, "xml");
            applicationEnvironment.registerParserDefinition(new JavaParserDefinition());
        }

        @JvmStatic
        public final void registerApplicationServices(@NotNull JavaCoreApplicationEnvironment applicationEnvironment) {
            Intrinsics.checkParameterIsNotNull(applicationEnvironment, "applicationEnvironment");
            JavaCoreApplicationEnvironment $receiver = applicationEnvironment;
            $receiver.registerFileType(KotlinFileType.INSTANCE, "kt");
            $receiver.registerFileType(KotlinFileType.INSTANCE, KotlinParserDefinition.STD_SCRIPT_SUFFIX);
            $receiver.registerParserDefinition(new KotlinParserDefinition());
            $receiver.getApplication().registerService(KotlinBinaryClassCache.class, new KotlinBinaryClassCache());
            $receiver.getApplication().registerService(JavaClassSupers.class, JavaClassSupersImpl.class);
            $receiver.getApplication().registerService(TransactionGuard.class, TransactionGuardImpl.class);
        }

        private final void registerProjectExtensionPoints(ExtensionsArea area) {
            CoreApplicationEnvironment.registerExtensionPoint(area, PsiTreeChangePreprocessor.EP_NAME, PsiTreeChangePreprocessor.class);
            CoreApplicationEnvironment.registerExtensionPoint(area, PsiElementFinder.EP_NAME, PsiElementFinder.class);
        }

        @JvmStatic
        public final void registerProjectServices(@NotNull JavaCoreProjectEnvironment projectEnvironment2) {
            Intrinsics.checkParameterIsNotNull(projectEnvironment2, "projectEnvironment");
            MockProject mockProject = projectEnvironment2.getProject();
            MockProject $receiver = mockProject;
            $receiver.registerService(KotlinScriptDefinitionProvider.class, new KotlinScriptDefinitionProvider());
            $receiver.registerService(KotlinJavaPsiFacade.class, new KotlinJavaPsiFacade($receiver));
            Project project = $receiver;
            Intrinsics.checkExpressionValueIsNotNull(project, "this");
            $receiver.registerService(KtLightClassForFacade.FacadeStubCache.class, new KtLightClassForFacade.FacadeStubCache(project));
        }

        private final void registerProjectServicesForCLI(JavaCoreProjectEnvironment projectEnvironment2) {
            MockProject mockProject = projectEnvironment2.getProject();
            MockProject $receiver = mockProject;
            JavaFileManager javaFileManager = ServiceManager.getService($receiver, JavaFileManager.class);
            if (javaFileManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.core.CoreJavaFileManager");
            }
            $receiver.registerService(CoreJavaFileManager.class, (CoreJavaFileManager)javaFileManager);
            Project project = $receiver;
            Intrinsics.checkExpressionValueIsNotNull(project, "this");
            CliLightClassGenerationSupport cliLightClassGenerationSupport = new CliLightClassGenerationSupport(project);
            $receiver.registerService(LightClassGenerationSupport.class, cliLightClassGenerationSupport);
            $receiver.registerService(CliLightClassGenerationSupport.class, cliLightClassGenerationSupport);
            $receiver.registerService(CodeAnalyzerInitializer.class, cliLightClassGenerationSupport);
            $receiver.registerService(ExternalAnnotationsManager.class, new MockExternalAnnotationsManager());
            $receiver.registerService(InferredAnnotationsManager.class, new MockInferredAnnotationsManager());
            ExtensionsArea area = Extensions.getArea($receiver);
            area.getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new JavaElementFinder($receiver, cliLightClassGenerationSupport));
            area.getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new PsiElementFinderImpl($receiver, ServiceManager.getService($receiver, JavaFileManager.class)));
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$registerProjectExtensionPoints(Companion $this, @NotNull ExtensionsArea area) {
            $this.registerProjectExtensionPoints(area);
        }

        @NotNull
        public static final /* synthetic */ Object access$getAPPLICATION_LOCK$p(Companion $this) {
            return $this.getAPPLICATION_LOCK();
        }

        public static final /* synthetic */ int access$getOurProjectCount$p(Companion $this) {
            return $this.getOurProjectCount();
        }

        public static final /* synthetic */ void access$setOurProjectCount$p(Companion $this, int n) {
            $this.setOurProjectCount(n);
        }

        @Nullable
        public static final /* synthetic */ JavaCoreApplicationEnvironment access$getOurApplicationEnvironment$p(Companion $this) {
            return $this.getOurApplicationEnvironment();
        }

        public static final /* synthetic */ void access$setOurApplicationEnvironment$p(Companion $this, @Nullable JavaCoreApplicationEnvironment javaCoreApplicationEnvironment) {
            $this.setOurApplicationEnvironment(javaCoreApplicationEnvironment);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

