/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiBundle;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class CheckUtil {
    private CheckUtil() {
    }

    public static void checkWritable(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/CheckUtil", "checkWritable"));
        }
        if (!element.isWritable()) {
            if (element instanceof PsiDirectory) {
                String url = ((PsiDirectory)element).getVirtualFile().getPresentableUrl();
                throw new IncorrectOperationException(PsiBundle.message("cannot.modify.a.read.only.directory", url));
            }
            PsiFile file = element.getContainingFile();
            if (file == null) {
                throw new IncorrectOperationException();
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                throw new IncorrectOperationException();
            }
            throw new IncorrectOperationException(PsiBundle.message("cannot.modify.a.read.only.file", virtualFile.getPresentableUrl()));
        }
    }

    public static void checkDelete(@NotNull VirtualFile file) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/CheckUtil", "checkDelete"));
        }
        VfsUtilCore.visitChildrenRecursively(file, new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/CheckUtil$1", "visitFile"));
                }
                if (FileTypeRegistry.getInstance().isFileIgnored(file)) {
                    return false;
                }
                if (!file.isWritable()) {
                    throw new IncorrectOperationException(PsiBundle.message("cannot.delete.a.read.only.file", file.getPresentableUrl()));
                }
                return true;
            }
        });
    }
}

