/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ExposedVisibilityChecker;
import org.jetbrains.kotlin.resolve.FiniteBoundRestrictionChecker;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.NonExpansiveInheritanceRestrictionChecker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 `2\u00020\u0001:\u0001`B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020!H\u0002J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.2\u0006\u0010\"\u001a\u00020/H\u0002J\u0016\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u0018\u00105\u001a\u00020\u00122\u0006\u0010'\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J \u00109\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020/H\u0002J\u0010\u0010:\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010>\u001a\u00020\u00122\u0006\u0010'\u001a\u00020?2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010@\u001a\u00020\u00122\u0006\u00107\u001a\u00020A2\u0006\u0010'\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010F\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020/H\u0002J\u0018\u0010G\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010H\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010I\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u0002062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010J\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u0014H\u0002J\u0018\u0010K\u001a\u00020\u00122\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010P\u001a\u00020\u00122\u0006\u0010Q\u001a\u00020DH\u0002J\u0010\u0010R\u001a\u00020\u00122\u0006\u0010Q\u001a\u00020DH\u0002J\u0010\u0010S\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010T\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010U\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010V\u001a\u000208H\u0002J\u000e\u0010W\u001a\u00020\u00122\u0006\u0010X\u001a\u00020YJ$\u0010Z\u001a\u00020\u00122\f\u0010[\u001a\b\u0012\u0004\u0012\u00020O0\\2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020O0^H\u0002J\n\u0010_\u001a\u00020\u0012*\u00020(R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\u000b0\u000fR\u00020\u0005\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker;", "", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "annotationChecker", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/AnnotationChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "exposedChecker", "Lorg/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure;", "Lorg/jetbrains/annotations/NotNull;", "checkAccessor", "", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "checkAccessors", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkAnnotationClassWithBody", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkClassButNotObject", "aClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "checkConstructorDeclaration", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "checkConstructorInInterface", "klass", "checkConstructorVisibility", "checkEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "checkImplicitCallableType", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkMemberProperty", "checkMethodsOfAnyInInterface", "checkModifiersAndAnnotationsInPackageDirective", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "checkOnlyOneTypeParameterBound", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "owner", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "checkOpenMembers", "checkPrimaryConstructor", "checkProperty", "checkPropertyInitializer", "checkPropertyLateInit", "checkPropertyTypeParametersAreUsedInReceiverType", "checkSupertypesForConsistency", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "sourceElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "checkTypeParameterConstraints", "typeParameterListOwner", "checkTypeParameters", "checkTypesInClassHeader", "checkValOnAnnotationParameter", "checkVarargParameters", "callableDescriptor", "process", "bodiesResolveContext", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "reportVisibilityModifierDiagnostics", "tokens", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "checkTypeReferences", "Companion", "kotlin-compiler"})
public final class DeclarationsChecker {
    private final ModifiersChecker.ModifiersCheckingProcedure modifiersChecker;
    private final ExposedVisibilityChecker exposedChecker;
    private final DescriptorResolver descriptorResolver;
    private final AnnotationChecker annotationChecker;
    private final IdentifierChecker identifierChecker;
    private final BindingTrace trace;
    private static final ImmutableSet<String> METHOD_OF_ANY_NAMES;
    public static final Companion Companion;

    public final void checkTypeReferences(@NotNull KtDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DeclarationsCheckerKt.checkTypeReferences($receiver, this.trace);
    }

    public final void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        Object propertyDescriptor;
        Object functionDescriptor;
        Object classDescriptor;
        Object object;
        Intrinsics.checkParameterIsNotNull(bodiesResolveContext, "bodiesResolveContext");
        Iterator<Object> iterator2 = bodiesResolveContext.getFiles().iterator();
        while (iterator2.hasNext()) {
            KtFile entry;
            KtFile ktFile = entry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(ktFile, "file");
            this.checkModifiersAndAnnotationsInPackageDirective(ktFile);
            KtAnnotated ktAnnotated = entry;
            Intrinsics.checkExpressionValueIsNotNull(ktAnnotated, "file");
            this.annotationChecker.check(ktAnnotated, this.trace, null);
        }
        iterator2 = bodiesResolveContext.getDeclaredClasses().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            KtClassOrObject classOrObject = (KtClassOrObject)entry2.getKey();
            object = entry;
            classDescriptor = (ClassDescriptorWithResolutionScopes)object.getValue();
            ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "classDescriptor");
            PsiElement psiElement = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(psiElement, "classOrObject");
            this.checkSupertypesForConsistency(classifierDescriptor, psiElement);
            KtClassOrObject ktClassOrObject = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject, "classOrObject");
            this.checkTypesInClassHeader(ktClassOrObject);
            object = classOrObject;
            if (object instanceof KtClass) {
                KtClass ktClass = (KtClass)classOrObject;
                Object object2 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(object2, "classDescriptor");
                this.checkClassButNotObject(ktClass, (ClassDescriptorWithResolutionScopes)object2);
                this.descriptorResolver.checkNamesInConstraints(classOrObject, (DeclarationDescriptor)classDescriptor, classDescriptor.getScopeForClassHeaderResolution(), this.trace);
            } else if (object instanceof KtObjectDeclaration) {
                KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)classOrObject;
                Object object3 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(object3, "classDescriptor");
                this.checkObject(ktObjectDeclaration, (ClassDescriptorWithResolutionScopes)object3);
            }
            KtClassOrObject ktClassOrObject2 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject2, "classOrObject");
            ClassDescriptor classDescriptor2 = (ClassDescriptor)classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "classDescriptor");
            this.checkPrimaryConstructor(ktClassOrObject2, classDescriptor2);
            this.checkTypeReferences(classOrObject);
            this.modifiersChecker.checkModifiersForDeclaration(classOrObject, (MemberDescriptor)classDescriptor);
            KtDeclaration ktDeclaration = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "classOrObject");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
            KtClassOrObject ktClassOrObject3 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject3, "classOrObject");
            ClassDescriptor classDescriptor3 = (ClassDescriptor)classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor3, "classDescriptor");
            this.exposedChecker.checkClassHeader(ktClassOrObject3, classDescriptor3);
        }
        for (Map.Entry entry : bodiesResolveContext.getFunctions().entrySet()) {
            classDescriptor = entry;
            KtNamedFunction function = (KtNamedFunction)classDescriptor.getKey();
            object = entry;
            functionDescriptor = (SimpleFunctionDescriptor)object.getValue();
            KtNamedFunction ktNamedFunction = function;
            Intrinsics.checkExpressionValueIsNotNull(ktNamedFunction, "function");
            Object object4 = functionDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(object4, "functionDescriptor");
            this.checkFunction(ktNamedFunction, (SimpleFunctionDescriptor)object4);
            this.checkTypeReferences(function);
            this.modifiersChecker.checkModifiersForDeclaration(function, (MemberDescriptor)functionDescriptor);
            KtDeclaration ktDeclaration = function;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "function");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getProperties().entrySet()) {
            functionDescriptor = entry;
            KtProperty property = (KtProperty)functionDescriptor.getKey();
            object = entry;
            propertyDescriptor = (PropertyDescriptor)object.getValue();
            KtProperty ktProperty = property;
            Intrinsics.checkExpressionValueIsNotNull(ktProperty, "property");
            Object object5 = propertyDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(object5, "propertyDescriptor");
            this.checkProperty(ktProperty, (PropertyDescriptor)object5);
            this.checkTypeReferences(property);
            this.modifiersChecker.checkModifiersForDeclaration(property, (MemberDescriptor)propertyDescriptor);
            KtDeclaration ktDeclaration = property;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "property");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getSecondaryConstructors().entrySet()) {
            ConstructorDescriptor constructorDescriptor;
            propertyDescriptor = entry;
            KtSecondaryConstructor declaration = (KtSecondaryConstructor)propertyDescriptor.getKey();
            object = entry;
            ConstructorDescriptor constructorDescriptor2 = constructorDescriptor = (ConstructorDescriptor)object.getValue();
            Intrinsics.checkExpressionValueIsNotNull(constructorDescriptor2, "constructorDescriptor");
            KtDeclaration ktDeclaration = declaration;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "declaration");
            this.checkConstructorDeclaration(constructorDescriptor2, ktDeclaration);
            KtFunction ktFunction = declaration;
            Intrinsics.checkExpressionValueIsNotNull(ktFunction, "declaration");
            FunctionDescriptor functionDescriptor2 = constructorDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor2, "constructorDescriptor");
            ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, ktFunction, functionDescriptor2, null, 4, null);
        }
    }

    private final void checkConstructorDeclaration(ConstructorDescriptor constructorDescriptor, KtDeclaration declaration) {
        this.checkTypeReferences(declaration);
        this.modifiersChecker.checkModifiersForDeclaration(declaration, constructorDescriptor);
        this.identifierChecker.checkDeclaration(declaration, this.trace);
        this.checkVarargParameters(this.trace, constructorDescriptor);
        this.checkConstructorVisibility(constructorDescriptor, declaration);
    }

    private final void checkConstructorVisibility(ConstructorDescriptor constructorDescriptor, KtDeclaration declaration) {
        PsiElement visibilityModifier = KtPsiUtilKt.visibilityModifier(declaration);
        if (visibilityModifier != null) {
            ASTNode aSTNode = visibilityModifier.getNode();
            if (Intrinsics.areEqual(aSTNode != null ? aSTNode.getElementType() : null, KtTokens.PRIVATE_KEYWORD) ^ true) {
                ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
                if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.ENUM_CLASS)) {
                    this.trace.report(Errors.NON_PRIVATE_CONSTRUCTOR_IN_ENUM.on(visibilityModifier));
                } else if (Intrinsics.areEqual((Object)classDescriptor.getModality(), (Object)Modality.SEALED)) {
                    this.trace.report(Errors.NON_PRIVATE_CONSTRUCTOR_IN_SEALED.on(visibilityModifier));
                }
            }
        }
    }

    private final void checkModifiersAndAnnotationsInPackageDirective(KtFile file) {
        KtPackageDirective ktPackageDirective = file.getPackageDirective();
        if (ktPackageDirective == null) {
            return;
        }
        KtPackageDirective packageDirective = ktPackageDirective;
        KtModifierList ktModifierList = packageDirective.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList = ktModifierList;
        for (KtAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            KtSimpleNameExpression ktSimpleNameExpression;
            KtConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
            if (calleeExpression == null) continue;
            if (calleeExpression.getConstructorReferenceExpression() == null) continue;
            KtSimpleNameExpression it = ktSimpleNameExpression;
            this.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)it), it));
        }
        KtAnnotated ktAnnotated = packageDirective;
        Intrinsics.checkExpressionValueIsNotNull(ktAnnotated, "packageDirective");
        this.annotationChecker.check(ktAnnotated, this.trace, null);
        KtModifierListOwner ktModifierListOwner = packageDirective;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierListOwner, "packageDirective");
        ModifierCheckerCore.INSTANCE.check(ktModifierListOwner, this.trace, null);
    }

    private final void checkTypesInClassHeader(KtClassOrObject classOrObject) {
        KotlinType type2;
        KtTypeReference typeReference;
        Function1<KtTypeReference, KotlinType> type$ = new Function1<KtTypeReference, KotlinType>(this){
            final /* synthetic */ DeclarationsChecker this$0;

            @Nullable
            public final KotlinType invoke(@NotNull KtTypeReference $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                return (KotlinType)DeclarationsChecker.access$getTrace$p(this.this$0).getBindingContext().get(BindingContext.TYPE, $receiver);
            }
            {
                this.this$0 = declarationsChecker;
                super(1);
            }
        };
        for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
            KtTypeReference typeReference2;
            if (delegationSpecifier.getTypeReference() == null) {
                continue;
            }
            if (type$.invoke(typeReference2) != null) {
                KotlinType kotlinType;
                KotlinType it = kotlinType;
                DescriptorResolver.checkBounds(typeReference2, it, this.trace);
            }
            DeclarationsCheckerKt.checkNotEnumEntry(typeReference2, this.trace);
        }
        if (!(classOrObject instanceof KtClass)) {
            return;
        }
        ArrayList<DescriptorResolver.UpperBoundCheckRequest> upperBoundCheckRequests = new ArrayList<DescriptorResolver.UpperBoundCheckRequest>();
        for (KtTypeParameter typeParameter : ((KtClass)classOrObject).getTypeParameters()) {
            if (typeParameter.getExtendsBound() == null) {
                continue;
            }
            if (type$.invoke(typeReference) == null) {
                continue;
            }
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest(typeParameter.getNameAsName(), typeReference, type2));
        }
        for (KtTypeConstraint constraint : ((KtClass)classOrObject).getTypeConstraints()) {
            if (constraint.getBoundTypeReference() == null) {
                continue;
            }
            if (type$.invoke(typeReference) == null) {
                continue;
            }
            Object object = constraint.getSubjectTypeParameterName();
            if (object == null || (object = object.getReferencedNameAsName()) == null) {
                continue;
            }
            Object name = object;
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest((Name)name, typeReference, type2));
        }
        DescriptorResolver.checkUpperBoundTypes(this.trace, (List<DescriptorResolver.UpperBoundCheckRequest>)upperBoundCheckRequests);
        for (DescriptorResolver.UpperBoundCheckRequest request : upperBoundCheckRequests) {
            DescriptorResolver.checkBounds(request.upperBound, request.upperBoundType, this.trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(TypeParameterDescriptor descriptor2, KtTypeParameter declaration, KtTypeParameterListOwner owner) {
        block13: {
            KtElement ktElement;
            void otherBounds;
            void boundsWhichAreTypeParameters;
            Object pair;
            Object element$iv2;
            Iterator iterator2;
            Object object;
            Collection collection;
            block12: {
                void destination$iv$iv;
                void $receiver$iv$iv;
                Object $receiver$iv;
                List<KotlinType> upperBounds = descriptor2.getUpperBounds();
                Iterable iterable = upperBounds;
                void var6_6 = $receiver$iv;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void type2;
                    KotlinType kotlinType = (KotlinType)item$iv$iv;
                    collection = destination$iv$iv;
                    object = type2.getConstructor();
                    collection.add(object);
                }
                $receiver$iv = (List)destination$iv$iv;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv2 = iterator2.next();
                    TypeConstructor constructor = (TypeConstructor)element$iv2;
                    if (constructor.getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                        first$iv.add(element$iv2);
                        continue;
                    }
                    second$iv.add(element$iv2);
                }
                $receiver$iv = new Pair(first$iv, second$iv);
                pair = (Pair)$receiver$iv;
                Object object2 = TuplesKt.to(CollectionsKt.toSet((Iterable)((Pair)pair).getFirst()), CollectionsKt.toSet((Iterable)((Pair)pair).getSecond()));
                Set set = ((Pair)object2).component1();
                Set set2 = ((Pair)object2).component2();
                object2 = null;
                if (boundsWhichAreTypeParameters.size() > 1) break block12;
                if (boundsWhichAreTypeParameters.size() != 1) break block13;
                object2 = (Collection)otherBounds;
                if (!(!object2.isEmpty())) break block13;
            }
            if (boundsWhichAreTypeParameters.size() + otherBounds.size() == 2) {
                Pair problematicBound;
                Object object3;
                Object v2;
                block11: {
                    void $receiver$iv;
                    Object element$iv$iv$iv;
                    Iterator $receiver$iv$iv$iv;
                    Collection destination$iv$iv;
                    Object element$iv$iv2;
                    Iterable $receiver$iv$iv;
                    Iterable $receiver$iv2;
                    pair = owner.getTypeConstraints();
                    void $i$a$3$let = $receiver$iv2;
                    iterator2 = new ArrayList();
                    for (Object element$iv$iv2 : $receiver$iv$iv) {
                        KtTypeConstraint constraint = (KtTypeConstraint)element$iv$iv2;
                        KtSimpleNameExpression ktSimpleNameExpression = constraint.getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null, declaration.getNameAsName())) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    $receiver$iv2 = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv2;
                    destination$iv$iv = new ArrayList();
                    element$iv2 = $receiver$iv$iv;
                    element$iv$iv2 = $receiver$iv$iv$iv.iterator();
                    while (element$iv$iv2.hasNext()) {
                        KtTypeReference ktTypeReference;
                        element$iv$iv$iv = element$iv$iv2.next();
                        Object element$iv$iv3 = element$iv$iv$iv;
                        KtTypeConstraint constraint = (KtTypeConstraint)element$iv$iv3;
                        if (constraint.getBoundTypeReference() == null) continue;
                        KtTypeReference it$iv$iv = ktTypeReference;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $receiver$iv2 = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv2;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void typeReference;
                        element$iv$iv$iv = (KtTypeReference)item$iv$iv;
                        collection = destination$iv$iv;
                        object = TuplesKt.to(typeReference, this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                        collection.add(object);
                    }
                    List allBounds = (List)destination$iv$iv;
                    $receiver$iv$iv = allBounds;
                    for (Object element$iv2 : $receiver$iv) {
                        Pair bound = (Pair)element$iv2;
                        KotlinType kotlinType = (KotlinType)bound.getSecond();
                        if (!(Intrinsics.areEqual(kotlinType != null ? kotlinType.getConstructor() : null, (TypeConstructor)CollectionsKt.first((Iterable)boundsWhichAreTypeParameters)) ^ true)) continue;
                        v2 = element$iv2;
                        break block11;
                    }
                    v2 = null;
                }
                ktElement = (object3 = (problematicBound = (Pair)v2)) != null && (object3 = (KtTypeReference)((Pair)object3).getFirst()) != null ? (KtElement)object3 : (KtElement)declaration;
            } else {
                ktElement = declaration;
            }
            KtElement reportOn = ktElement;
            this.trace.report(Errors.BOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER.on((KtElement)((PsiElement)reportOn)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSupertypesForConsistency(ClassifierDescriptor classifier2, PsiElement sourceElement) {
        Object object;
        Iterable it;
        Map<TypeParameterDescriptor, Collection<TypeProjection>> map2;
        Map<TypeParameterDescriptor, Collection<TypeProjection>> destination$iv$iv;
        if (classifier2 instanceof TypeParameterDescriptor) {
            void $receiver$iv$iv;
            Iterable entry = ((TypeParameterDescriptor)classifier2).getUpperBounds();
            Iterable iterable = entry;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault(entry, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                map2 = destination$iv$iv;
                object = it.getConstructor();
                map2.add(object);
            }
            List immediateUpperBounds = (List)((Object)destination$iv$iv);
            if (immediateUpperBounds.size() != CollectionsKt.toSet(immediateUpperBounds).size()) {
                return;
            }
        }
        Multimap<TypeParameterDescriptor, TypeProjection> multiMap = SubstitutionUtils.buildDeepSubstitutionMultimap(classifier2.getDefaultType());
        destination$iv$iv = multiMap.asMap();
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            ClassDescriptor containingDeclaration;
            void destination$iv$iv2;
            void $receiver$iv$iv;
            void $receiver$iv;
            Object item$iv$iv;
            Map.Entry entry2 = entry;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)entry2.getKey();
            item$iv$iv = entry;
            Collection projections = (Collection)item$iv$iv.getValue();
            if (projections.size() <= 1) continue;
            it = projections;
            void $i$a$1$map = $receiver$iv;
            Collection $i$f$mapTo = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                void it2;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv2;
                map2 = destination$iv$iv2;
                object = it2.getType();
                map2.add(object);
            }
            Set conflictingTypes = CollectionsKt.toMutableSet((List)destination$iv$iv2);
            DeclarationsChecker.Companion.removeDuplicateTypes(conflictingTypes);
            if (conflictingTypes.size() <= 1) continue;
            DeclarationDescriptor declarationDescriptor = typeParameterDescriptor.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            if ((ClassDescriptor)declarationDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Not a class descriptor: " + typeParameterDescriptor.getContainingDeclaration())));
            }
            if (sourceElement instanceof KtClassOrObject) {
                KtSuperTypeList delegationSpecifierList;
                if (((KtClassOrObject)sourceElement).getSuperTypeList() == null) {
                    continue;
                }
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on((KtSuperTypeList)((PsiElement)delegationSpecifierList), typeParameterDescriptor, containingDeclaration, conflictingTypes));
                continue;
            }
            if (!(sourceElement instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_BOUNDS.on((KtTypeParameter)sourceElement, typeParameterDescriptor, containingDeclaration, conflictingTypes));
        }
    }

    private final void checkObject(KtObjectDeclaration declaration, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        if (declaration.isLocal() && !declaration.isCompanion() && !declaration.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on((KtObjectDeclaration)((PsiElement)declaration), classDescriptor));
        }
    }

    private final void checkClassButNotObject(KtClass aClass2, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        this.checkTypeParameters(aClass2);
        this.checkTypeParameterConstraints(aClass2);
        FiniteBoundRestrictionChecker.check(aClass2, classDescriptor, this.trace);
        NonExpansiveInheritanceRestrictionChecker.check(aClass2, classDescriptor, this.trace);
        if (aClass2.isInterface()) {
            this.checkConstructorInInterface(aClass2);
            this.checkMethodsOfAnyInInterface(classDescriptor);
            if (aClass2.isLocal() && !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor)) {
                this.trace.report(Errors.LOCAL_INTERFACE_NOT_ALLOWED.on((KtClass)((PsiElement)aClass2), classDescriptor));
            }
        } else if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.ANNOTATION_CLASS)) {
            this.checkAnnotationClassWithBody(aClass2);
            this.checkValOnAnnotationParameter(aClass2);
        } else if (aClass2 instanceof KtEnumEntry) {
            this.checkEnumEntry((KtEnumEntry)aClass2, classDescriptor);
        }
    }

    private final void checkPrimaryConstructor(KtClassOrObject classOrObject, ClassDescriptor classDescriptor) {
        ConstructorDescriptor constructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorDescriptor primaryConstructor2 = constructorDescriptor;
        KtPrimaryConstructor ktPrimaryConstructor = classOrObject.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor declaration = ktPrimaryConstructor;
        for (KtParameter parameter : declaration.getValueParameters()) {
            PropertyDescriptor propertyDescriptor;
            if ((PropertyDescriptor)this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter) == null) continue;
            PropertyDescriptor it = propertyDescriptor;
            this.modifiersChecker.checkModifiersForDeclaration(parameter, it);
            KtCallableDeclaration ktCallableDeclaration = parameter;
            Intrinsics.checkExpressionValueIsNotNull(ktCallableDeclaration, "parameter");
            PropertyDescriptor propertyDescriptor2 = it;
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor2, "it");
            this.checkPropertyLateInit(ktCallableDeclaration, propertyDescriptor2);
        }
        if (!declaration.hasConstructorKeyword()) {
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList != null) {
                KtModifierList ktModifierList2 = ktModifierList;
                KtModifierList it = ktModifierList2;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on((KtElement)((PsiElement)it)));
            }
        }
        if (!(classOrObject instanceof KtClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)declaration)));
        }
        ConstructorDescriptor constructorDescriptor2 = primaryConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(constructorDescriptor2, "primaryConstructor");
        this.checkConstructorDeclaration(constructorDescriptor2, declaration);
    }

    private final void checkTypeParameters(KtTypeParameterListOwner typeParameterListOwner) {
        for (KtTypeParameter jetTypeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor typeParameterDescriptor;
            AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(jetTypeParameter, this.trace);
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, jetTypeParameter) == null) continue;
            TypeParameterDescriptor it = typeParameterDescriptor;
            DescriptorResolver.checkConflictingUpperBounds(this.trace, it, jetTypeParameter);
        }
    }

    private final void checkTypeParameterConstraints(KtTypeParameterListOwner typeParameterListOwner) {
        List<KtTypeConstraint> constraints = typeParameterListOwner.getTypeConstraints();
        if (constraints.isEmpty()) {
            return;
        }
        for (KtTypeParameter typeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor typeParameterDescriptor;
            if (typeParameter.getExtendsBound() != null) {
                KtTypeParameter ktTypeParameter = typeParameter;
                Intrinsics.checkExpressionValueIsNotNull(ktTypeParameter, "typeParameter");
                List<KtTypeConstraint> list2 = constraints;
                Intrinsics.checkExpressionValueIsNotNull(list2, "constraints");
                if (DeclarationsChecker.Companion.hasConstraints(ktTypeParameter, list2)) {
                    this.trace.report(Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS.on((KtTypeParameter)((PsiElement)typeParameter)));
                }
            }
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, typeParameter) == null) {
                continue;
            }
            ClassifierDescriptor classifierDescriptor = typeParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "typeParameterDescriptor");
            PsiElement psiElement = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull(psiElement, "typeParameter");
            this.checkSupertypesForConsistency(classifierDescriptor, psiElement);
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor2, "typeParameterDescriptor");
            KtTypeParameter ktTypeParameter = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull(ktTypeParameter, "typeParameter");
            this.checkOnlyOneTypeParameterBound(typeParameterDescriptor2, ktTypeParameter, typeParameterListOwner);
        }
    }

    private final void checkConstructorInInterface(KtClass klass) {
        block0: {
            KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
            if (ktPrimaryConstructor == null) break block0;
            KtPrimaryConstructor ktPrimaryConstructor2 = ktPrimaryConstructor;
            KtPrimaryConstructor it = ktPrimaryConstructor2;
            this.trace.report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)it)));
        }
    }

    private final void checkMethodsOfAnyInInterface(ClassDescriptorWithResolutionScopes classDescriptor) {
        for (CallableMemberDescriptor declaredCallableMember : classDescriptor.getDeclaredCallableMembers()) {
            PsiElement declaration;
            if (!(declaredCallableMember instanceof FunctionDescriptor) || !((declaration = DescriptorToSourceUtils.descriptorToDeclaration(declaredCallableMember)) instanceof KtNamedFunction) || DeclarationsChecker.Companion.isHidingParentMemberIfPresent(declaredCallableMember) || !DeclarationsChecker.Companion.isImplementingMethodOfAny(declaredCallableMember)) continue;
            this.trace.report(Errors.METHOD_OF_ANY_IMPLEMENTED_IN_INTERFACE.on((KtDeclaration)declaration));
        }
    }

    private final void checkAnnotationClassWithBody(KtClassOrObject classOrObject) {
        block0: {
            KtClassBody ktClassBody = classOrObject.getBody();
            if (ktClassBody == null) break block0;
            KtClassBody ktClassBody2 = ktClassBody;
            KtClassBody it = ktClassBody2;
            this.trace.report(Errors.ANNOTATION_CLASS_WITH_BODY.on(it));
        }
    }

    private final void checkValOnAnnotationParameter(KtClass aClass2) {
        for (KtParameter parameter : aClass2.getPrimaryConstructorParameters()) {
            if (!parameter.hasValOrVar()) {
                this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                continue;
            }
            if (!parameter.isMutable()) continue;
            this.trace.report(Errors.VAR_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
        }
    }

    private final void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor)) {
            return;
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            KtNamedDeclaration member;
            if (Intrinsics.areEqual((Object)memberDescriptor.getKind(), (Object)CallableMemberDescriptor.Kind.DECLARATION) ^ true) continue;
            DeclarationDescriptor declarationDescriptor = memberDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "memberDescriptor");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            if (!(psiElement instanceof KtNamedDeclaration)) {
                psiElement = null;
            }
            if ((member = (KtNamedDeclaration)psiElement) == null || !member.hasModifier(KtTokens.OPEN_KEYWORD)) continue;
            if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.OBJECT)) {
                this.trace.report(Errors.NON_FINAL_MEMBER_IN_OBJECT.on((KtNamedDeclaration)((PsiElement)member)));
                continue;
            }
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on((KtNamedDeclaration)((PsiElement)member)));
        }
    }

    private final void checkProperty(KtProperty property, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "containingDeclaration");
            this.checkMemberProperty(property, propertyDescriptor, classDescriptor);
        }
        this.checkPropertyLateInit(property, propertyDescriptor);
        this.checkPropertyInitializer(property, propertyDescriptor);
        this.checkAccessors(property, propertyDescriptor);
        this.checkTypeParameterConstraints(property);
        ExposedVisibilityChecker.checkProperty$default(this.exposedChecker, property, propertyDescriptor, null, 4, null);
        this.checkPropertyTypeParametersAreUsedInReceiverType(propertyDescriptor);
        this.checkImplicitCallableType(property, propertyDescriptor);
    }

    private final void checkPropertyTypeParametersAreUsedInReceiverType(PropertyDescriptor descriptor2) {
        Set allTypeParameters = CollectionsKt.toSet((Iterable)descriptor2.getTypeParameters());
        HashSet allAccessibleTypeParameters = new HashSet();
        Function1<KotlinType, Unit> addAccessibleTypeParametersFromType$ = new Function1<KotlinType, Unit>(allTypeParameters, allAccessibleTypeParameters){
            final /* synthetic */ Set $allTypeParameters;
            final /* synthetic */ HashSet $allAccessibleTypeParameters;

            public final void invoke(@Nullable KotlinType type2) {
                TypeUtils.contains(type2, new Function1<KotlinType, Boolean>(this){
                    final /* synthetic */ checkPropertyTypeParametersAreUsedInReceiverType.1 this$0;

                    public final boolean invoke(KotlinType it) {
                        ClassifierDescriptor declarationDescriptor = it.getConstructor().getDeclarationDescriptor();
                        if (declarationDescriptor instanceof TypeParameterDescriptor && this.this$0.$allTypeParameters.contains(declarationDescriptor) && this.this$0.$allAccessibleTypeParameters.add(declarationDescriptor)) {
                            Iterable $receiver$iv = ((TypeParameterDescriptor)declarationDescriptor).getUpperBounds();
                            for (T element$iv : $receiver$iv) {
                                KotlinType it2 = (KotlinType)element$iv;
                                this.this$0.invoke(it2);
                            }
                        }
                        return false;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.$allTypeParameters = set;
                this.$allAccessibleTypeParameters = hashSet;
                super(1);
            }
        };
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        addAccessibleTypeParametersFromType$.invoke(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null);
        Set<TypeParameterDescriptor> typeParametersInaccessibleFromReceiver = SetsKt.minus(allTypeParameters, allAccessibleTypeParameters);
        for (TypeParameterDescriptor typeParameter : typeParametersInaccessibleFromReceiver) {
            DeclarationDescriptor declarationDescriptor = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "typeParameter");
            PsiElement typeParameterPsi = DescriptorToSourceUtils.getSourceFromDescriptor(declarationDescriptor);
            if (!(typeParameterPsi instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.TYPE_PARAMETER_OF_PROPERTY_NOT_USED_IN_RECEIVER.on((KtTypeParameter)typeParameterPsi));
        }
    }

    private final void checkPropertyLateInit(KtCallableDeclaration property, PropertyDescriptor propertyDescriptor) {
        Boolean hasBackingField;
        Boolean bl;
        boolean isAbstract;
        KtModifierList ktModifierList = property.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList = ktModifierList;
        PsiElement psiElement = modifierList.getModifier(KtTokens.LATEINIT_KEYWORD);
        if (psiElement == null) {
            return;
        }
        PsiElement modifier = psiElement;
        if (!propertyDescriptor.isVar()) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is allowed only on mutable properties"));
        }
        boolean returnTypeIsNullable = true;
        boolean returnTypeIsPrimitive = true;
        KotlinType returnType2 = propertyDescriptor.getReturnType();
        if (returnType2 != null) {
            returnTypeIsNullable = TypeUtils.isNullableType(returnType2);
            returnTypeIsPrimitive = KotlinBuiltIns.isPrimitiveType(returnType2);
        }
        if (returnTypeIsNullable) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on nullable properties"));
        }
        if (returnTypeIsPrimitive) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primitive type properties"));
        }
        if (isAbstract = Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on abstract properties"));
        }
        if (property instanceof KtParameter) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primary constructor parameters"));
        }
        boolean hasDelegateExpressionOrInitializer = false;
        if (property instanceof KtProperty && ((KtProperty)property).hasDelegateExpressionOrInitializer()) {
            hasDelegateExpressionOrInitializer = true;
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with initializer or on delegated properties"));
        }
        boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAccessorImplementation(propertyDescriptor);
        if (!hasDelegateExpressionOrInitializer && hasAccessorImplementation) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with a custom getter or setter"));
        }
        if ((bl = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor)) == null) {
            bl = hasBackingField = Boolean.valueOf(false);
        }
        if (!(isAbstract || hasAccessorImplementation || hasDelegateExpressionOrInitializer || hasBackingField.booleanValue())) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties without backing field"));
        }
        if (propertyDescriptor.getExtensionReceiverParameter() != null) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on extension properties"));
        }
    }

    private final void checkMemberProperty(KtProperty property, PropertyDescriptor propertyDescriptor, ClassDescriptor classDescriptor) {
        KtModifierList modifierList = property.getModifierList();
        if (modifierList != null) {
            if (modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                if (!DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                    PsiElement psiElement = property;
                    String string = property.getName();
                    if (string == null) {
                        string = "";
                    }
                    this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on((KtModifierListOwner)psiElement, string, classDescriptor));
                    return;
                }
            } else if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.INTERFACE) && modifierList.hasModifier(KtTokens.OPEN_KEYWORD) && Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
                this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)property)));
            }
        }
        if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            KtPropertyAccessor setter;
            KtPropertyAccessor getter;
            KtElement it;
            KtElement ktElement;
            KtExpression ktExpression = property.getInitializer();
            if (ktExpression != null) {
                ktElement = ktExpression;
                it = ktElement;
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on((KtExpression)it));
            }
            KtPropertyDelegate ktPropertyDelegate = property.getDelegate();
            if (ktPropertyDelegate != null) {
                ktElement = ktPropertyDelegate;
                it = (KtPropertyDelegate)ktElement;
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on((KtPropertyDelegate)it));
            }
            if ((getter = property.getGetter()) != null && getter.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter)));
            }
            if ((setter = property.getSetter()) != null && setter.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter)));
            }
        }
    }

    private final void checkPropertyInitializer(KtProperty property, PropertyDescriptor propertyDescriptor) {
        Boolean backingFieldRequired;
        boolean inTrait;
        boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAccessorImplementation(propertyDescriptor);
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean bl = inTrait = containingDeclaration instanceof ClassDescriptor && Intrinsics.areEqual((Object)((ClassDescriptor)containingDeclaration).getKind(), (Object)ClassKind.INTERFACE);
        if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
            }
            if (inTrait && property.hasModifier(KtTokens.PRIVATE_KEYWORD) && !property.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                this.trace.report(Errors.PRIVATE_PROPERTY_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
            }
            return;
        }
        Boolean bl2 = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        if (bl2 == null) {
            bl2 = backingFieldRequired = Boolean.valueOf(false);
        }
        if (inTrait && backingFieldRequired.booleanValue() && hasAccessorImplementation) {
            this.trace.report(Errors.BACKING_FIELD_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
        }
        KtExpression initializer2 = property.getInitializer();
        KtPropertyDelegate delegate2 = property.getDelegate();
        if (initializer2 != null) {
            if (inTrait) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_IN_INTERFACE.on((KtExpression)((PsiElement)initializer2)));
            } else if (!backingFieldRequired.booleanValue()) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on((KtExpression)((PsiElement)initializer2)));
            } else if (property.getReceiverTypeReference() != null) {
                this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer2)));
            }
        } else if (delegate2 != null) {
            if (inTrait) {
                this.trace.report(Errors.DELEGATED_PROPERTY_IN_INTERFACE.on((KtPropertyDelegate)((PsiElement)delegate2)));
            }
        } else {
            Boolean isUninitialized;
            Boolean bl3 = (Boolean)this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor);
            if (bl3 == null) {
                bl3 = isUninitialized = Boolean.valueOf(false);
            }
            if (backingFieldRequired.booleanValue() && !inTrait && !propertyDescriptor.isLateInit() && isUninitialized.booleanValue()) {
                if (!(containingDeclaration instanceof ClassDescriptor) || hasAccessorImplementation) {
                    this.trace.report(Errors.MUST_BE_INITIALIZED.on((KtProperty)((PsiElement)property)));
                } else {
                    this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property)));
                }
            } else if (property.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
            }
            if (backingFieldRequired.booleanValue() && !inTrait && propertyDescriptor.isLateInit() && !isUninitialized.booleanValue()) {
                Boolean bl4 = (Boolean)this.trace.get(BindingContext.MUST_BE_LATEINIT, propertyDescriptor);
                if (!(bl4 != null ? bl4 : false)) {
                    this.trace.report(Errors.UNNECESSARY_LATEINIT.on((KtProperty)((PsiElement)property)));
                }
            }
        }
    }

    public final void checkFunction(@NotNull KtNamedFunction function, @NotNull SimpleFunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        KtTypeParameterList typeParameterList = function.getTypeParameterList();
        PsiElement nameIdentifier = function.getNameIdentifier();
        if (typeParameterList != null && nameIdentifier != null && typeParameterList.getTextRange().getStartOffset() > nameIdentifier.getTextRange().getStartOffset()) {
            this.trace.report(Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX.on((KtTypeParameterList)((PsiElement)typeParameterList)));
        }
        this.checkTypeParameterConstraints(function);
        this.checkImplicitCallableType(function, functionDescriptor);
        ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, function, functionDescriptor, null, 4, null);
        this.checkVarargParameters(this.trace, functionDescriptor);
        DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
        boolean hasAbstractModifier = function.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasExternalModifier = function.hasModifier(KtTokens.EXTERNAL_KEYWORD);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inInterface = Intrinsics.areEqual((Object)((ClassDescriptor)containingDescriptor).getKind(), (Object)ClassKind.INTERFACE);
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractMembers((ClassDescriptor)containingDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on((KtFunction)((PsiElement)function), functionDescriptor.getName().asString(), (ClassDescriptor)containingDescriptor));
            }
            if ((hasBody = function.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
            }
            if (!hasBody && inInterface) {
                if (function.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                    this.trace.report(Errors.PRIVATE_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
                }
                if (!hasAbstractModifier && function.hasModifier(KtTokens.OPEN_KEYWORD)) {
                    this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)function)));
                }
            }
            if (!(hasBody || hasAbstractModifier || hasExternalModifier || inInterface)) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
            }
        } else if (!(function.hasBody() || hasAbstractModifier || hasExternalModifier)) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
        }
    }

    private final void checkImplicitCallableType(KtCallableDeclaration declaration, CallableDescriptor descriptor2) {
        block4: {
            KotlinType kotlinType = descriptor2.getReturnType();
            if (kotlinType == null) break block4;
            KotlinType kotlinType2 = kotlinType;
            KotlinType it = kotlinType2;
            if (declaration.getTypeReference() == null) {
                PsiElement target;
                PsiElement psiElement = declaration.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = target = (PsiElement)declaration;
                }
                if (TypeUtilsKt.isNothing(it) && !declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                    this.trace.report((declaration instanceof KtProperty ? Errors.IMPLICIT_NOTHING_PROPERTY_TYPE : Errors.IMPLICIT_NOTHING_RETURN_TYPE).on(target));
                }
                if (TypeUtilsKt.contains(it, checkImplicitCallableType.1.1.INSTANCE)) {
                    this.trace.report(Errors.IMPLICIT_INTERSECTION_TYPE.on(target, it));
                }
            }
        }
    }

    private final void checkAccessors(KtProperty property, PropertyDescriptor propertyDescriptor) {
        for (PropertyAccessorDescriptor accessorDescriptor : propertyDescriptor.getAccessors()) {
            KtPropertyAccessor accessor;
            KtPropertyAccessor ktPropertyAccessor = accessor = accessorDescriptor instanceof PropertyGetterDescriptor ? property.getGetter() : property.getSetter();
            if (accessor != null) {
                this.checkTypeReferences(accessor);
                this.modifiersChecker.checkModifiersForDeclaration(accessor, accessorDescriptor);
                this.identifierChecker.checkDeclaration(accessor, this.trace);
                continue;
            }
            this.modifiersChecker.runDeclarationCheckers(property, accessorDescriptor);
        }
        this.checkAccessor(propertyDescriptor, property.getGetter(), propertyDescriptor.getGetter());
        this.checkAccessor(propertyDescriptor, property.getSetter(), propertyDescriptor.getSetter());
    }

    private final void reportVisibilityModifierDiagnostics(Collection<? extends PsiElement> tokens, DiagnosticFactory0<PsiElement> diagnostic) {
        for (PsiElement psiElement : tokens) {
            this.trace.report(diagnostic.on(psiElement));
        }
    }

    private final void checkAccessor(PropertyDescriptor propertyDescriptor, KtPropertyAccessor accessor, PropertyAccessorDescriptor accessorDescriptor) {
        if (accessor == null || accessorDescriptor == null) {
            return;
        }
        KtModifierList ktModifierList = accessor.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList accessorModifierList = ktModifierList;
        Map<KtModifierKeywordToken, PsiElement> tokens = this.modifiersChecker.getTokensCorrespondingToModifiers(accessorModifierList, (Collection<KtModifierKeywordToken>)Sets.newHashSet(KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD));
        if (accessor.isGetter()) {
            if (Intrinsics.areEqual(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility()) ^ true) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.GETTER_VISIBILITY\u2026_FROM_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.REDUNDANT_MODIFIER_IN_GETTER;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.REDUNDANT_MODIFIER_IN_GETTER");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else if (ModalityKt.isOverridable(propertyDescriptor) && Intrinsics.areEqual(accessorDescriptor.getVisibility(), Visibilities.PRIVATE) && Intrinsics.areEqual(propertyDescriptor.getVisibility(), Visibilities.PRIVATE) ^ true) {
            if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else {
            Integer compare = Visibilities.compare(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility());
            if (compare == null || Intrinsics.compare(compare, 0) > 0) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.SETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.SETTER_VISIBILITY\u2026_WITH_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        }
    }

    private final void checkEnumEntry(KtEnumEntry enumEntry, ClassDescriptor classDescriptor) {
        DeclarationDescriptor declaration = classDescriptor.getContainingDeclaration();
        if (DescriptorUtils.isEnumClass(declaration)) {
            if (!enumEntry.hasInitializer()) {
                DeclarationDescriptor declarationDescriptor = declaration;
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                if (!DeclarationsChecker.Companion.hasDefaultConstructor((ClassDescriptor)declarationDescriptor)) {
                    this.trace.report(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED.on((KtClass)((PsiElement)enumEntry)));
                }
            }
        } else {
            boolean bl = DescriptorUtils.isInterface(declaration);
            if (_Assertions.ENABLED && !bl) {
                String string = "Enum entry should be declared in enum class: " + classDescriptor;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    private final void checkVarargParameters(BindingTrace trace, CallableDescriptor callableDescriptor) {
        Iterable $receiver$iv = callableDescriptor.getValueParameters();
        int count$iv = 0;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            if (!(it.getVarargElementType() != null)) continue;
            ++count$iv;
        }
        int numberOfVarargParameters = count$iv;
        if (numberOfVarargParameters > 1) {
            for (ValueParameterDescriptor parameter : callableDescriptor.getValueParameters()) {
                if (parameter.getVarargElementType() == null) continue;
                DeclarationDescriptor declarationDescriptor = parameter;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "parameter");
                PsiElement parameterDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                if (!(parameterDeclaration instanceof KtParameter)) continue;
                trace.report(Errors.MULTIPLE_VARARG_PARAMETERS.on((KtParameter)parameterDeclaration));
            }
        }
    }

    public DeclarationsChecker(@NotNull DescriptorResolver descriptorResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull AnnotationChecker annotationChecker, @NotNull IdentifierChecker identifierChecker, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(descriptorResolver, "descriptorResolver");
        Intrinsics.checkParameterIsNotNull(modifiersChecker, "modifiersChecker");
        Intrinsics.checkParameterIsNotNull(annotationChecker, "annotationChecker");
        Intrinsics.checkParameterIsNotNull(identifierChecker, "identifierChecker");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.descriptorResolver = descriptorResolver;
        this.annotationChecker = annotationChecker;
        this.identifierChecker = identifierChecker;
        this.trace = trace;
        this.modifiersChecker = modifiersChecker.withTrace(this.trace);
        this.exposedChecker = new ExposedVisibilityChecker(this.trace);
    }

    static {
        Companion = new Companion(null);
        METHOD_OF_ANY_NAMES = ImmutableSet.of("toString", "hashCode", "equals");
    }

    @NotNull
    public static final /* synthetic */ BindingTrace access$getTrace$p(DeclarationsChecker $this) {
        return $this.trace;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019H\u0002J\f\u0010\u001e\u001a\u00020\n*\u00020\u001fH\u0002R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion;", "", "()V", "METHOD_OF_ANY_NAMES", "Lorg/jetbrains/kotlin/com/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "getMETHOD_OF_ANY_NAMES", "()Lcom/google/common/collect/ImmutableSet;", "hasConstraints", "", "typeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "constraints", "", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "hasDefaultConstructor", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isHidingParentMemberIfPresent", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isImplementingMethodOfAny", "isImplementingMethodOfAnyInternal", "visitedClasses", "", "removeDuplicateTypes", "", "conflictingTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "hasAccessorImplementation", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "kotlin-compiler"})
    public static final class Companion {
        private final void removeDuplicateTypes(Set<KotlinType> conflictingTypes) {
            Iterator<KotlinType> iterator2 = conflictingTypes.iterator();
            block0: while (iterator2.hasNext()) {
                KotlinType type2 = iterator2.next();
                for (KotlinType otherType : conflictingTypes) {
                    boolean subtypeOf = KotlinTypeChecker.DEFAULT.equalTypes(type2, otherType);
                    if (type2 == otherType || !subtypeOf) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        private final boolean hasConstraints(KtTypeParameter typeParameter, List<? extends KtTypeConstraint> constraints) {
            boolean bl;
            block2: {
                if (typeParameter.getName() == null) {
                    return false;
                }
                Iterable $receiver$iv = constraints;
                for (Object element$iv : $receiver$iv) {
                    KtTypeConstraint it = (KtTypeConstraint)element$iv;
                    KtSimpleNameExpression ktSimpleNameExpression = it.getSubjectTypeParameterName();
                    if (!Intrinsics.areEqual(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null, typeParameter.getName())) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }

        private final ImmutableSet<String> getMETHOD_OF_ANY_NAMES() {
            return METHOD_OF_ANY_NAMES;
        }

        private final boolean isImplementingMethodOfAny(CallableMemberDescriptor member) {
            if (!this.getMETHOD_OF_ANY_NAMES().contains(member.getName().asString())) {
                return false;
            }
            if (Intrinsics.areEqual((Object)member.getModality(), (Object)Modality.ABSTRACT)) {
                return false;
            }
            return this.isImplementingMethodOfAnyInternal(member, new HashSet());
        }

        private final boolean isImplementingMethodOfAnyInternal(CallableMemberDescriptor member, Set<ClassDescriptor> visitedClasses) {
            for (CallableMemberDescriptor callableMemberDescriptor : member.getOverriddenDescriptors()) {
                DeclarationDescriptor containingDeclaration = callableMemberDescriptor.getContainingDeclaration();
                if (!(containingDeclaration instanceof ClassDescriptor) || visitedClasses.contains(containingDeclaration)) continue;
                if (Intrinsics.areEqual(DescriptorUtils.getFqName(containingDeclaration), KotlinBuiltIns.FQ_NAMES.any)) {
                    return true;
                }
                CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor2, "overridden");
                if (this.isHidingParentMemberIfPresent(callableMemberDescriptor2)) continue;
                DeclarationDescriptor declarationDescriptor = containingDeclaration;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "containingDeclaration");
                visitedClasses.add((ClassDescriptor)declarationDescriptor);
                CallableMemberDescriptor callableMemberDescriptor3 = callableMemberDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor3, "overridden");
                if (!this.isImplementingMethodOfAnyInternal(callableMemberDescriptor3, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private final boolean isHidingParentMemberIfPresent(CallableMemberDescriptor member) {
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(member);
            if (!(psiElement instanceof KtNamedDeclaration)) {
                psiElement = null;
            }
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiElement;
            if (ktNamedDeclaration == null) {
                return false;
            }
            KtNamedDeclaration declaration = ktNamedDeclaration;
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList == null) {
                return true;
            }
            KtModifierList modifierList = ktModifierList;
            return !modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        }

        private final boolean hasDefaultConstructor(ClassDescriptor classDescriptor) {
            boolean bl;
            block1: {
                Iterable $receiver$iv = classDescriptor.getConstructors();
                for (Object element$iv : $receiver$iv) {
                    ConstructorDescriptor it = (ConstructorDescriptor)element$iv;
                    if (!it.getValueParameters().isEmpty()) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final boolean hasAccessorImplementation(@NotNull PropertyDescriptor $receiver) {
            PropertyAccessorDescriptor it;
            PropertyAccessorDescriptor propertyAccessorDescriptor;
            PropertyGetterDescriptor propertyGetterDescriptor = $receiver.getGetter();
            if (propertyGetterDescriptor != null) {
                propertyAccessorDescriptor = propertyGetterDescriptor;
                it = propertyAccessorDescriptor;
                if (DescriptorPsiUtilsKt.hasBody(it)) {
                    return true;
                }
            }
            PropertySetterDescriptor propertySetterDescriptor = $receiver.getSetter();
            if (propertySetterDescriptor != null) {
                propertyAccessorDescriptor = propertySetterDescriptor;
                it = (PropertySetterDescriptor)propertyAccessorDescriptor;
                if (DescriptorPsiUtilsKt.hasBody(it)) {
                    return true;
                }
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

