/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.ConstructorHeaderCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ConstructorHeaderCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "kotlin-compiler"})
public final class ConstructorHeaderCallChecker
implements CallChecker {
    public static final ConstructorHeaderCallChecker INSTANCE;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean bl;
        void $receiver$iv;
        ClassDescriptor labelReferenceClass;
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ClassDescriptor dispatchReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver$p(resolvedCall2.getDispatchReceiver());
        ClassDescriptor extensionReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver$p(resolvedCall2.getExtensionReceiver());
        KtElement callElement = resolvedCall2.getCall().getCallElement();
        if (callElement instanceof KtInstanceExpressionWithLabel) {
            Object v = context.getTrace().get(BindingContext.REFERENCE_TARGET, ((KtInstanceExpressionWithLabel)callElement).getInstanceReference());
            if (!(v instanceof ClassDescriptor)) {
                v = null;
            }
            classDescriptor = (ClassDescriptor)v;
        } else {
            classDescriptor = labelReferenceClass = (ClassDescriptor)null;
        }
        if (dispatchReceiverClass == null && extensionReceiverClass == null && labelReferenceClass == null) {
            return;
        }
        Set<ClassDescriptor[]> classes2 = SetsKt.setOf(new ClassDescriptor[]{dispatchReceiverClass, extensionReceiverClass, labelReferenceClass});
        Sequence<HierarchicalScope> sequence2 = ScopeUtilsKt.getParentsWithSelf(context.getScope());
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return;
            Object element$iv = iterator2.next();
            HierarchicalScope scope = (HierarchicalScope)element$iv;
            if (scope instanceof LexicalScope && Intrinsics.areEqual((Object)((LexicalScope)scope).getKind(), (Object)LexicalScopeKind.CONSTRUCTOR_HEADER)) {
                DeclarationDescriptor declarationDescriptor = ((LexicalScope)scope).getOwnerDescriptor();
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ConstructorDescriptor");
                }
                if (classes2.contains(((ConstructorDescriptor)declarationDescriptor).getContainingDeclaration())) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        boolean bl2 = true;
        if (!bl2) return;
        context.getTrace().report(Errors.INSTANCE_ACCESS_BEFORE_SUPER_CALL.on(reportOn, (DeclarationDescriptor)resolvedCall2.getResultingDescriptor()));
    }

    private ConstructorHeaderCallChecker() {
        INSTANCE = this;
    }

    static {
        new ConstructorHeaderCallChecker();
    }
}

