/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.Deprecation;
import org.jetbrains.kotlin.resolve.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0006\u001a\u00020\u00072\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0018R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/DeprecatedCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "PROPERTY_SET_OPERATIONS", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "shouldCheckPropertyGetter", "", "expression", "shouldCheckPropertyGetter$kotlin_compiler", "kotlin-compiler"})
public final class DeprecatedCallChecker
implements CallChecker {
    private static final TokenSet PROPERTY_SET_OPERATIONS;
    public static final DeprecatedCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, "resolvedCall.resultingDescriptor");
        this.check((CallableDescriptor)obj, context.getTrace(), reportOn, context.getLanguageVersionSettings());
    }

    private final void check(CallableDescriptor targetDescriptor, BindingTrace trace, PsiElement element, LanguageVersionSettings languageVersionSettings) {
        block5: {
            Object object;
            block4: {
                if (targetDescriptor instanceof FakeCallableDescriptorForObject) {
                    return;
                }
                List<Deprecation> deprecations = CollectionsKt.toMutableList((Collection)DeprecationUtilKt.getDeprecations(targetDescriptor, languageVersionSettings));
                if (targetDescriptor instanceof PropertySetterDescriptor) {
                    object = deprecations;
                    Iterable iterable = DeprecationUtilKt.getDeprecations(((PropertySetterDescriptor)targetDescriptor).getCorrespondingProperty(), languageVersionSettings);
                    CollectionsKt.removeAll(object, iterable);
                }
                object = deprecations;
                if (!(!object.isEmpty())) break block4;
                for (Deprecation deprecation : deprecations) {
                    trace.report(DeprecationUtilKt.createDeprecationDiagnostic(element, deprecation, languageVersionSettings));
                }
                break block5;
            }
            if (!(targetDescriptor instanceof PropertyDescriptor) || !this.shouldCheckPropertyGetter$kotlin_compiler(element)) break block5;
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)targetDescriptor).getGetter();
            if (propertyGetterDescriptor != null) {
                object = propertyGetterDescriptor;
                PropertyGetterDescriptor it = (PropertyGetterDescriptor)object;
                CallableDescriptor callableDescriptor = it;
                Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "it");
                INSTANCE.check(callableDescriptor, trace, element, languageVersionSettings);
            }
        }
    }

    public final boolean shouldCheckPropertyGetter$kotlin_compiler(@NotNull PsiElement expression) {
        KtUnaryExpression unaryExpression;
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtBinaryExpression binaryExpression = PsiTreeUtil.getParentOfType(expression, KtBinaryExpression.class);
        if (binaryExpression != null) {
            KtExpression left = binaryExpression.getLeft();
            if (Intrinsics.areEqual(left, expression) && PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) {
                return false;
            }
            KtReferenceExpression[] referenceExpressions = (KtReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)left, KtReferenceExpression.class);
            if (referenceExpressions != null) {
                for (int i = 0; i < referenceExpressions.length; ++i) {
                    KtReferenceExpression expr = referenceExpressions[i];
                    if (!Intrinsics.areEqual(expr, expression) || !PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) continue;
                    return false;
                }
            }
        }
        if (PROPERTY_SET_OPERATIONS.contains((ktExpression = (unaryExpression = PsiTreeUtil.getParentOfType(expression, KtUnaryExpression.class))) != null && (ktExpression = ((KtUnaryExpression)ktExpression).getOperationReference()) != null ? ktExpression.getReferencedNameElementType() : null)) {
            return false;
        }
        KtCallableReferenceExpression callableExpression = PsiTreeUtil.getParentOfType(expression, KtCallableReferenceExpression.class);
        return callableExpression == null || !Intrinsics.areEqual(callableExpression.getCallableReference(), expression);
    }

    private DeprecatedCallChecker() {
        INSTANCE = this;
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.addSpread(KtTokens.ALL_ASSIGNMENTS.getTypes());
        spreadBuilder.add(KtTokens.PLUSPLUS);
        spreadBuilder.add(KtTokens.MINUSMINUS);
        PROPERTY_SET_OPERATIONS = TokenSet.create((IElementType[])spreadBuilder.toArray(new IElementType[spreadBuilder.size()]));
    }

    static {
        new DeprecatedCallChecker();
    }
}

