/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.file.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.injected.editor.DocumentWindow;
import org.jetbrains.kotlin.com.intellij.injected.editor.VirtualFileWindow;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageUtil;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileTypeFileViewProviders;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProviderFactory;
import org.jetbrains.kotlin.com.intellij.psi.LanguageFileViewProviders;
import org.jetbrains.kotlin.com.intellij.psi.LanguageSubstitutors;
import org.jetbrains.kotlin.com.intellij.psi.PsiBinaryFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiLargeFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiModificationTrackerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiDirectoryFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.FileManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.kotlin.gnu.trove.THashMap;

public class FileManagerImpl
implements FileManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.file.impl.FileManagerImpl");
    private final Key<FileViewProvider> myPsiHardRefKey = Key.create("HARD_REFERENCE_TO_PSI");
    private final PsiManagerImpl myManager;
    private final FileIndexFacade myFileIndex;
    private final ConcurrentMap<VirtualFile, PsiDirectory> myVFileToPsiDirMap = ContainerUtil.createConcurrentSoftValueMap();
    private final ConcurrentMap<VirtualFile, FileViewProvider> myVFileToViewProviderMap = ContainerUtil.createConcurrentWeakValueMap();
    private boolean myInitialized;
    private boolean myDisposed;
    private final FileDocumentManager myFileDocumentManager;
    private final MessageBusConnection myConnection;
    private static final VirtualFile NULL = new LightVirtualFile();
    private boolean myProcessingFileTypesChange;

    public FileManagerImpl(PsiManagerImpl manager, FileDocumentManager fileDocumentManager, FileIndexFacade fileIndex) {
        this.myManager = manager;
        this.myFileIndex = fileIndex;
        this.myConnection = manager.getProject().getMessageBus().connect();
        this.myFileDocumentManager = fileDocumentManager;
        Disposer.register(manager.getProject(), this);
        LowMemoryWatcher.register(() -> this.processQueue(), this);
    }

    public void processQueue() {
        this.myVFileToViewProviderMap.remove(NULL);
    }

    @NotNull
    public ConcurrentMap<VirtualFile, FileViewProvider> getVFileToViewProviderMap() {
        ConcurrentMap<VirtualFile, FileViewProvider> concurrentMap = this.myVFileToViewProviderMap;
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "getVFileToViewProviderMap"));
        }
        return concurrentMap;
    }

    private void updateAllViewProviders() {
        this.handleFileTypesChange(new FileTypesChanged(){

            @Override
            protected void updateMaps() {
                for (FileViewProvider provider : FileManagerImpl.this.myVFileToViewProviderMap.values()) {
                    if (!provider.getVirtualFile().isValid()) continue;
                    FileManagerImpl.clearPsiCaches(provider);
                }
                FileManagerImpl.this.removeInvalidFilesAndDirs(false);
                FileManagerImpl.this.checkLanguageChange();
            }
        });
    }

    public static void clearPsiCaches(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "clearPsiCaches"));
        }
        if (provider instanceof SingleRootFileViewProvider) {
            for (PsiFile root : ((SingleRootFileViewProvider)provider).getCachedPsiFiles()) {
                if (!(root instanceof PsiFileImpl)) continue;
                ((PsiFileImpl)root).clearCaches();
            }
        } else {
            for (Language language : provider.getLanguages()) {
                PsiFile psi = provider.getPsi(language);
                if (!(psi instanceof PsiFileImpl)) continue;
                ((PsiFileImpl)psi).clearCaches();
            }
        }
    }

    private void checkLanguageChange() {
        THashMap<VirtualFile, FileViewProvider> fileToPsiFileMap = new THashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        THashMap<VirtualFile, FileViewProvider> originalFileToPsiFileMap = new THashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        this.myVFileToViewProviderMap.clear();
        Iterator iterator2 = fileToPsiFileMap.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator2.next();
            Language language = LanguageUtil.getLanguageForPsi(this.myManager.getProject(), vFile);
            if (language == null || language == ((FileViewProvider)fileToPsiFileMap.get(vFile)).getBaseLanguage()) continue;
            iterator2.remove();
        }
        this.myVFileToViewProviderMap.putAll(fileToPsiFileMap);
        this.markInvalidations(originalFileToPsiFileMap);
    }

    public void forceReload(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "forceReload"));
        }
        LanguageSubstitutors.cancelReparsing(vFile);
        FileViewProvider viewProvider = this.findCachedViewProvider(vFile);
        if (viewProvider == null) {
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.setViewProvider(vFile, null);
        VirtualFile dir = vFile.getParent();
        PsiDirectory parentDir = dir == null ? null : this.getCachedDirectory(dir);
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        if (parentDir != null) {
            event.setParent(parentDir);
            this.myManager.childrenChanged(event);
        } else {
            this.firePropertyChangedForUnloadedPsi(event, vFile);
        }
    }

    void firePropertyChangedForUnloadedPsi(@NotNull PsiTreeChangeEventImpl event, @NotNull VirtualFile vFile) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "firePropertyChangedForUnloadedPsi"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "firePropertyChangedForUnloadedPsi"));
        }
        event.setPropertyName("propUnloadedPsi");
        event.setOldValue(vFile);
        event.setNewValue(vFile);
        this.myManager.beforePropertyChange(event);
        this.myManager.propertyChanged(event);
    }

    @Override
    public void dispose() {
        if (this.myInitialized) {
            this.myConnection.disconnect();
        }
        this.clearViewProviders();
        this.myDisposed = true;
    }

    private void clearViewProviders() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DebugUtil.startPsiModification("clearViewProviders");
        try {
            for (FileViewProvider provider : this.myVFileToViewProviderMap.values()) {
                this.markInvalidated(provider);
            }
            this.myVFileToViewProviderMap.clear();
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    @Override
    public void cleanupForNextTest() {
        ApplicationManager.getApplication().runWriteAction(() -> this.clearViewProviders());
        this.myVFileToPsiDirMap.clear();
        ((PsiModificationTrackerImpl)this.myManager.getModificationTracker()).incCounter();
    }

    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "findViewProvider"));
        }
        assert (!file2.isDirectory());
        FileViewProvider viewProvider = this.findCachedViewProvider(file2);
        if (viewProvider != null) {
            FileViewProvider fileViewProvider = viewProvider;
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "findViewProvider"));
            }
            return fileViewProvider;
        }
        viewProvider = this.createFileViewProvider(file2, true);
        if (file2 instanceof LightVirtualFile) {
            FileViewProvider fileViewProvider = file2.putUserDataIfAbsent(this.myPsiHardRefKey, viewProvider);
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "findViewProvider"));
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = ConcurrencyUtil.cacheOrGet(this.myVFileToViewProviderMap, file2, viewProvider);
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "findViewProvider"));
        }
        return fileViewProvider;
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "findCachedViewProvider"));
        }
        FileViewProvider viewProvider = this.getFromInjected(file2);
        if (viewProvider == null) {
            viewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get(file2);
        }
        if (viewProvider == null) {
            viewProvider = file2.getUserData(this.myPsiHardRefKey);
        }
        return viewProvider;
    }

    @Nullable
    private FileViewProvider getFromInjected(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "getFromInjected"));
        }
        if (file2 instanceof VirtualFileWindow) {
            DocumentWindow document = ((VirtualFileWindow)((Object)file2)).getDocumentWindow();
            PsiFile psiFile = PsiDocumentManager.getInstance(this.myManager.getProject()).getCachedPsiFile(document);
            if (psiFile == null) {
                return null;
            }
            return psiFile.getViewProvider();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, @Nullable FileViewProvider fileViewProvider) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "setViewProvider"));
        }
        FileViewProvider prev = this.findCachedViewProvider(virtualFile);
        if (prev == fileViewProvider) {
            return;
        }
        if (prev != null) {
            DebugUtil.startPsiModification(null);
            try {
                this.markInvalidated(prev);
                DebugUtil.onInvalidated(prev);
            }
            finally {
                DebugUtil.finishPsiModification();
            }
        }
        if (!(virtualFile instanceof VirtualFileWindow)) {
            if (fileViewProvider == null) {
                this.myVFileToViewProviderMap.remove(virtualFile);
            } else if (virtualFile instanceof LightVirtualFile) {
                virtualFile.putUserData(this.myPsiHardRefKey, fileViewProvider);
            } else {
                this.myVFileToViewProviderMap.put(virtualFile, fileViewProvider);
            }
        }
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, boolean eventSystemEnabled) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "createFileViewProvider"));
        }
        FileType fileType = file2.getFileType();
        Language language = LanguageUtil.getLanguageForPsi(this.myManager.getProject(), file2);
        FileViewProviderFactory factory2 = language == null ? (FileViewProviderFactory)FileTypeFileViewProviders.INSTANCE.forFileType(fileType) : (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        SingleRootFileViewProvider viewProvider = factory2 == null ? null : factory2.createFileViewProvider(file2, language, this.myManager, eventSystemEnabled);
        SingleRootFileViewProvider singleRootFileViewProvider = viewProvider == null ? new SingleRootFileViewProvider((PsiManager)this.myManager, file2, eventSystemEnabled, fileType) : viewProvider;
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "createFileViewProvider"));
        }
        return singleRootFileViewProvider;
    }

    public void markInitialized() {
        LOG.assertTrue(!this.myInitialized);
        this.myDisposed = false;
        this.myInitialized = true;
        this.myConnection.subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FileManagerImpl.this.updateAllViewProviders();
            }

            public void exitDumbMode() {
                FileManagerImpl.this.updateAllViewProviders();
            }
        });
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    private void handleFileTypesChange(@NotNull FileTypesChanged runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "handleFileTypesChange"));
        }
        if (this.myProcessingFileTypesChange) {
            return;
        }
        this.myProcessingFileTypesChange = true;
        try {
            ApplicationManager.getApplication().runWriteAction(runnable);
        }
        finally {
            this.myProcessingFileTypesChange = false;
        }
    }

    void dispatchPendingEvents() {
        if (!this.myInitialized) {
            LOG.error("Project is not yet initialized: " + this.myManager.getProject());
        }
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        this.myConnection.deliverImmediately();
    }

    public void checkConsistency() {
        HashMap<VirtualFile, FileViewProvider> fileToViewProvider = new HashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        this.myVFileToViewProviderMap.clear();
        for (VirtualFile vFile : fileToViewProvider.keySet()) {
            FileViewProvider fileViewProvider = (FileViewProvider)fileToViewProvider.get(vFile);
            LOG.assertTrue(vFile.isValid());
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null || fileViewProvider == null || !fileViewProvider.isPhysical()) continue;
            PsiFile psi = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
            assert (psi != null) : fileViewProvider + "; " + fileViewProvider.getBaseLanguage() + "; " + psiFile1;
            assert (psiFile1.getClass().equals(psi.getClass())) : psiFile1 + "; " + psi + "; " + psiFile1.getClass() + "; " + psi.getClass();
        }
        HashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new HashMap<VirtualFile, PsiDirectory>(this.myVFileToPsiDirMap);
        this.myVFileToPsiDirMap.clear();
        for (VirtualFile vFile : fileToPsiDirMap.keySet()) {
            LOG.assertTrue(vFile.isValid());
            PsiDirectory psiDir1 = this.findDirectory(vFile);
            LOG.assertTrue(psiDir1 != null);
            VirtualFile parent2 = vFile.getParent();
            if (parent2 == null) continue;
            LOG.assertTrue(this.myVFileToPsiDirMap.containsKey(parent2));
        }
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "findFile"));
        }
        if (vFile.isDirectory()) {
            return null;
        }
        Project project = this.myManager.getProject();
        if (project.isDefault()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("Invalid file: " + vFile);
            return null;
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "getCachedPsiFile"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LOG.assertTrue(vFile.isValid(), "Invalid file");
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        if (!this.myInitialized) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.getCachedPsiFileInner(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "findDirectory"));
        }
        LOG.assertTrue(this.myInitialized, "Access to psi files should be performed only after startup activity");
        if (this.myDisposed) {
            LOG.error("Access to psi files should not be performed after project disposal: " + this.myManager.getProject());
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("File is not valid:" + vFile);
            return null;
        }
        if (!vFile.isDirectory()) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.findDirectoryImpl(vFile);
    }

    @Nullable
    private PsiDirectory findDirectoryImpl(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "findDirectoryImpl"));
        }
        PsiDirectory psiDir = (PsiDirectory)this.myVFileToPsiDirMap.get(vFile);
        if (psiDir != null) {
            return psiDir;
        }
        if (Registry.is("ide.hide.excluded.files") ? this.myFileIndex.isExcludedFile(vFile) : this.myFileIndex.isUnderIgnored(vFile)) {
            return null;
        }
        VirtualFile parent2 = vFile.getParent();
        if (parent2 != null) {
            this.findDirectoryImpl(parent2);
        }
        psiDir = PsiDirectoryFactory.getInstance(this.myManager.getProject()).createDirectory(vFile);
        return ConcurrencyUtil.cacheOrGet(this.myVFileToPsiDirMap, vFile, psiDir);
    }

    public PsiDirectory getCachedDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "getCachedDirectory"));
        }
        return (PsiDirectory)this.myVFileToPsiDirMap.get(vFile);
    }

    private void markInvalidated(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "markInvalidated"));
        }
        if (viewProvider instanceof SingleRootFileViewProvider) {
            ((SingleRootFileViewProvider)viewProvider).markInvalidated();
        }
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
        if (document != null) {
            ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myManager.getProject())).associatePsi(document, null);
        }
        virtualFile.putUserData(this.myPsiHardRefKey, null);
    }

    @Nullable
    PsiFile getCachedPsiFileInner(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "getCachedPsiFileInner"));
        }
        FileViewProvider fileViewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get(file2);
        if (fileViewProvider == null) {
            fileViewProvider = file2.getUserData(this.myPsiHardRefKey);
        }
        return fileViewProvider instanceof SingleRootFileViewProvider ? ((SingleRootFileViewProvider)fileViewProvider).getCachedPsi(fileViewProvider.getBaseLanguage()) : null;
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        ArrayList<PsiFile> files2 = new ArrayList<PsiFile>();
        for (FileViewProvider provider : this.myVFileToViewProviderMap.values()) {
            if (!(provider instanceof SingleRootFileViewProvider)) continue;
            ContainerUtil.addIfNotNull(files2, ((SingleRootFileViewProvider)provider).getCachedPsi(provider.getBaseLanguage()));
        }
        ArrayList<PsiFile> arrayList = files2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "getAllCachedFiles"));
        }
        return arrayList;
    }

    void removeInvalidFilesAndDirs(boolean useFind) {
        THashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new THashMap<VirtualFile, PsiDirectory>(this.myVFileToPsiDirMap);
        if (useFind) {
            this.myVFileToPsiDirMap.clear();
        }
        Iterator iterator2 = fileToPsiDirMap.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator2.next();
            if (!vFile.isValid()) {
                iterator2.remove();
                continue;
            }
            PsiDirectory psiDir = this.findDirectory(vFile);
            if (psiDir != null) continue;
            iterator2.remove();
        }
        this.myVFileToPsiDirMap.clear();
        this.myVFileToPsiDirMap.putAll(fileToPsiDirMap);
        THashMap<VirtualFile, FileViewProvider> fileToPsiFileMap = new THashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        THashMap<VirtualFile, FileViewProvider> originalFileToPsiFileMap = new THashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        if (useFind) {
            this.myVFileToViewProviderMap.clear();
        }
        Iterator iterator3 = fileToPsiFileMap.keySet().iterator();
        while (iterator3.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator3.next();
            if (!vFile.isValid()) {
                iterator3.remove();
                continue;
            }
            if (!useFind) continue;
            FileViewProvider view = (FileViewProvider)fileToPsiFileMap.get(vFile);
            if (view == null) {
                iterator3.remove();
                continue;
            }
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null) {
                iterator3.remove();
                continue;
            }
            if (!FileManagerImpl.areViewProvidersEquivalent(view, psiFile1.getViewProvider())) {
                iterator3.remove();
                continue;
            }
            FileManagerImpl.clearPsiCaches(view);
        }
        this.myVFileToViewProviderMap.clear();
        this.myVFileToViewProviderMap.putAll(fileToPsiFileMap);
        this.markInvalidations(originalFileToPsiFileMap);
    }

    static boolean areViewProvidersEquivalent(@NotNull FileViewProvider view1, @NotNull FileViewProvider view2) {
        if (view1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view1", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "areViewProvidersEquivalent"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view2", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "areViewProvidersEquivalent"));
        }
        if (view1.getClass() != view2.getClass() || view1.getFileType() != view2.getFileType()) {
            return false;
        }
        Language baseLanguage = view1.getBaseLanguage();
        if (baseLanguage != view2.getBaseLanguage()) {
            return false;
        }
        if (!view1.getLanguages().equals(view2.getLanguages())) {
            return false;
        }
        PsiFile psi1 = view1.getPsi(baseLanguage);
        PsiFile psi2 = view2.getPsi(baseLanguage);
        if (psi1 == null) {
            return psi2 == null;
        }
        return psi1.getClass() == psi2.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markInvalidations(@NotNull Map<VirtualFile, FileViewProvider> originalFileToPsiFileMap) {
        if (originalFileToPsiFileMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFileToPsiFileMap", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "markInvalidations"));
        }
        DebugUtil.startPsiModification(null);
        try {
            for (Map.Entry<VirtualFile, FileViewProvider> entry : originalFileToPsiFileMap.entrySet()) {
                FileViewProvider viewProvider = entry.getValue();
                if (this.myVFileToViewProviderMap.get(entry.getKey()) == viewProvider) continue;
                this.markInvalidated(viewProvider);
            }
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "reloadFromDisk"));
        }
        this.reloadFromDisk(file2, false);
    }

    void reloadFromDisk(@NotNull PsiFile file2, boolean ignoreDocument) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl", "reloadFromDisk"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile vFile = file2.getVirtualFile();
        assert (vFile != null);
        if (file2 instanceof PsiBinaryFile) {
            return;
        }
        FileDocumentManager fileDocumentManager = this.myFileDocumentManager;
        Document document = fileDocumentManager.getCachedDocument(vFile);
        if (document != null && !ignoreDocument) {
            fileDocumentManager.reloadFromDisk(document);
        } else {
            FileViewProvider latestProvider = this.createFileViewProvider(vFile, false);
            PsiFile psi = latestProvider.getPsi(latestProvider.getBaseLanguage());
            if (psi instanceof PsiLargeFile || psi instanceof PsiBinaryFile) {
                this.forceReload(vFile);
                return;
            }
            FileViewProvider viewProvider = file2.getViewProvider();
            if (viewProvider instanceof SingleRootFileViewProvider) {
                ((SingleRootFileViewProvider)viewProvider).onContentReload();
            } else {
                LOG.error("Invalid view provider: " + viewProvider + " of " + viewProvider.getClass());
            }
        }
    }

    private abstract class FileTypesChanged
    implements Runnable {
        private FileTypesChanged() {
        }

        protected abstract void updateMaps();

        @Override
        public void run() {
            PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
            event.setPropertyName("propFileTypes");
            FileManagerImpl.this.myManager.beforePropertyChange(event);
            this.updateMaps();
            FileManagerImpl.this.myManager.propertyChanged(event);
        }
    }
}

