/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.extapi.psi.StubBasedPsiElementBase;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.StubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTree;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStrongWhitespaceHolderElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public class TreeUtil {
    private static final Key<String> UNCLOSED_ELEMENT_PROPERTY = Key.create("UNCLOSED_ELEMENT_PROPERTY");
    public static final Key<FileElement> CONTAINING_FILE_KEY_AFTER_REPARSE = Key.create("CONTAINING_FILE_KEY_AFTER_REPARSE");

    private TreeUtil() {
    }

    public static void ensureParsed(ASTNode node) {
        if (node != null) {
            node.getFirstChildNode();
        }
    }

    public static void ensureParsedRecursively(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil", "ensureParsedRecursively"));
        }
        ((TreeElement)node).acceptTree(new RecursiveTreeElementWalkingVisitor(){});
    }

    public static void ensureParsedRecursivelyCheckingProgress(@NotNull ASTNode node, final @NotNull ProgressIndicator indicator) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil", "ensureParsedRecursivelyCheckingProgress"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil", "ensureParsedRecursivelyCheckingProgress"));
        }
        ((TreeElement)node).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                indicator.checkCanceled();
            }
        });
    }

    public static boolean isCollapsedChameleon(ASTNode node) {
        return node instanceof LazyParseableElement && !((LazyParseableElement)node).isParsed();
    }

    @Nullable
    public static ASTNode findChildBackward(ASTNode parent2, IElementType type2) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = parent2.getLastChildNode(); element != null; element = element.getTreePrev()) {
            if (element.getElementType() != type2) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public static ASTNode skipElements(ASTNode element, TokenSet types) {
        while (true) {
            if (element == null) {
                return null;
            }
            if (!types.contains(element.getElementType())) break;
            element = element.getTreeNext();
        }
        return element;
    }

    @Nullable
    public static ASTNode skipElementsBack(@Nullable ASTNode element, TokenSet types) {
        if (element == null) {
            return null;
        }
        if (!types.contains(element.getElementType())) {
            return element;
        }
        ASTNode parent2 = element.getTreeParent();
        ASTNode prev = element;
        while (prev instanceof CompositeElement) {
            if (!types.contains(prev.getElementType())) {
                return prev;
            }
            prev = prev.getTreePrev();
        }
        if (prev == null) {
            return null;
        }
        ASTNode lastRelevant = null;
        for (ASTNode firstChildNode = parent2.getFirstChildNode(); firstChildNode != prev; firstChildNode = firstChildNode.getTreeNext()) {
            if (types.contains(firstChildNode.getElementType())) continue;
            lastRelevant = firstChildNode;
        }
        return lastRelevant;
    }

    @Nullable
    public static ASTNode findParent(ASTNode element, IElementType type2) {
        for (ASTNode parent2 = element.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (parent2.getElementType() != type2) continue;
            return parent2;
        }
        return null;
    }

    @Nullable
    public static ASTNode findParent(ASTNode element, TokenSet types) {
        for (ASTNode parent2 = element.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (!types.contains(parent2.getElementType())) continue;
            return parent2;
        }
        return null;
    }

    @Nullable
    public static LeafElement findFirstLeaf(ASTNode element) {
        return (LeafElement)TreeUtil.findFirstLeaf(element, true);
    }

    public static ASTNode findFirstLeaf(ASTNode element, boolean expandChameleons) {
        if (element instanceof LeafElement || !expandChameleons && TreeUtil.isCollapsedChameleon(element)) {
            return element;
        }
        for (ASTNode child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            ASTNode leaf = TreeUtil.findFirstLeaf(child, expandChameleons);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    private static boolean isLeafOrCollapsedChameleon(ASTNode node) {
        return node instanceof LeafElement || TreeUtil.isCollapsedChameleon(node);
    }

    @Nullable
    public static TreeElement findFirstLeafOrChameleon(TreeElement element) {
        if (element == null) {
            return null;
        }
        final Ref<Object> result2 = Ref.create(null);
        element.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                if (TreeUtil.isLeafOrCollapsedChameleon(element)) {
                    result2.set(element);
                    this.stopWalking();
                    return;
                }
                super.visitNode(element);
            }
        });
        return result2.get();
    }

    @Nullable
    public static ASTNode findLastLeaf(ASTNode element) {
        return TreeUtil.findLastLeaf(element, true);
    }

    public static ASTNode findLastLeaf(ASTNode element, boolean expandChameleons) {
        if (element instanceof LeafElement || !expandChameleons && TreeUtil.isCollapsedChameleon(element)) {
            return element;
        }
        for (ASTNode child = element.getLastChildNode(); child != null; child = child.getTreePrev()) {
            ASTNode leaf = TreeUtil.findLastLeaf(child);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start, IElementType elementType) {
        ASTNode child = start;
        while (child != null) {
            if (child.getElementType() == elementType) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start, TokenSet types) {
        ASTNode child = start;
        while (child != null) {
            if (types.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start, IElementType elementType) {
        ASTNode child = start;
        while (child != null) {
            if (child.getElementType() == elementType) {
                return child;
            }
            child = child.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start, TokenSet types) {
        ASTNode child = start;
        while (child != null) {
            if (types.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findCommonParent(ASTNode one, ASTNode two) {
        if (one == two) {
            return one;
        }
        HashSet<ASTNode> parents2 = new HashSet<ASTNode>(20);
        while (one != null) {
            parents2.add(one);
            one = one.getTreeParent();
        }
        while (two != null) {
            if (parents2.contains(two)) {
                return two;
            }
            two = two.getTreeParent();
        }
        return null;
    }

    public static Couple<ASTNode> findTopmostSiblingParents(ASTNode one, ASTNode two) {
        if (one == two) {
            return Couple.of(null, null);
        }
        LinkedList<ASTNode> oneParents = new LinkedList<ASTNode>();
        while (one != null) {
            oneParents.add(one);
            one = one.getTreeParent();
        }
        LinkedList<ASTNode> twoParents = new LinkedList<ASTNode>();
        while (two != null) {
            twoParents.add(two);
            two = two.getTreeParent();
        }
        while ((one = (ASTNode)oneParents.pollLast()) == (two = (ASTNode)twoParents.pollLast()) && one != null) {
        }
        return Couple.of(one, two);
    }

    public static void clearCaches(@NotNull TreeElement tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil", "clearCaches"));
        }
        tree.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                element.clearCaches();
                super.visitNode(element);
            }
        });
    }

    @Nullable
    public static ASTNode nextLeaf(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil", "nextLeaf"));
        }
        return TreeUtil.nextLeaf((TreeElement)node, null);
    }

    public static FileElement getFileElement(TreeElement element) {
        TreeElement parent2;
        for (parent2 = element; parent2 != null && !(parent2 instanceof FileElement); parent2 = parent2.getTreeParent()) {
        }
        if (parent2 == null) {
            parent2 = element.getUserData(CONTAINING_FILE_KEY_AFTER_REPARSE);
        }
        return (FileElement)parent2;
    }

    @Nullable
    public static ASTNode prevLeaf(ASTNode node) {
        return TreeUtil.prevLeaf((TreeElement)node, null);
    }

    public static boolean isStrongWhitespaceHolder(IElementType type2) {
        return type2 instanceof IStrongWhitespaceHolderElementType;
    }

    public static String getTokenText(Lexer lexer) {
        return lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
    }

    @Nullable
    public static LeafElement nextLeaf(@NotNull TreeElement start, CommonParentState commonParent) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil", "nextLeaf"));
        }
        return (LeafElement)TreeUtil.nextLeaf(start, commonParent, null, true);
    }

    @Nullable
    public static TreeElement nextLeaf(@NotNull TreeElement start, CommonParentState commonParent, IElementType searchedType, boolean expandChameleons) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil", "nextLeaf"));
        }
        for (TreeElement element = start; element != null; element = element.getTreeParent()) {
            if (commonParent != null) {
                commonParent.startLeafBranchStart = element;
                TreeUtil.initStrongWhitespaceHolder(commonParent, element, true);
            }
            TreeElement nextTree = element;
            TreeElement next = null;
            while (next == null && (nextTree = nextTree.getTreeNext()) != null) {
                if (nextTree.getElementType() == searchedType) {
                    return nextTree;
                }
                next = TreeUtil.findFirstLeafOrType(nextTree, searchedType, commonParent, expandChameleons);
            }
            if (next == null) continue;
            if (commonParent != null) {
                commonParent.nextLeafBranchStart = nextTree;
            }
            return next;
        }
        return null;
    }

    private static void initStrongWhitespaceHolder(CommonParentState commonParent, ASTNode start, boolean slopeSide) {
        if (start instanceof CompositeElement && (TreeUtil.isStrongWhitespaceHolder(start.getElementType()) || slopeSide && start.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null)) {
            commonParent.strongWhiteSpaceHolder = (CompositeElement)start;
            commonParent.isStrongElementOnRisingSlope = slopeSide;
        }
    }

    @Nullable
    private static TreeElement findFirstLeafOrType(@NotNull TreeElement element, final IElementType searchedType, final CommonParentState commonParent, final boolean expandChameleons) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil", "findFirstLeafOrType"));
        }
        class MyVisitor
        extends RecursiveTreeElementWalkingVisitor {
            private TreeElement result;

            MyVisitor(boolean doTransform2) {
                super(doTransform2);
            }

            @Override
            protected void visitNode(TreeElement node) {
                if (this.result != null) {
                    return;
                }
                if (commonParent != null) {
                    TreeUtil.initStrongWhitespaceHolder(commonParent, node, false);
                }
                if (!expandChameleons && TreeUtil.isCollapsedChameleon(node) || node instanceof LeafElement || node.getElementType() == searchedType) {
                    this.result = node;
                    return;
                }
                super.visitNode(node);
            }
        }
        MyVisitor visitor2 = new MyVisitor(expandChameleons);
        element.acceptTree(visitor2);
        return visitor2.result;
    }

    @Nullable
    public static ASTNode prevLeaf(TreeElement start, @Nullable CommonParentState commonParent) {
        while (start != null) {
            if (commonParent != null) {
                if (commonParent.strongWhiteSpaceHolder != null && start.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null) {
                    commonParent.strongWhiteSpaceHolder = (CompositeElement)start;
                }
                commonParent.nextLeafBranchStart = start;
            }
            ASTNode prevTree = start;
            ASTNode prev = null;
            while (prev == null && (prevTree = prevTree.getTreePrev()) != null) {
                prev = TreeUtil.findLastLeaf(prevTree);
            }
            if (prev != null) {
                if (commonParent != null) {
                    commonParent.startLeafBranchStart = prevTree;
                }
                return prev;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode nextLeaf(@Nullable ASTNode start, boolean expandChameleons) {
        while (start != null) {
            for (ASTNode each = start.getTreeNext(); each != null; each = each.getTreeNext()) {
                ASTNode leaf = TreeUtil.findFirstLeaf(each, expandChameleons);
                if (leaf == null) continue;
                return leaf;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode prevLeaf(@Nullable ASTNode start, boolean expandChameleons) {
        while (start != null) {
            for (ASTNode each = start.getTreePrev(); each != null; each = each.getTreePrev()) {
                ASTNode leaf = TreeUtil.findLastLeaf(each, expandChameleons);
                if (leaf == null) continue;
                return leaf;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode getLastChild(ASTNode element) {
        ASTNode child = element;
        while (child != null) {
            element = child;
            child = element.getLastChildNode();
        }
        return element;
    }

    public static void bindStubsToTree(@NotNull PsiFileImpl file2, @NotNull StubTree stubTree, @NotNull FileElement tree) throws StubBindingException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil", "bindStubsToTree"));
        }
        if (stubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubTree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil", "bindStubsToTree"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil", "bindStubsToTree"));
        }
        final ListIterator stubs = stubTree.getPlainList().listIterator();
        stubs.next();
        IStubFileElementType type2 = file2.getElementTypeForStubBuilder();
        assert (type2 != null);
        final StubBuilder builder = type2.getBuilder();
        tree.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            protected void visitNode(TreeElement node) {
                CompositeElement parent2 = node.getTreeParent();
                if (parent2 != null && builder.skipChildProcessingWhenBuildingStubs(parent2, node)) {
                    return;
                }
                IElementType type2 = node.getElementType();
                if (type2 instanceof IStubElementType && ((IStubElementType)type2).shouldCreateStub(node)) {
                    StubElement stub;
                    StubElement stubElement = stub = stubs.hasNext() ? (StubElement)stubs.next() : null;
                    if (stub == null || stub.getStubType() != type2) {
                        throw new StubBindingException("stub:" + stub + ", AST:" + type2);
                    }
                    StubBasedPsiElementBase psi = (StubBasedPsiElementBase)node.getPsi();
                    ((StubBase)stub).setPsi(psi);
                    psi.setStubIndex(stubs.previousIndex());
                }
                super.visitNode(node);
            }
        });
    }

    @Nullable
    public static ASTNode skipWhitespaceAndComments(ASTNode node, boolean forward) {
        return TreeUtil.skipWhitespaceCommentsAndTokens(node, TokenSet.EMPTY, forward);
    }

    @Nullable
    public static ASTNode skipWhitespaceCommentsAndTokens(ASTNode node, @NotNull TokenSet alsoSkip, boolean forward) {
        if (alsoSkip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alsoSkip", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeUtil", "skipWhitespaceCommentsAndTokens"));
        }
        ASTNode element = node;
        while (true) {
            if (element == null) {
                return null;
            }
            if (!TreeUtil.isWhitespaceOrComment(element) && !alsoSkip.contains(element.getElementType())) break;
            element = forward ? element.getTreeNext() : element.getTreePrev();
        }
        return element;
    }

    public static boolean isWhitespaceOrComment(ASTNode element) {
        return element.getPsi() instanceof PsiWhiteSpace || element.getPsi() instanceof PsiComment;
    }

    public static class StubBindingException
    extends RuntimeException {
        StubBindingException(String message) {
            super(message);
        }
    }

    public static final class CommonParentState {
        TreeElement startLeafBranchStart;
        public ASTNode nextLeafBranchStart;
        CompositeElement strongWhiteSpaceHolder;
        boolean isStrongElementOnRisingSlope = true;
    }
}

