/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.builder.KotlinLightClassBuilderFactory;
import org.jetbrains.kotlin.asJava.builder.LightClassBuilderResult;
import org.jetbrains.kotlin.asJava.builder.LightClassConstructionContext;
import org.jetbrains.kotlin.asJava.builder.StubComputationTracker;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.ClassFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\u001aj\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2<\u0010\u000e\u001a8\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00140\u000f\u001a&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a$\u0010\u001b\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u001aH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"LOG", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "buildLightClass", "Lorg/jetbrains/kotlin/asJava/builder/LightClassBuilderResult;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "generateClassFilter", "Lorg/jetbrains/kotlin/codegen/state/GenerationState$GenerateClassFilter;", "context", "Lorg/jetbrains/kotlin/asJava/builder/LightClassConstructionContext;", "generate", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "Lkotlin/ParameterName;", "name", "state", "", "createJavaFileStub", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "getRepresentativeVirtualFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "logErrorWithOSInfo", "cause", "", "fqName", "virtualFile", "kotlin-compiler"})
public final class LightClassBuilderKt {
    private static final Logger LOG = Logger.getInstance(LightClassBuilderResult.class);

    @NotNull
    public static final LightClassBuilderResult buildLightClass(@NotNull FqName packageFqName, @NotNull Collection<? extends KtFile> files2, @NotNull GenerationState.GenerateClassFilter generateClassFilter, @NotNull LightClassConstructionContext context, @NotNull Function2<? super GenerationState, ? super Collection<? extends KtFile>, Unit> generate2) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(files2, "files");
        Intrinsics.checkParameterIsNotNull(generateClassFilter, "generateClassFilter");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(generate2, "generate");
        Project project = ((KtFile)CollectionsKt.first((Iterable)files2)).getProject();
        try {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull(project2, "project");
            KotlinLightClassBuilderFactory classBuilderFactory = new KotlinLightClassBuilderFactory(LightClassBuilderKt.createJavaFileStub(project2, packageFqName, files2));
            Project project3 = project;
            Intrinsics.checkExpressionValueIsNotNull(project3, "project");
            ClassBuilderFactory classBuilderFactory2 = classBuilderFactory;
            ModuleDescriptor moduleDescriptor = context.getModule();
            BindingContext bindingContext = context.getBindingContext();
            List list2 = CollectionsKt.toList((Iterable)files2);
            CompilerConfiguration compilerConfiguration = CompilerConfiguration.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration, "CompilerConfiguration.EMPTY");
            GenerationState state2 = new GenerationState(project3, classBuilderFactory2, moduleDescriptor, bindingContext, list2, compilerConfiguration, generateClassFilter, null, null, null, null, null, false, 3968, null);
            state2.beforeCompile();
            generate2.invoke(state2, files2);
            PsiJavaFileStub javaFileStub = classBuilderFactory.result();
            StubComputationTracker stubComputationTracker = ServiceManager.getService(project, StubComputationTracker.class);
            if (stubComputationTracker != null) {
                stubComputationTracker.onStubComputed(javaFileStub, context);
            }
            return new LightClassBuilderResult(javaFileStub, context.getBindingContext(), state2.getCollectedExtraJvmDiagnostics());
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (RuntimeException e) {
            LightClassBuilderKt.logErrorWithOSInfo(e, packageFqName, null);
            throw (Throwable)e;
        }
    }

    private static final PsiJavaFileStub createJavaFileStub(Project project, FqName packageFqName, Collection<? extends KtFile> files2) {
        PsiJavaFileStubImpl javaFileStub = new PsiJavaFileStubImpl(packageFqName.asString(), true);
        javaFileStub.setPsiFactory(ClsWrapperStubPsiFactory.INSTANCE);
        PsiManager manager = PsiManager.getInstance(project);
        VirtualFile virtualFile = LightClassBuilderKt.getRepresentativeVirtualFile(files2);
        ClsFileImpl fakeFile2 = new ClsFileImpl(javaFileStub, packageFqName, manager, virtualFile, new ClassFileViewProvider(manager, virtualFile)){
            final /* synthetic */ PsiJavaFileStubImpl $javaFileStub;
            final /* synthetic */ FqName $packageFqName;
            final /* synthetic */ PsiManager $manager;
            final /* synthetic */ VirtualFile $virtualFile;

            @NotNull
            public PsiJavaFileStubImpl getStub() {
                return this.$javaFileStub;
            }

            @NotNull
            public String getPackageName() {
                return this.$packageFqName.asString();
            }

            public boolean isPhysical() {
                return false;
            }
            {
                this.$javaFileStub = $captured_local_variable$0;
                this.$packageFqName = $captured_local_variable$1;
                this.$manager = $captured_local_variable$2;
                this.$virtualFile = $captured_local_variable$3;
                super($super_call_param$4);
            }
        };
        javaFileStub.setPsi((PsiFile)fakeFile2);
        return javaFileStub;
    }

    private static final VirtualFile getRepresentativeVirtualFile(Collection<? extends KtFile> files2) {
        VirtualFile virtualFile = ((KtFile)CollectionsKt.first((Iterable)files2)).getViewProvider().getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull(virtualFile, "files.first().viewProvider.virtualFile");
        return virtualFile;
    }

    private static final void logErrorWithOSInfo(Throwable cause, FqName fqName2, VirtualFile virtualFile) {
        String string;
        if (virtualFile == null) {
            string = "<null>";
        } else {
            String string2 = virtualFile.getPath();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "virtualFile.path");
        }
        String path = string;
        LOG.error("Could not generate LightClass for " + fqName2 + " declared in " + path + "\n" + ("System: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " Java Runtime: " + SystemInfo.JAVA_RUNTIME_VERSION), cause);
    }
}

