/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.collections.CharIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/UnderscoreUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallElement", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "checkSimpleNameUsage", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "ktName", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "isUnderscoreOnlyName", "", "", "kotlin-compiler"})
public final class UnderscoreUsageChecker
implements CallChecker {
    public static final UnderscoreUsageChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        DeclarationDescriptor namedDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            return;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        DeclarationDescriptor declarationDescriptor = namedDescriptor = descriptor2 instanceof ConstructorDescriptor ? (DeclarationDescriptor)((ConstructorDescriptor)descriptor2).getContainingDeclaration() : (DeclarationDescriptor)descriptor2;
        if (!this.isUnderscoreOnlyName(namedDescriptor.getName().asString())) {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkExpressionValueIsNotNull(ktElement, "resolvedCall.call.callElement");
        this.checkCallElement(ktElement, context);
    }

    private final void checkCallElement(KtElement ktElement, CallCheckerContext context) {
        block2: {
            KtElement ktElement2;
            block1: {
                ktElement2 = ktElement;
                if (!(ktElement2 instanceof KtSimpleNameExpression)) break block1;
                this.checkSimpleNameUsage((KtSimpleNameExpression)ktElement, context.getTrace());
                break block2;
            }
            if (!(ktElement2 instanceof KtCallExpression)) break block2;
            KtExpression ktExpression = ((KtCallExpression)ktElement).getCalleeExpression();
            if (ktExpression != null) {
                KtExpression ktExpression2;
                KtExpression it;
                KtExpression ktExpression3 = it = (ktExpression2 = ktExpression);
                Intrinsics.checkExpressionValueIsNotNull(ktExpression3, "it");
                INSTANCE.checkCallElement(ktExpression3, context);
            }
        }
    }

    private final void checkSimpleNameUsage(KtSimpleNameExpression ktName, BindingTrace trace) {
        if (this.isUnderscoreOnlyName(ktName.getText())) {
            trace.report(Errors.UNDERSCORE_USAGE_WITHOUT_BACKTICKS.on(ktName));
        }
    }

    public final void checkSimpleNameUsage(@NotNull DeclarationDescriptor descriptor2, @NotNull KtSimpleNameExpression ktName, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(ktName, "ktName");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (this.isUnderscoreOnlyName(descriptor2.getName().asString())) {
            this.checkSimpleNameUsage(ktName, trace);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUnderscoreOnlyName(@NotNull String $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        CharSequence charSequence = $receiver;
        if (charSequence.length() <= 0) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        CharSequence $receiver$iv = $receiver;
        CharIterator charIterator = StringsKt.iterator($receiver$iv);
        do {
            if (!charIterator.hasNext()) return true;
            char element$iv = charIterator.nextChar();
            char it = element$iv;
            if (it != '_') return false;
            bl = true;
        } while (bl);
        return false;
    }

    private UnderscoreUsageChecker() {
        INSTANCE = this;
    }

    static {
        new UnderscoreUsageChecker();
    }
}

