/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.Usage;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentUtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.org.fusesource.jansi.AnsiConsole;
import org.jetbrains.kotlin.utils.StringsKt;

public abstract class CLICompiler<A extends CommonCompilerArguments> {
    @NotNull
    public ExitCode exec(@NotNull PrintStream errStream, String ... args) {
        if (errStream == null) {
            CLICompiler.$$$reportNull$$$0(0);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(1);
        }
        ExitCode exitCode = this.exec(errStream, Services.EMPTY, MessageRenderer.PLAIN_RELATIVE_PATHS, args);
        if (exitCode == null) {
            CLICompiler.$$$reportNull$$$0(2);
        }
        return exitCode;
    }

    @NotNull
    public ExitCode execAndOutputXml(@NotNull PrintStream errStream, @NotNull Services services, String ... args) {
        if (errStream == null) {
            CLICompiler.$$$reportNull$$$0(3);
        }
        if (services == null) {
            CLICompiler.$$$reportNull$$$0(4);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(5);
        }
        ExitCode exitCode = this.exec(errStream, services, MessageRenderer.XML, args);
        if (exitCode == null) {
            CLICompiler.$$$reportNull$$$0(6);
        }
        return exitCode;
    }

    @NotNull
    public ExitCode execFullPathsInMessages(@NotNull PrintStream errStream, @NotNull String[] args) {
        if (errStream == null) {
            CLICompiler.$$$reportNull$$$0(7);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(8);
        }
        ExitCode exitCode = this.exec(errStream, Services.EMPTY, MessageRenderer.PLAIN_FULL_PATHS, args);
        if (exitCode == null) {
            CLICompiler.$$$reportNull$$$0(9);
        }
        return exitCode;
    }

    @Nullable
    private A parseArguments(@NotNull PrintStream errStream, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        if (errStream == null) {
            CLICompiler.$$$reportNull$$$0(10);
        }
        if (messageRenderer == null) {
            CLICompiler.$$$reportNull$$$0(11);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(12);
        }
        try {
            A arguments2 = this.createArguments();
            this.parseArguments(args, arguments2);
            return arguments2;
        }
        catch (IllegalArgumentException e) {
            errStream.println(e.getMessage());
            Usage.print(errStream, this.createArguments(), false);
        }
        catch (Throwable t) {
            errStream.println(messageRenderer.render(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException(t), CompilerMessageLocation.NO_LOCATION));
        }
        return null;
    }

    public void parseArguments(@NotNull String[] args, @NotNull A arguments2) {
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(13);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(14);
        }
        ArgumentUtilsKt.parseArguments(args, arguments2);
    }

    @NotNull
    protected abstract A createArguments();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ExitCode exec(@NotNull PrintStream errStream, @NotNull Services services, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        if (errStream == null) {
            CLICompiler.$$$reportNull$$$0(15);
        }
        if (services == null) {
            CLICompiler.$$$reportNull$$$0(16);
        }
        if (messageRenderer == null) {
            CLICompiler.$$$reportNull$$$0(17);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(18);
        }
        K2JVMCompiler.Companion.resetInitStartTime();
        A arguments2 = this.parseArguments(errStream, messageRenderer, args);
        if (arguments2 == null) {
            ExitCode exitCode = ExitCode.INTERNAL_ERROR;
            if (exitCode == null) {
                CLICompiler.$$$reportNull$$$0(19);
            }
            return exitCode;
        }
        if (((CommonCompilerArguments)arguments2).help || ((CommonCompilerArguments)arguments2).extraHelp) {
            Usage.print(errStream, this.createArguments(), ((CommonCompilerArguments)arguments2).extraHelp);
            ExitCode exitCode = ExitCode.OK;
            if (exitCode == null) {
                CLICompiler.$$$reportNull$$$0(20);
            }
            return exitCode;
        }
        PrintingMessageCollector collector2 = new PrintingMessageCollector(errStream, messageRenderer, ((CommonCompilerArguments)arguments2).verbose);
        if (PlainTextMessageRenderer.COLOR_ENABLED) {
            AnsiConsole.systemInstall();
        }
        errStream.print(messageRenderer.renderPreamble());
        ExitCode exitCode = this.exec(collector2, services, arguments2);
        ExitCode exitCode2 = exitCode;
        if (exitCode2 == null) {
            CLICompiler.$$$reportNull$$$0(21);
        }
        return exitCode2;
        finally {
            errStream.print(messageRenderer.renderConclusion());
            if (PlainTextMessageRenderer.COLOR_ENABLED) {
                AnsiConsole.systemUninstall();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public ExitCode exec(@NotNull MessageCollector messageCollector, @NotNull Services services, @NotNull A arguments) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setupCommonArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull CommonCompilerArguments arguments2, @NotNull Services services) {
        CompilerJarLocator locator;
        if (configuration == null) {
            CLICompiler.$$$reportNull$$$0(29);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(30);
        }
        if (services == null) {
            CLICompiler.$$$reportNull$$$0(31);
        }
        if (arguments2.noInline) {
            configuration.put(CommonConfigurationKeys.DISABLE_INLINE, true);
        }
        if ((locator = services.get(CompilerJarLocator.class)) != null) {
            configuration.put(CLIConfigurationKeys.COMPILER_JAR_LOCATOR, locator);
        }
        CLICompiler.setupLanguageVersionSettings(configuration, arguments2);
    }

    private static void setupLanguageVersionSettings(@NotNull CompilerConfiguration configuration, @NotNull CommonCompilerArguments arguments2) {
        LanguageFeature.State coroutinesState;
        if (configuration == null) {
            CLICompiler.$$$reportNull$$$0(32);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(33);
        }
        LanguageVersion languageVersion = CLICompiler.parseVersion(configuration, arguments2.languageVersion, "language");
        LanguageVersion apiVersion = CLICompiler.parseVersion(configuration, arguments2.apiVersion, "API");
        if (languageVersion == null) {
            languageVersion = LanguageVersion.LATEST;
        }
        if (apiVersion == null) {
            apiVersion = languageVersion;
        } else {
            configuration.put(CLIConfigurationKeys.IS_API_VERSION_EXPLICIT, true);
        }
        if (apiVersion.compareTo(languageVersion) > 0) {
            configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, "-api-version (" + apiVersion.getVersionString() + ") cannot be greater than -language-version (" + languageVersion.getVersionString() + ")", CompilerMessageLocation.NO_LOCATION);
        }
        HashMap<LanguageFeature, LanguageFeature.State> extraLanguageFeatures = new HashMap<LanguageFeature, LanguageFeature.State>(0);
        if (arguments2.multiPlatform) {
            extraLanguageFeatures.put(LanguageFeature.MultiPlatformProjects, LanguageFeature.State.ENABLED);
        }
        if ((coroutinesState = CLICompiler.chooseCoroutinesApplicabilityLevel(configuration, arguments2)) != null) {
            extraLanguageFeatures.put(LanguageFeature.Coroutines, coroutinesState);
        }
        LanguageVersionSettingsImpl settings2 = new LanguageVersionSettingsImpl(languageVersion, ApiVersion.createByLanguageVersion(apiVersion), extraLanguageFeatures);
        settings2.switchFlag(AnalysisFlags.getSkipMetadataVersionCheck(), arguments2.skipMetadataVersionCheck);
        settings2.switchFlag(AnalysisFlags.getMultiPlatformDoNotCheckImpl(), arguments2.noCheckImpl);
        CommonConfigurationKeysKt.setLanguageVersionSettings(configuration, settings2);
    }

    @Nullable
    private static LanguageFeature.State chooseCoroutinesApplicabilityLevel(@NotNull CompilerConfiguration configuration, @NotNull CommonCompilerArguments arguments2) {
        if (configuration == null) {
            CLICompiler.$$$reportNull$$$0(34);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(35);
        }
        if (arguments2.coroutinesError && !arguments2.coroutinesWarn && !arguments2.coroutinesEnable) {
            return LanguageFeature.State.ENABLED_WITH_ERROR;
        }
        if (arguments2.coroutinesEnable && !arguments2.coroutinesWarn && !arguments2.coroutinesError) {
            return LanguageFeature.State.ENABLED;
        }
        if (!arguments2.coroutinesEnable && !arguments2.coroutinesError) {
            return null;
        }
        String message = "The -Xcoroutines can only have one value";
        configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, message, CompilerMessageLocation.NO_LOCATION);
        return null;
    }

    @Nullable
    private static LanguageVersion parseVersion(@NotNull CompilerConfiguration configuration, @Nullable String value, @NotNull String versionOf) {
        if (configuration == null) {
            CLICompiler.$$$reportNull$$$0(36);
        }
        if (versionOf == null) {
            CLICompiler.$$$reportNull$$$0(37);
        }
        if (value == null) {
            return null;
        }
        LanguageVersion version = LanguageVersion.fromVersionString(value);
        if (version != null) {
            return version;
        }
        List<String> versionStrings = ArraysKt.map(LanguageVersion.values(), new Function1<LanguageVersion, String>(){

            @Override
            public String invoke(LanguageVersion version) {
                return version.getVersionString();
            }
        });
        String message = "Unknown " + versionOf + " version: " + value + "\nSupported " + versionOf + " versions: " + StringsKt.join(versionStrings, ", ");
        configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, message, CompilerMessageLocation.NO_LOCATION);
        return null;
    }

    protected abstract void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration var1, @NotNull A var2, @NotNull Services var3);

    private void reportUnknownExtraFlags(@NotNull MessageCollector collector2, @NotNull A arguments2) {
        if (collector2 == null) {
            CLICompiler.$$$reportNull$$$0(38);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(39);
        }
        for (String flag : ((CommonCompilerArguments)arguments2).unknownExtraFlags) {
            collector2.report(CompilerMessageSeverity.STRONG_WARNING, "Flag is not supported by this version of the compiler: " + flag, CompilerMessageLocation.NO_LOCATION);
        }
    }

    private void reportUnsupportedJavaVersion(MessageCollector collector2, A arguments2) {
        if (!SystemInfo.isJavaVersionAtLeast("1.8") && !((CommonCompilerArguments)arguments2).noJavaVersionWarning) {
            collector2.report(CompilerMessageSeverity.STRONG_WARNING, "Running the Kotlin compiler under Java 6 or 7 is unsupported and will no longer be possible in a future update.", CompilerMessageLocation.NO_LOCATION);
        }
    }

    @NotNull
    protected abstract ExitCode doExecute(@NotNull A var1, @NotNull CompilerConfiguration var2, @NotNull Disposable var3);

    private void printVersionIfNeeded(@NotNull MessageCollector messageCollector, @NotNull A arguments2) {
        if (messageCollector == null) {
            CLICompiler.$$$reportNull$$$0(40);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(41);
        }
        if (!((CommonCompilerArguments)arguments2).version) {
            return;
        }
        messageCollector.report(CompilerMessageSeverity.INFO, "Kotlin Compiler version 1.1.2-4", CompilerMessageLocation.NO_LOCATION);
    }

    public static void doMain(@NotNull CLICompiler compiler2, @NotNull String[] args) {
        if (compiler2 == null) {
            CLICompiler.$$$reportNull$$$0(42);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(43);
        }
        System.setProperty("java.awt.headless", "true");
        ExitCode exitCode = CLICompiler.doMainNoExit(compiler2, args);
        if (exitCode != ExitCode.OK) {
            System.exit(exitCode.getCode());
        }
    }

    @NotNull
    public static ExitCode doMainNoExit(@NotNull CLICompiler compiler2, @NotNull String[] args) {
        ExitCode exitCode;
        if (compiler2 == null) {
            CLICompiler.$$$reportNull$$$0(44);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(45);
        }
        try {
            exitCode = compiler2.exec(System.err, args);
        }
        catch (CompileEnvironmentException e) {
            System.err.println(e.getMessage());
            ExitCode exitCode2 = ExitCode.INTERNAL_ERROR;
            if (exitCode2 == null) {
                CLICompiler.$$$reportNull$$$0(47);
            }
            return exitCode2;
        }
        if (exitCode == null) {
            CLICompiler.$$$reportNull$$$0(46);
        }
        return exitCode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 46: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errStream";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/CLICompiler";
                break;
            }
            case 4: 
            case 16: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageRenderer";
                break;
            }
            case 14: 
            case 24: 
            case 30: 
            case 33: 
            case 35: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 22: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageCollector";
                break;
            }
            case 29: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionOf";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/CLICompiler";
                break;
            }
            case 2: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "exec";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execAndOutputXml";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "execFullPathsInMessages";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "doMainNoExit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exec";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 46: 
            case 47: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execAndOutputXml";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execFullPathsInMessages";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseArguments";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setupCommonArgumentsAndServices";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setupLanguageVersionSettings";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "chooseCoroutinesApplicabilityLevel";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "reportUnknownExtraFlags";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "printVersionIfNeeded";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "doMain";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "doMainNoExit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

