/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.components;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.components.ComponentManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;

public class ServiceManager {
    private static final Logger LOG = Logger.getInstance(ServiceManager.class);

    private ServiceManager() {
    }

    public static <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager", "getService"));
        }
        Application application = ApplicationManager.getApplication();
        return ServiceManager.doGetService(application, serviceClass);
    }

    public static <T> T getService(@NotNull Project project, @NotNull Class<T> serviceClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager", "getService"));
        }
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager", "getService"));
        }
        return ServiceManager.doGetService(project, serviceClass);
    }

    @Nullable
    private static <T> T doGetService(ComponentManager componentManager, @NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager", "doGetService"));
        }
        PicoContainer picoContainer = componentManager.getPicoContainer();
        Object instance = picoContainer.getComponentInstance(serviceClass.getName());
        if (instance == null && (instance = componentManager.getComponent(serviceClass)) != null) {
            Application app = ApplicationManager.getApplication();
            String message = serviceClass.getName() + " requested as a service, but it is a component - convert it to a service or change call to " + (componentManager == app ? "ApplicationManager.getApplication().getComponent()" : "project.getComponent()");
            if (app.isUnitTestMode()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
        }
        return (T)instance;
    }

    public static <T> NotNullLazyKey<T, Project> createLazyKey(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager", "createLazyKey"));
        }
        return NotNullLazyKey.create("Service: " + serviceClass.getName(), project -> {
            if (serviceClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager", "lambda$createLazyKey$0"));
            }
            return ServiceManager.getService(project, serviceClass);
        });
    }
}

