/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.NotNullDeserializeBinding;
import org.jetbrains.kotlin.org.jdom.Element;

class CompactCollectionBinding
extends NotNullDeserializeBinding {
    private final String name;

    protected CompactCollectionBinding(@NotNull MutableAccessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/com/intellij/util/xmlb/CompactCollectionBinding", "<init>"));
        }
        super(accessor);
        this.name = this.myAccessor.getName();
    }

    @Override
    @NotNull
    public Object deserialize(Object context, @NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/CompactCollectionBinding", "deserialize"));
        }
        List list2 = (List)context;
        list2.clear();
        if (element.getName().equals(this.name)) {
            for (Element item : element.getChildren("item")) {
                ContainerUtil.addIfNotNull(list2, item.getAttributeValue("value"));
            }
        } else {
            Element value = element.getChild("value");
            if (value != null) {
                value = value.getChild("list");
            }
            if (value != null) {
                for (Element item : value.getChildren("item")) {
                    ContainerUtil.addIfNotNull(list2, item.getAttributeValue("itemvalue"));
                }
            }
        }
        List list3 = list2;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/CompactCollectionBinding", "deserialize"));
        }
        return list3;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/CompactCollectionBinding", "isBoundTo"));
        }
        String elementName = element.getName();
        if (this.isNameEqual(elementName)) {
            return true;
        }
        if (elementName.equals("option")) {
            return this.isNameEqual(element.getAttributeValue("name"));
        }
        return false;
    }

    private boolean isNameEqual(@Nullable String value) {
        if (value == null) {
            return false;
        }
        if (value.equals(this.name)) {
            return true;
        }
        if (value.length() == this.name.length() + 2 && value.startsWith("my")) {
            return Character.isUpperCase(value.charAt(2)) && value.regionMatches(true, 2, this.name, 0, this.name.length());
        }
        return false;
    }
}

