/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportList;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiImplementationHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiFileEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.scope.DelegatingScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.kotlin.com.intellij.psi.scope.NameHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.HashSet;
import org.jetbrains.kotlin.com.intellij.util.containers.MostlySingularMultiMap;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexingDataKeys;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiJavaFileBaseImpl");
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;
    private volatile String myPackageName;
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.create("LANGUAGE_LEVEL", file2 -> file2.getLanguageLevelInner());

    protected PsiJavaFileBaseImpl(IElementType elementType, IElementType contentElementType, FileViewProvider viewProvider) {
        super(elementType, contentElementType, viewProvider);
        this.myResolveCache = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new MyCacheBuilder(this), false);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myPackageName = null;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            PsiClass[] psiClassArray = (PsiClass[])stub.getChildrenByType(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getClasses"));
            }
            return psiClassArray;
        }
        PsiClass[] psiClassArray = (PsiClass[])this.calcTreeElement().getChildrenAsPsiElements(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.PACKAGE_STATEMENT);
        return node != null ? (PsiPackageStatement)node.getPsi() : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiJavaFileStub stub = (PsiJavaFileStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getPackageName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getPackageName"));
            }
            return string;
        }
        String name = this.myPackageName;
        if (name == null) {
            PsiPackageStatement statement = this.getPackageStatement();
            name = statement == null ? "" : statement.getPackageName();
            this.myPackageName = name;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getPackageName"));
        }
        return string;
    }

    @Override
    public void setPackageName(String packageName) throws IncorrectOperationException {
        if (PsiUtil.isModuleFile(this)) {
            throw new IncorrectOperationException("Cannot set package name for module declarations");
        }
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
        if (packageStatement != null) {
            if (!packageName.isEmpty()) {
                PsiJavaCodeReferenceElement reference = packageStatement.getPackageReference();
                reference.replace(factory2.createReferenceFromText(packageName, packageStatement));
            } else {
                packageStatement.delete();
            }
        } else if (!packageName.isEmpty()) {
            this.addBefore(factory2.createPackageStatement(packageName), this.getFirstChild());
        }
    }

    @Override
    public PsiImportList getImportList() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            PsiImportList[] nodes = (PsiImportList[])stub.getChildrenByType(JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY);
            if (nodes.length == 1) {
                return nodes[0];
            }
            if (nodes.length == 0) {
                return null;
            }
            this.reportStubAstMismatch(stub + "; " + stub.getChildrenStubs(), this.getStubTree());
        }
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.IMPORT_LIST);
        return (PsiImportList)SourceTreeToPsiMap.treeElementToPsi(node);
    }

    @Override
    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getOnDemandImports"));
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            array.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array.add(resolved);
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getOnDemandImports"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getSingleClassImports"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || !((ref = statement.resolve()) instanceof PsiClass)) continue;
            array.add((PsiClass)ref);
        }
        PsiClass[] psiClassArray = array.toArray(new PsiClass[array.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getSingleClassImports"));
        }
        return psiClassArray;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass2) {
        PsiImportList importList = this.getImportList();
        if (importList != null) {
            PsiImportStatement[] statements;
            for (PsiImportStatement statement : statements = importList.getImportStatements()) {
                PsiElement ref;
                if (statement.isOnDemand() || (ref = statement.resolve()) == null || !this.getManager().areElementsEquivalent(ref, aClass2)) continue;
                return statement.getImportReference();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (IMPLICIT_IMPORTS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getImplicitlyImportedPackages"));
        }
        return IMPLICIT_IMPORTS;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = PsiImplUtil.namesToPackageReferences(this.myManager, IMPLICIT_IMPORTS);
        if (psiJavaCodeReferenceElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getImplicitlyImportedPackageReferences"));
        }
        return psiJavaCodeReferenceElementArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processDeclarations"));
        }
        assert (this.isValid());
        if (processor instanceof ClassResolverProcessor && this.isPhysical() && (this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue())) {
            ClassResolverProcessor hint = (ClassResolverProcessor)processor;
            String name = hint.getName(state2);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> cache2 = this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(processor, state2);
            return name != null ? cache2.processForKey(name, cacheProcessor) : cache2.processAllValues(cacheProcessor);
        }
        return this.processDeclarationsNoGuess(processor, state2, lastParent, place);
    }

    /*
     * WARNING - void declaration
     */
    private boolean processDeclarationsNoGuess(PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, PsiElement place) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiElement resolved;
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processDeclarationsNoGuess"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        String name = nameHint != null ? nameHint.getName(state2) : null;
        PsiImportList importList = this.getImportList();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            void var14_21;
            PsiClass[] classes2;
            for (PsiClass aClass2 : classes2 = this.getClasses()) {
                if (processor.execute(aClass2, state2)) continue;
                return false;
            }
            PsiImportStatement[] importStatements = importList != null ? importList.getImportStatements() : PsiImportStatement.EMPTY_ARRAY;
            for (PsiElement psiElement : importStatements) {
                String refText;
                if (psiElement.isOnDemand() || name != null && ((refText = psiElement.getQualifiedName()) == null || !refText.endsWith(name)) || !((resolved = psiElement.resolve()) instanceof PsiClass)) continue;
                processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiElement);
                PsiClass containingClass = ((PsiClass)resolved).getContainingClass();
                if (!(containingClass != null && containingClass.hasTypeParameters() ? !processor.execute(resolved, state2.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor(containingClass))) : !processor.execute(resolved, state2))) continue;
                return false;
            }
            processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiPackage aPackage = JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.getPackageName());
            if (aPackage != null && !PsiJavaFileBaseImpl.processPackageDeclarations(processor, state2, place, aPackage)) {
                return false;
            }
            PsiImportStatement[] psiImportStatementArray = importStatements;
            int n = psiImportStatementArray.length;
            boolean bl = false;
            while (var14_21 < n) {
                PsiElement resolved2;
                PsiImportStatement statement2 = psiImportStatementArray[var14_21];
                if (statement2.isOnDemand() && (resolved2 = statement2.resolve()) != null) {
                    processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, statement2);
                    PsiJavaFileBaseImpl.processOnDemandTarget(resolved2, processor, state2, place);
                }
                ++var14_21;
            }
        }
        PsiImportStaticStatement[] psiImportStaticStatementArray = importStaticStatements = importList != null ? importList.getImportStaticStatements() : PsiImportStaticStatement.EMPTY_ARRAY;
        if (importStaticStatements.length > 0) {
            StaticImportFilteringProcessor staticImportProcessor = new StaticImportFilteringProcessor(processor);
            for (PsiElement psiElement : importStaticStatements) {
                JavaResolveResult[] results;
                PsiJavaCodeReferenceElement reference;
                if (psiElement.isOnDemand() || (reference = psiElement.getImportReference()) == null || (results = reference.multiResolve(false)).length <= 0) continue;
                staticImportProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiElement);
                String referenceName = psiElement.getReferenceName();
                for (JavaResolveResult result2 : results) {
                    staticImportProcessor.registerSingleStaticImportHiding(result2, referenceName);
                    PsiElement element = result2.getElement();
                    if (element == null || staticImportProcessor.execute(element, state2)) continue;
                    return false;
                }
            }
            for (PsiElement psiElement : importStaticStatements) {
                PsiClass targetElement;
                if (!psiElement.isOnDemand() || (targetElement = psiElement.resolveTargetClass()) == null) continue;
                staticImportProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiElement);
                if (targetElement.processDeclarations(staticImportProcessor, state2, lastParent, place)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiJavaCodeReferenceElement[] implicitlyImported = this.getImplicitlyImportedPackageReferences();
            for (PsiElement psiElement : implicitlyImported) {
                resolved = psiElement.resolve();
                if (resolved == null || PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor, state2, place)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processPackageDeclarations(PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement place, @NotNull PsiPackage aPackage) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processPackageDeclarations"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processPackageDeclarations"));
        }
        if (!aPackage.getQualifiedName().isEmpty()) {
            processor = new DelegatingScopeProcessor(processor){

                @Override
                @Nullable
                public <T> T getHint(@NotNull Key<T> hintKey) {
                    if (hintKey == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl$1", "getHint"));
                    }
                    if (hintKey == ElementClassHint.KEY) {
                        return (T)new ElementClassHint(){

                            @Override
                            public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
                                return kind == ElementClassHint.DeclarationKind.CLASS;
                            }
                        };
                    }
                    return super.getHint(hintKey);
                }
            };
        }
        return aPackage.processDeclarations(processor, state2, null, place);
    }

    @NotNull
    private static PsiSubstitutor createRawSubstitutor(PsiClass containingClass) {
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(containingClass.getProject()).createRawSubstitutor(containingClass);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "createRawSubstitutor"));
        }
        return psiSubstitutor;
    }

    private static boolean processOnDemandTarget(PsiElement target, PsiScopeProcessor processor, ResolveState substitutor2, PsiElement place) {
        if (target instanceof PsiPackage) {
            if (!PsiJavaFileBaseImpl.processPackageDeclarations(processor, substitutor2, place, (PsiPackage)target)) {
                return false;
            }
        } else if (target instanceof PsiClass) {
            PsiClass[] inners = ((PsiClass)target).getInnerClasses();
            if (((PsiClass)target).hasTypeParameters()) {
                substitutor2 = substitutor2.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor((PsiClass)target));
            }
            for (PsiClass inner : inners) {
                if (processor.execute(inner, substitutor2)) continue;
                return false;
            }
        } else {
            LOG.error(target);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitJavaFile(this);
        } else {
            visitor2.visitFile(this);
        }
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getLanguage"));
        }
        return javaLanguage;
    }

    @Override
    public boolean importClass(PsiClass aClass2) {
        return JavaCodeStyleManager.getInstance(this.getProject()).addImport(this, aClass2);
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = LANGUAGE_LEVEL_KEY.getValue(this);
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        return null;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.putUserData(LANGUAGE_LEVEL_KEY, null);
    }

    @Override
    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "setOriginalFile"));
        }
        super.setOriginalFile(originalFile);
        this.clearCaches();
    }

    private LanguageLevel getLanguageLevelInner() {
        if (this.myOriginalFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
        }
        LanguageLevel forcedLanguageLevel = this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            return forcedLanguageLevel;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = this.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        }
        Project project = this.getProject();
        if (virtualFile == null) {
            PsiFile originalFile = this.getOriginalFile();
            if (originalFile instanceof PsiJavaFile && originalFile != this) {
                return ((PsiJavaFile)originalFile).getLanguageLevel();
            }
            return LanguageLevel.HIGHEST;
        }
        return JavaPsiImplementationHelper.getInstance(project).getEffectiveLanguageLevel(virtualFile);
    }

    private static class MyResolveCacheProcessor
    implements Processor<SymbolCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        public MyResolveCacheProcessor(PsiScopeProcessor processor, ResolveState state2) {
            this.myProcessor = processor;
            this.myState = state2;
        }

        @Override
        public boolean process(SymbolCollectingProcessor.ResultWithContext result2) {
            PsiClass containingClass;
            PsiElement context = result2.getFileContext();
            this.myProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, context);
            PsiNamedElement element = result2.getElement();
            if (element instanceof PsiClass && context instanceof PsiImportStatement && (containingClass = ((PsiClass)element).getContainingClass()) != null && containingClass.hasTypeParameters()) {
                return this.myProcessor.execute(element, this.myState.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor(containingClass)));
            }
            return this.myProcessor.execute(element, this.myState);
        }
    }

    private static class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> {
        private final PsiJavaFileBaseImpl myFile;

        public MyCacheBuilder(PsiJavaFileBaseImpl file2) {
            this.myFile = file2;
        }

        @Override
        public CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> compute() {
            SymbolCollectingProcessor p = new SymbolCollectingProcessor();
            this.myFile.processDeclarationsNoGuess(p, ResolveState.initial(), this.myFile, this.myFile);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> results = p.getResults();
            return CachedValueProvider.Result.create(results, PsiModificationTracker.MODIFICATION_COUNT, this.myFile);
        }
    }

    private static class StaticImportFilteringProcessor
    implements PsiScopeProcessor {
        private final PsiScopeProcessor myDelegate;
        private boolean myIsProcessingOnDemand;
        private final Collection<String> myHiddenFieldNames = new HashSet<String>();
        private final Collection<String> myHiddenMethodNames = new HashSet<String>();
        private final Collection<String> myHiddenTypeNames = new HashSet<String>();
        private final Collection<PsiElement> myCollectedElements = new HashSet<PsiElement>();

        public StaticImportFilteringProcessor(PsiScopeProcessor delegate2) {
            this.myDelegate = delegate2;
        }

        @Override
        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor", "getHint"));
            }
            return this.myDelegate.getHint(hintKey);
        }

        @Override
        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor", "handleEvent"));
            }
            if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event) && associated instanceof PsiImportStaticStatement) {
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)associated;
                this.myIsProcessingOnDemand = importStaticStatement.isOnDemand();
            }
            this.myDelegate.handleEvent(event, associated);
        }

        private void registerSingleStaticImportHiding(JavaResolveResult result2, String referenceName) {
            this.getHiddenMembers(result2.getElement()).add(referenceName);
        }

        private Collection<String> getHiddenMembers(PsiElement element) {
            if (element instanceof PsiField) {
                return this.myHiddenFieldNames;
            }
            return element instanceof PsiClass ? this.myHiddenTypeNames : this.myHiddenMethodNames;
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor", "execute"));
            }
            if (state2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor", "execute"));
            }
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                if (element instanceof PsiNamedElement && this.myIsProcessingOnDemand) {
                    String name = ((PsiNamedElement)element).getName();
                    if (this.getHiddenMembers(element).contains(name)) {
                        return true;
                    }
                }
                if (this.myCollectedElements.add(element)) {
                    return this.myDelegate.execute(element, state2);
                }
            }
            return true;
        }
    }
}

