/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.JavaErrorMessages;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.ReferenceParser;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;

public class DeclarationParser {
    private static final TokenSet AFTER_END_DECLARATION_SET = TokenSet.create(JavaElementType.FIELD, JavaElementType.METHOD);
    private static final TokenSet BEFORE_LBRACE_ELEMENTS_SET = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.IMPLEMENTS_KEYWORD);
    private static final TokenSet APPEND_TO_METHOD_SET = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.THROWS_KEYWORD);
    private static final TokenSet PARAM_LIST_STOPPERS = TokenSet.create(JavaTokenType.RPARENTH, JavaTokenType.LBRACE, JavaTokenType.ARROW);
    private static final TokenSet TYPE_START = TokenSet.orSet(ElementType.PRIMITIVE_TYPE_BIT_SET, TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.AT));
    private static final TokenSet RESOURCE_EXPRESSIONS = TokenSet.create(JavaElementType.REFERENCE_EXPRESSION, JavaElementType.THIS_EXPRESSION, JavaElementType.METHOD_CALL_EXPRESSION, JavaElementType.NEW_EXPRESSION);
    private final JavaParser myParser;

    public DeclarationParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaParser", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "<init>"));
        }
        this.myParser = javaParser;
    }

    public void parseClassBodyWithBraces(PsiBuilder builder, boolean isAnnotation, boolean isEnum) {
        assert (builder.getTokenType() == JavaTokenType.LBRACE) : builder.getTokenType();
        builder.advanceLexer();
        PsiBuilder builderWrapper = JavaParserUtil.braceMatchingBuilder(builder);
        if (isEnum) {
            this.parseEnumConstants(builderWrapper);
        }
        this.parseClassBodyDeclarations(builderWrapper, isAnnotation);
        JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
    }

    @Nullable
    private PsiBuilder.Marker parseClassFromKeyword(PsiBuilder builder, PsiBuilder.Marker declaration, boolean isAnnotation, Context context) {
        boolean isEnum;
        IElementType keywordTokenType = builder.getTokenType();
        assert (ElementType.CLASS_KEYWORD_BIT_SET.contains(keywordTokenType)) : keywordTokenType;
        builder.advanceLexer();
        boolean bl = isEnum = keywordTokenType == JavaTokenType.ENUM_KEYWORD;
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            declaration.drop();
            return null;
        }
        ReferenceParser refParser = this.myParser.getReferenceParser();
        refParser.parseTypeParameters(builder);
        refParser.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, JavaElementType.EXTENDS_LIST, JavaTokenType.COMMA);
        refParser.parseReferenceList(builder, JavaTokenType.IMPLEMENTS_KEYWORD, JavaElementType.IMPLEMENTS_LIST, JavaTokenType.COMMA);
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            while (BEFORE_LBRACE_ELEMENTS_SET.contains(builder.getTokenType())) {
                builder.advanceLexer();
            }
            error.error(JavaErrorMessages.message("expected.lbrace", new Object[0]));
        }
        if (builder.getTokenType() == JavaTokenType.LBRACE) {
            this.parseClassBodyWithBraces(builder, isAnnotation, isEnum);
        }
        if (context == Context.FILE) {
            boolean declarationsAfterEnd = false;
            while (builder.getTokenType() != null && builder.getTokenType() != JavaTokenType.RBRACE) {
                PsiBuilder.Marker position = builder.mark();
                PsiBuilder.Marker extra = this.parse(builder, Context.CLASS);
                if (extra != null && AFTER_END_DECLARATION_SET.contains(JavaParserUtil.exprType(extra))) {
                    if (!declarationsAfterEnd) {
                        JavaParserUtil.error(builder, JavaErrorMessages.message("expected.class.or.interface", new Object[0]), extra);
                    }
                    declarationsAfterEnd = true;
                    position.drop();
                    continue;
                }
                position.rollbackTo();
                break;
            }
            if (declarationsAfterEnd) {
                JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
            }
        }
        JavaParserUtil.done(declaration, JavaElementType.CLASS);
        return declaration;
    }

    private void parseEnumConstants(PsiBuilder builder) {
        while (builder.getTokenType() != null) {
            if (PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON)) {
                return;
            }
            if (builder.getTokenType() == JavaTokenType.PRIVATE_KEYWORD || builder.getTokenType() == JavaTokenType.PROTECTED_KEYWORD) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.semicolon", new Object[0]));
                return;
            }
            PsiBuilder.Marker enumConstant = this.parseEnumConstant(builder);
            if (enumConstant == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA) || builder.getTokenType() == null || builder.getTokenType() == JavaTokenType.SEMICOLON) continue;
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.comma.or.semicolon", new Object[0]));
            return;
        }
    }

    @Nullable
    public PsiBuilder.Marker parseEnumConstant(PsiBuilder builder) {
        PsiBuilder.Marker constant = builder.mark();
        this.parseModifierList(builder);
        if (PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            if (builder.getTokenType() == JavaTokenType.LPARENTH) {
                this.myParser.getExpressionParser().parseArgumentList(builder);
            } else {
                JavaParserUtil.emptyElement(builder, JavaElementType.EXPRESSION_LIST);
            }
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                PsiBuilder.Marker constantInit = builder.mark();
                this.parseClassBodyWithBraces(builder, false, false);
                JavaParserUtil.done(constantInit, JavaElementType.ENUM_CONSTANT_INITIALIZER);
            }
            JavaParserUtil.done(constant, JavaElementType.ENUM_CONSTANT);
            return constant;
        }
        constant.rollbackTo();
        return null;
    }

    public void parseClassBodyDeclarations(PsiBuilder builder, boolean isAnnotation) {
        IElementType tokenType;
        Context context = isAnnotation ? Context.ANNOTATION_INTERFACE : Context.CLASS;
        PsiBuilder.Marker invalidElements = null;
        while ((tokenType = builder.getTokenType()) != null && tokenType != JavaTokenType.RBRACE) {
            PsiBuilder.Marker ref;
            if (tokenType == JavaTokenType.SEMICOLON) {
                if (invalidElements != null) {
                    invalidElements.error(JavaErrorMessages.message("unexpected.token", new Object[0]));
                    invalidElements = null;
                }
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration = this.parse(builder, context);
            if (declaration != null) {
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaErrorMessages.message("unexpected.token", new Object[0]), declaration);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false)) != null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(JavaErrorMessages.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parse(PsiBuilder builder, Context context) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            if (context == Context.FILE || context == Context.CODE_BLOCK) {
                return null;
            }
        } else if (tokenType == JavaTokenType.IDENTIFIER || ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
            if (context == Context.FILE) {
                return null;
            }
        } else {
            if (tokenType instanceof ILazyParseableElementType) {
                builder.advanceLexer();
                return null;
            }
            if (!(ElementType.MODIFIER_BIT_SET.contains(tokenType) || ElementType.CLASS_KEYWORD_BIT_SET.contains(tokenType) || tokenType == JavaTokenType.AT || context != Context.CODE_BLOCK && tokenType == JavaTokenType.LT)) {
                return null;
            }
        }
        PsiBuilder.Marker declaration = builder.mark();
        int declarationStart = builder.getCurrentOffset();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder);
        PsiBuilder.Marker modList = (PsiBuilder.Marker)modListInfo.first;
        if (PsiBuilderUtil.expect(builder, JavaTokenType.AT)) {
            if (builder.getTokenType() == JavaTokenType.INTERFACE_KEYWORD) {
                PsiBuilder.Marker result2 = this.parseClassFromKeyword(builder, declaration, true, context);
                return result2 != null ? result2 : modList;
            }
            declaration.rollbackTo();
            return null;
        }
        if (ElementType.CLASS_KEYWORD_BIT_SET.contains(builder.getTokenType())) {
            PsiBuilder.Marker result3 = this.parseClassFromKeyword(builder, declaration, false, context);
            return result3 != null ? result3 : modList;
        }
        PsiBuilder.Marker typeParams = null;
        if (builder.getTokenType() == JavaTokenType.LT) {
            typeParams = this.myParser.getReferenceParser().parseTypeParameters(builder);
        }
        if (context == Context.FILE) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.class.or.interface", new Object[0]), typeParams);
            declaration.drop();
            return modList;
        }
        if (builder.getTokenType() == JavaTokenType.LBRACE) {
            if (context == Context.CODE_BLOCK) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier.or.type", new Object[0]), typeParams);
                declaration.drop();
                return modList;
            }
            PsiBuilder.Marker codeBlock = this.myParser.getStatementParser().parseCodeBlock(builder);
            assert (codeBlock != null) : builder.getOriginalText();
            if (typeParams != null) {
                PsiBuilder.Marker error = typeParams.precede();
                error.errorBefore(JavaErrorMessages.message("unexpected.token", new Object[0]), codeBlock);
            }
            JavaParserUtil.done(declaration, JavaElementType.CLASS_INITIALIZER);
            return declaration;
        }
        PsiBuilder.Marker type2 = null;
        if (TYPE_START.contains(builder.getTokenType())) {
            PsiBuilder.Marker pos = builder.mark();
            type2 = this.myParser.getReferenceParser().parseType(builder, 5);
            if (type2 == null) {
                pos.rollbackTo();
            } else {
                if (builder.getTokenType() == JavaTokenType.LPARENTH) {
                    if (context == Context.CODE_BLOCK) {
                        declaration.rollbackTo();
                        return null;
                    }
                    pos.rollbackTo();
                    if (typeParams == null) {
                        JavaParserUtil.emptyElement(builder, JavaElementType.TYPE_PARAMETER_LIST);
                    }
                    this.parseAnnotations(builder);
                    if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
                        PsiBuilder.Marker primitive = builder.mark();
                        builder.advanceLexer();
                        primitive.error(JavaErrorMessages.message("expected.identifier", new Object[0]));
                    }
                    if (builder.getTokenType() == JavaTokenType.LPARENTH) {
                        return this.parseMethodFromLeftParenth(builder, declaration, false, true);
                    }
                    declaration.rollbackTo();
                    return null;
                }
                pos.drop();
            }
        }
        if (type2 == null) {
            PsiBuilder.Marker error = typeParams != null ? typeParams.precede() : builder.mark();
            error.error(JavaErrorMessages.message("expected.identifier.or.type", new Object[0]));
            declaration.drop();
            return modList;
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            if (context == Context.CODE_BLOCK && Boolean.TRUE.equals(modListInfo.second)) {
                declaration.rollbackTo();
                return null;
            }
            if (typeParams != null) {
                typeParams.precede().errorBefore(JavaErrorMessages.message("unexpected.token", new Object[0]), type2);
            }
            builder.error(JavaErrorMessages.message("expected.identifier", new Object[0]));
            declaration.drop();
            return modList;
        }
        if (builder.getTokenType() == JavaTokenType.LPARENTH && (context == Context.CLASS || context == Context.ANNOTATION_INTERFACE)) {
            if (typeParams == null) {
                JavaParserUtil.emptyElement(type2, JavaElementType.TYPE_PARAMETER_LIST);
            }
            return this.parseMethodFromLeftParenth(builder, declaration, context == Context.ANNOTATION_INTERFACE, false);
        }
        if (typeParams != null) {
            typeParams.precede().errorBefore(JavaErrorMessages.message("unexpected.token", new Object[0]), type2);
        }
        return this.parseFieldOrLocalVariable(builder, declaration, declarationStart, context);
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder) {
        Pair<PsiBuilder.Marker, Boolean> pair = this.parseModifierList(builder, ElementType.MODIFIER_BIT_SET);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "parseModifierList"));
        }
        return pair;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder, TokenSet modifiers2) {
        IElementType tokenType;
        PsiBuilder.Marker modList = builder.mark();
        boolean isEmpty = true;
        while ((tokenType = builder.getTokenType()) != null) {
            if (modifiers2.contains(tokenType)) {
                builder.advanceLexer();
                isEmpty = false;
                continue;
            }
            if (tokenType != JavaTokenType.AT || ElementType.KEYWORD_BIT_SET.contains(builder.lookAhead(1))) break;
            this.parseAnnotation(builder);
            isEmpty = false;
        }
        JavaParserUtil.done(modList, JavaElementType.MODIFIER_LIST);
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(modList, isEmpty);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "parseModifierList"));
        }
        return pair;
    }

    private PsiBuilder.Marker parseMethodFromLeftParenth(PsiBuilder builder, PsiBuilder.Marker declaration, boolean anno, boolean constructor) {
        IElementType tokenType;
        this.parseParameterList(builder);
        this.eatBrackets(builder, constructor ? "expected.semicolon" : null);
        this.myParser.getReferenceParser().parseReferenceList(builder, JavaTokenType.THROWS_KEYWORD, JavaElementType.THROWS_LIST, JavaTokenType.COMMA);
        if (anno && PsiBuilderUtil.expect(builder, JavaTokenType.DEFAULT_KEYWORD)) {
            this.parseAnnotationValue(builder);
        }
        if ((tokenType = builder.getTokenType()) != JavaTokenType.SEMICOLON && tokenType != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            CharSequence text2 = builder.getOriginalText();
            block0: do {
                for (int i = builder.getCurrentOffset() - 1; i >= 0; --i) {
                    char ch = text2.charAt(i);
                    if (ch == '\n') break block0;
                    if (ch != ' ' && ch != '\t') continue block0;
                }
            } while (PsiBuilderUtil.expect(builder, APPEND_TO_METHOD_SET));
            error.error(JavaErrorMessages.message("expected.lbrace.or.semicolon", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON) && builder.getTokenType() == JavaTokenType.LBRACE) {
            this.myParser.getStatementParser().parseCodeBlock(builder);
        }
        JavaParserUtil.done(declaration, anno ? JavaElementType.ANNOTATION_METHOD : JavaElementType.METHOD);
        return declaration;
    }

    @NotNull
    public PsiBuilder.Marker parseParameterList(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseElementList(builder, ListType.METHOD);
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "parseParameterList"));
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseResourceList(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseElementList(builder, ListType.RESOURCE);
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "parseResourceList"));
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseLambdaParameterList(PsiBuilder builder, boolean typed) {
        PsiBuilder.Marker marker = this.parseElementList(builder, typed ? ListType.LAMBDA_TYPED : ListType.LAMBDA_UNTYPED);
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "parseLambdaParameterList"));
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseElementList(PsiBuilder builder, ListType type2) {
        boolean lambda2 = type2 == ListType.LAMBDA_TYPED || type2 == ListType.LAMBDA_UNTYPED;
        boolean resources = type2 == ListType.RESOURCE;
        PsiBuilder.Marker elementList = builder.mark();
        boolean leftParenth = PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH);
        assert (lambda2 || leftParenth) : builder.getTokenType();
        IElementType delimiter = resources ? JavaTokenType.SEMICOLON : JavaTokenType.COMMA;
        String noDelimiterMsg = resources ? "expected.semicolon" : "expected.comma";
        String noElementMsg = resources ? "expected.resource" : "expected.parameter";
        PsiBuilder.Marker invalidElements = null;
        String errorMessage = null;
        boolean delimiterExpected = false;
        boolean noElements = true;
        while (true) {
            PsiBuilder.Marker ref;
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null || PARAM_LIST_STOPPERS.contains(tokenType)) {
                boolean noLastElement;
                boolean bl = noLastElement = !delimiterExpected && (!noElements && !resources || noElements && resources);
                if (noLastElement) {
                    String key = lambda2 ? "expected.parameter" : "expected.identifier.or.type";
                    JavaParserUtil.error(builder, JavaErrorMessages.message(key, new Object[0]));
                }
                if (tokenType == JavaTokenType.RPARENTH) {
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage);
                        invalidElements = null;
                    }
                    builder.advanceLexer();
                    break;
                }
                if (noLastElement && !resources) break;
                if (invalidElements != null) {
                    invalidElements.error(errorMessage);
                }
                invalidElements = null;
                if (!leftParenth) break;
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
                break;
            }
            if (delimiterExpected) {
                if (builder.getTokenType() == delimiter) {
                    delimiterExpected = false;
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage);
                        invalidElements = null;
                    }
                    builder.advanceLexer();
                    continue;
                }
            } else {
                PsiBuilder.Marker listElement;
                PsiBuilder.Marker marker = resources ? this.parseResource(builder) : (lambda2 ? this.parseLambdaParameter(builder, type2 == ListType.LAMBDA_TYPED) : (listElement = this.parseParameter(builder, true, false)));
                if (listElement != null) {
                    delimiterExpected = true;
                    if (invalidElements != null) {
                        invalidElements.errorBefore(errorMessage, listElement);
                        invalidElements = null;
                    }
                    noElements = false;
                    continue;
                }
            }
            if (invalidElements == null) {
                if (builder.getTokenType() == delimiter) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message(noElementMsg, new Object[0]));
                    builder.advanceLexer();
                    if (!noElements || !resources) continue;
                    noElements = false;
                    continue;
                }
                invalidElements = builder.mark();
                errorMessage = JavaErrorMessages.message(delimiterExpected ? noDelimiterMsg : noElementMsg, new Object[0]);
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false)) != null || builder.getTokenType() == null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(errorMessage);
        }
        JavaParserUtil.done(elementList, resources ? JavaElementType.RESOURCE_LIST : JavaElementType.PARAMETER_LIST);
        PsiBuilder.Marker marker = elementList;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "parseElementList"));
        }
        return marker;
    }

    @Nullable
    public PsiBuilder.Marker parseParameter(PsiBuilder builder, boolean ellipsis, boolean disjunctiveType) {
        return this.parseListElement(builder, true, ellipsis, disjunctiveType, false);
    }

    @Nullable
    public PsiBuilder.Marker parseResource(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr != null && RESOURCE_EXPRESSIONS.contains(JavaParserUtil.exprType(expr)) && builder.getTokenType() != JavaTokenType.IDENTIFIER) {
            marker.done(JavaElementType.RESOURCE_EXPRESSION);
            return marker;
        }
        marker.rollbackTo();
        return this.parseListElement(builder, true, false, false, true);
    }

    @Nullable
    public PsiBuilder.Marker parseLambdaParameter(PsiBuilder builder, boolean typed) {
        return this.parseListElement(builder, typed, true, false, false);
    }

    @Nullable
    private PsiBuilder.Marker parseListElement(PsiBuilder builder, boolean typed, boolean ellipsis, boolean disjunctiveType, boolean resource) {
        IElementType tokenType;
        PsiBuilder.Marker param = builder.mark();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder);
        ReferenceParser.TypeInfo typeInfo = null;
        if (typed) {
            int flags = 5;
            if (ellipsis) {
                flags |= 2;
            }
            if (disjunctiveType) {
                flags |= 0x10;
            }
            if ((typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, flags)) == null) {
                if (Boolean.TRUE.equals(modListInfo.second)) {
                    param.rollbackTo();
                    return null;
                }
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type", new Object[0]));
                JavaParserUtil.emptyElement(builder, JavaElementType.TYPE);
            }
        }
        if (typed && ((tokenType = builder.getTokenType()) == JavaTokenType.THIS_KEYWORD || tokenType == JavaTokenType.IDENTIFIER && builder.lookAhead(1) == JavaTokenType.DOT)) {
            PsiBuilder.Marker mark = builder.mark();
            PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
            if (expr != null && JavaParserUtil.exprType(expr) == JavaElementType.THIS_EXPRESSION) {
                mark.drop();
                JavaParserUtil.done(param, JavaElementType.RECEIVER_PARAMETER);
                return param;
            }
            mark.rollbackTo();
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            if (!resource) {
                this.eatBrackets(builder, typeInfo != null && typeInfo.isVarArg ? "expected.rparen" : null);
                JavaParserUtil.done(param, JavaElementType.PARAMETER);
                return param;
            }
        } else {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            param.drop();
            return (PsiBuilder.Marker)modListInfo.first;
        }
        if (JavaParserUtil.expectOrError(builder, JavaTokenType.EQ, "expected.eq") && this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
        }
        JavaParserUtil.done(param, JavaElementType.RESOURCE_VARIABLE);
        return param;
    }

    @Nullable
    private PsiBuilder.Marker parseFieldOrLocalVariable(PsiBuilder builder, PsiBuilder.Marker declaration, int declarationStart, Context context) {
        boolean shouldRollback;
        IElementType varType;
        if (context == Context.CLASS || context == Context.ANNOTATION_INTERFACE) {
            varType = JavaElementType.FIELD;
        } else if (context == Context.CODE_BLOCK) {
            varType = JavaElementType.LOCAL_VARIABLE;
        } else {
            declaration.drop();
            assert (false) : "Unexpected context: " + (Object)((Object)context);
            return null;
        }
        PsiBuilder.Marker variable = declaration;
        boolean unclosed = false;
        boolean eatSemicolon = true;
        boolean openMarker = true;
        while (true) {
            shouldRollback = true;
            if (!this.eatBrackets(builder, null)) {
                unclosed = true;
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.EQ)) {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
                if (expr != null) {
                    shouldRollback = false;
                } else {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
                    unclosed = true;
                    break;
                }
            }
            if (builder.getTokenType() != JavaTokenType.COMMA) break;
            JavaParserUtil.done(variable, varType);
            builder.advanceLexer();
            if (builder.getTokenType() != JavaTokenType.IDENTIFIER) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                unclosed = true;
                eatSemicolon = false;
                openMarker = false;
                break;
            }
            variable = builder.mark();
            builder.advanceLexer();
        }
        if (builder.getTokenType() == JavaTokenType.SEMICOLON && eatSemicolon) {
            builder.advanceLexer();
        } else {
            if (!builder.eof() && shouldRollback) {
                CharSequence text2 = builder.getOriginalText();
                int spaceEnd = builder.getCurrentOffset();
                int spaceStart = CharArrayUtil.shiftBackward(text2, spaceEnd - 1, "\n\r \t");
                int lineStart = CharArrayUtil.shiftBackwardUntil(text2, spaceEnd, "\n\r");
                if (declarationStart < lineStart && lineStart < spaceStart) {
                    int newBufferEnd = CharArrayUtil.shiftForward(text2, lineStart, "\n\r \t");
                    declaration.rollbackTo();
                    return this.parse(JavaParserUtil.stoppingBuilder(builder, newBufferEnd), context);
                }
            }
            if (!unclosed) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.semicolon", new Object[0]));
            }
        }
        if (openMarker) {
            JavaParserUtil.done(variable, varType);
        }
        return declaration;
    }

    private boolean eatBrackets(PsiBuilder builder, @Nullable @PropertyKey(resourceBundle="messages.JavaErrorMessages") String errorKey) {
        boolean paired;
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.LBRACKET && tokenType != JavaTokenType.AT) {
            return true;
        }
        PsiBuilder.Marker marker = builder.mark();
        int count = 0;
        while (true) {
            this.parseAnnotations(builder);
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.LBRACKET)) break;
            ++count;
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RBRACKET)) break;
            ++count;
        }
        if (count == 0) {
            marker.rollbackTo();
            return true;
        }
        if (errorKey != null) {
            marker.error(JavaErrorMessages.message(errorKey, new Object[0]));
        } else {
            marker.drop();
        }
        boolean bl = paired = count % 2 == 0;
        if (!paired) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbracket", new Object[0]));
        }
        return paired;
    }

    @Nullable
    public PsiBuilder.Marker parseAnnotations(PsiBuilder builder) {
        PsiBuilder.Marker firstAnno = null;
        while (builder.getTokenType() == JavaTokenType.AT) {
            PsiBuilder.Marker anno = this.parseAnnotation(builder);
            if (firstAnno != null) continue;
            firstAnno = anno;
        }
        return firstAnno;
    }

    @NotNull
    public PsiBuilder.Marker parseAnnotation(PsiBuilder builder) {
        assert (builder.getTokenType() == JavaTokenType.AT) : builder.getTokenType();
        PsiBuilder.Marker anno = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker classRef = null;
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER) {
            classRef = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false);
        }
        if (classRef == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.class.reference", new Object[0]));
        }
        this.parseAnnotationParameterList(builder);
        JavaParserUtil.done(anno, JavaElementType.ANNOTATION);
        PsiBuilder.Marker marker = anno;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "parseAnnotation"));
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseAnnotationParameterList(PsiBuilder builder) {
        PsiBuilder.Marker list2 = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.done(list2, JavaElementType.ANNOTATION_PARAMETER_LIST);
            PsiBuilder.Marker marker = list2;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "parseAnnotationParameterList"));
            }
            return marker;
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
            JavaParserUtil.done(list2, JavaElementType.ANNOTATION_PARAMETER_LIST);
            PsiBuilder.Marker marker = list2;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "parseAnnotationParameterList"));
            }
            return marker;
        }
        boolean isFirstParamNamed = this.parseAnnotationParameter(builder, true);
        boolean isFirstParamWarned = false;
        boolean afterBad = false;
        while (true) {
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.parameter", new Object[0]));
                break;
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) break;
            if (tokenType == JavaTokenType.COMMA) {
                PsiBuilder.Marker errorStart = builder.mark();
                PsiBuilder.Marker errorEnd = builder.mark();
                builder.advanceLexer();
                boolean hasParamName = this.parseAnnotationParameter(builder, false);
                if (!isFirstParamNamed && hasParamName && !isFirstParamWarned) {
                    errorStart.errorBefore(JavaErrorMessages.message("annotation.name.is.missing", new Object[0]), errorEnd);
                    isFirstParamWarned = true;
                } else {
                    errorStart.drop();
                }
                errorEnd.drop();
                continue;
            }
            if (!afterBad) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.comma.or.rparen", new Object[0]));
                builder.advanceLexer();
                afterBad = true;
                continue;
            }
            afterBad = false;
            this.parseAnnotationParameter(builder, false);
        }
        JavaParserUtil.done(list2, JavaElementType.ANNOTATION_PARAMETER_LIST);
        PsiBuilder.Marker marker = list2;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "parseAnnotationParameterList"));
        }
        return marker;
    }

    private boolean parseAnnotationParameter(PsiBuilder builder, boolean mayBeSimple) {
        PsiBuilder.Marker pair = builder.mark();
        if (mayBeSimple) {
            this.parseAnnotationValue(builder);
            if (builder.getTokenType() != JavaTokenType.EQ) {
                JavaParserUtil.done(pair, JavaElementType.NAME_VALUE_PAIR);
                return false;
            }
            pair.rollbackTo();
            pair = builder.mark();
        }
        boolean hasName = JavaParserUtil.expectOrError(builder, JavaTokenType.IDENTIFIER, "expected.identifier");
        JavaParserUtil.expectOrError(builder, JavaTokenType.EQ, "expected.eq");
        this.parseAnnotationValue(builder);
        JavaParserUtil.done(pair, JavaElementType.NAME_VALUE_PAIR);
        return hasName;
    }

    @NotNull
    public PsiBuilder.Marker parseAnnotationValue(PsiBuilder builder) {
        PsiBuilder.Marker result2 = this.doParseAnnotationValue(builder);
        if (result2 == null) {
            result2 = builder.mark();
            result2.error(JavaErrorMessages.message("expected.value", new Object[0]));
        }
        PsiBuilder.Marker marker = result2;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "parseAnnotationValue"));
        }
        return marker;
    }

    @Nullable
    private PsiBuilder.Marker doParseAnnotationValue(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        PsiBuilder.Marker result2 = tokenType == JavaTokenType.AT ? this.parseAnnotation(builder) : (tokenType == JavaTokenType.LBRACE ? this.parseAnnotationArrayInitializer(builder) : this.myParser.getExpressionParser().parseConditional(builder));
        return result2;
    }

    @NotNull
    private PsiBuilder.Marker parseAnnotationArrayInitializer(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.myParser.getExpressionParser().parseArrayInitializer(builder, JavaElementType.ANNOTATION_ARRAY_INITIALIZER, builder1 -> this.doParseAnnotationValue((PsiBuilder)builder1) != null, "expected.value");
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser", "parseAnnotationArrayInitializer"));
        }
        return marker;
    }

    private static enum ListType {
        METHOD,
        RESOURCE,
        LAMBDA_TYPED,
        LAMBDA_UNTYPED;

    }

    public static enum Context {
        FILE,
        CLASS,
        CODE_BLOCK,
        ANNOTATION_INTERFACE;

    }
}

