/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.mock;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;

public class MockFileIndexFacade
extends FileIndexFacade {
    private final Module myModule = null;
    private final List<VirtualFile> myLibraryRoots = new ArrayList<VirtualFile>();

    public MockFileIndexFacade(Project project) {
        super(project);
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/mock/MockFileIndexFacade", "isInContent"));
        }
        return true;
    }

    @Override
    public boolean isInSource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/mock/MockFileIndexFacade", "isInSource"));
        }
        return true;
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/mock/MockFileIndexFacade", "isInSourceContent"));
        }
        return true;
    }

    @Override
    public boolean isInLibraryClasses(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/mock/MockFileIndexFacade", "isInLibraryClasses"));
        }
        for (VirtualFile libraryRoot : this.myLibraryRoots) {
            if (!VfsUtilCore.isAncestor(libraryRoot, file, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/mock/MockFileIndexFacade", "isInLibrarySource"));
        }
        return false;
    }

    @Override
    public boolean isExcludedFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/mock/MockFileIndexFacade", "isExcludedFile"));
        }
        return false;
    }

    @Override
    public boolean isUnderIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/mock/MockFileIndexFacade", "isUnderIgnored"));
        }
        return false;
    }

    @Override
    public Module getModuleForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/mock/MockFileIndexFacade", "getModuleForFile"));
        }
        return this.myModule;
    }

    @Override
    @NotNull
    public ModificationTracker getRootModificationTracker() {
        ModificationTracker modificationTracker2 = ModificationTracker.NEVER_CHANGED;
        if (modificationTracker2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/mock/MockFileIndexFacade", "getRootModificationTracker"));
        }
        return modificationTracker2;
    }

    public void addLibraryRoot(VirtualFile file) {
        this.myLibraryRoots.add(file);
    }
}

