/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformer;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.js.facade.TranslationUnit;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.inline.JsInliner;
import org.jetbrains.kotlin.js.inline.clean.LabeledBlockToDoWhileTransformation;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedImportsKt;
import org.jetbrains.kotlin.js.inline.clean.ResolveTemporaryNamesKt;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.translate.general.AstGenerationResult;
import org.jetbrains.kotlin.js.translate.general.FileTranslationResult;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.ExpandIsCallsKt;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ast.JsAstSerializer;

public final class K2JSTranslator {
    @NotNull
    private final JsConfig config;

    public K2JSTranslator(@NotNull JsConfig config) {
        if (config == null) {
            K2JSTranslator.$$$reportNull$$$0(0);
        }
        this.config = config;
    }

    @NotNull
    public TranslationResult translate(@NotNull JsConfig.Reporter reporter2, @NotNull List<KtFile> files2, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (reporter2 == null) {
            K2JSTranslator.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            K2JSTranslator.$$$reportNull$$$0(2);
        }
        if (mainCallParameters == null) {
            K2JSTranslator.$$$reportNull$$$0(3);
        }
        TranslationResult translationResult = this.translate(reporter2, files2, mainCallParameters, null);
        if (translationResult == null) {
            K2JSTranslator.$$$reportNull$$$0(4);
        }
        return translationResult;
    }

    @NotNull
    public TranslationResult translate(@NotNull JsConfig.Reporter reporter2, @NotNull List<KtFile> files2, @NotNull MainCallParameters mainCallParameters, @Nullable JsAnalysisResult analysisResult2) throws TranslationException {
        if (reporter2 == null) {
            K2JSTranslator.$$$reportNull$$$0(5);
        }
        if (files2 == null) {
            K2JSTranslator.$$$reportNull$$$0(6);
        }
        if (mainCallParameters == null) {
            K2JSTranslator.$$$reportNull$$$0(7);
        }
        ArrayList<TranslationUnit> units = new ArrayList<TranslationUnit>();
        for (KtFile file : files2) {
            units.add(new TranslationUnit.SourceFile(file));
        }
        TranslationResult translationResult = this.translateUnits(reporter2, units, mainCallParameters, analysisResult2);
        if (translationResult == null) {
            K2JSTranslator.$$$reportNull$$$0(8);
        }
        return translationResult;
    }

    @NotNull
    public TranslationResult translateUnits(@NotNull JsConfig.Reporter reporter2, @NotNull List<TranslationUnit> units, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (reporter2 == null) {
            K2JSTranslator.$$$reportNull$$$0(9);
        }
        if (units == null) {
            K2JSTranslator.$$$reportNull$$$0(10);
        }
        if (mainCallParameters == null) {
            K2JSTranslator.$$$reportNull$$$0(11);
        }
        TranslationResult translationResult = this.translateUnits(reporter2, units, mainCallParameters, null);
        if (translationResult == null) {
            K2JSTranslator.$$$reportNull$$$0(12);
        }
        return translationResult;
    }

    @NotNull
    public TranslationResult translateUnits(@NotNull JsConfig.Reporter reporter2, @NotNull List<TranslationUnit> units, @NotNull MainCallParameters mainCallParameters, @Nullable JsAnalysisResult analysisResult2) throws TranslationException {
        if (reporter2 == null) {
            K2JSTranslator.$$$reportNull$$$0(13);
        }
        if (units == null) {
            K2JSTranslator.$$$reportNull$$$0(14);
        }
        if (mainCallParameters == null) {
            K2JSTranslator.$$$reportNull$$$0(15);
        }
        ArrayList<KtFile> files2 = new ArrayList<KtFile>();
        for (TranslationUnit unit : units) {
            if (!(unit instanceof TranslationUnit.SourceFile)) continue;
            files2.add(((TranslationUnit.SourceFile)unit).getFile());
        }
        if (analysisResult2 == null) {
            analysisResult2 = TopDownAnalyzerFacadeForJS.analyzeFiles(files2, this.config);
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        }
        BindingTrace bindingTrace = analysisResult2.getBindingTrace();
        TopDownAnalyzerFacadeForJS.checkForErrors(files2, bindingTrace.getBindingContext());
        ModuleDescriptor moduleDescriptor = analysisResult2.getModuleDescriptor();
        Diagnostics diagnostics = bindingTrace.getBindingContext().getDiagnostics();
        AstGenerationResult translationResult = Translation.generateAst(bindingTrace, units, mainCallParameters, moduleDescriptor, this.config);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics)) {
            TranslationResult.Fail fail = new TranslationResult.Fail(diagnostics);
            if (fail == null) {
                K2JSTranslator.$$$reportNull$$$0(16);
            }
            return fail;
        }
        ArrayList<JsProgramFragment> newFragments = new ArrayList<JsProgramFragment>(translationResult.getNewFragments());
        ArrayList<JsProgramFragment> allFragments = new ArrayList<JsProgramFragment>(translationResult.getFragments());
        JsInliner.process(reporter2, this.config, analysisResult2.getBindingTrace(), translationResult.getInnerModuleName(), allFragments, newFragments);
        LabeledBlockToDoWhileTransformation.INSTANCE.apply(newFragments);
        CoroutineTransformer coroutineTransformer = new CoroutineTransformer();
        for (JsProgramFragment fragment : newFragments) {
            coroutineTransformer.accept(fragment.getDeclarationBlock());
            coroutineTransformer.accept(fragment.getInitializerBlock());
        }
        RemoveUnusedImportsKt.removeUnusedImports(translationResult.getProgram());
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics)) {
            TranslationResult.Fail fail = new TranslationResult.Fail(diagnostics);
            if (fail == null) {
                K2JSTranslator.$$$reportNull$$$0(17);
            }
            return fail;
        }
        ExpandIsCallsKt.expandIsCalls(newFragments);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        List<File> sourceRoots = this.config.getSourceMapRoots().stream().map(File::new).collect(Collectors.toList());
        SourceFilePathResolver pathResolver = new SourceFilePathResolver(sourceRoots);
        HashMap<KtFile, FileTranslationResult> fileMap2 = new HashMap<KtFile, FileTranslationResult>();
        JsAstSerializer serializer = new JsAstSerializer(file -> {
            try {
                return pathResolver.getPathRelativeToSourceRoots((File)file);
            }
            catch (IOException e) {
                throw new RuntimeException("IO error occurred resolving path to source file", e);
            }
        });
        byte[] metadataHeader = null;
        boolean serializeFragments = this.config.getConfiguration().get(JSConfigurationKeys.SERIALIZE_FRAGMENTS, false);
        for (KtFile file2 : files2) {
            List<DeclarationDescriptor> scope = translationResult.getFileMemberScopes().get(file2);
            byte[] binaryAst = null;
            byte[] binaryMetadata = null;
            if (serializeFragments) {
                JsProgramFragment fragment = translationResult.getFragmentMap().get(file2);
                if (fragment != null) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    serializer.serialize(fragment, output);
                    binaryAst = output.toByteArray();
                }
                if (scope != null) {
                    ProtoBuf.PackageFragment part = KotlinJavascriptSerializationUtil.INSTANCE.serializeDescriptors(bindingTrace.getBindingContext(), moduleDescriptor, scope, file2.getPackageFqName());
                    binaryMetadata = part.toByteArray();
                }
            }
            fileMap2.put(file2, new FileTranslationResult(file2, binaryMetadata, binaryAst));
        }
        if (serializeFragments) {
            metadataHeader = KotlinJavascriptSerializationUtil.INSTANCE.serializeHeader(null).toByteArray();
        }
        ResolveTemporaryNamesKt.resolveTemporaryNames(translationResult.getProgram());
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics)) {
            TranslationResult.Fail fail = new TranslationResult.Fail(diagnostics);
            if (fail == null) {
                K2JSTranslator.$$$reportNull$$$0(18);
            }
            return fail;
        }
        ArrayList<String> importedModules = new ArrayList<String>();
        for (JsImportedModule module2 : translationResult.getImportedModuleList()) {
            importedModules.add(module2.getExternalName());
        }
        TranslationResult.Success success = new TranslationResult.Success(this.config, files2, translationResult.getProgram(), diagnostics, importedModules, moduleDescriptor, bindingTrace.getBindingContext(), metadataHeader, fileMap2);
        if (success == null) {
            K2JSTranslator.$$$reportNull$$$0(19);
        }
        return success;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainCallParameters";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/facade/K2JSTranslator";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "units";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/facade/K2JSTranslator";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "translateUnits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "translateUnits";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

