/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.extapi.psi.ASTDelegatePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.IdentifierChecker;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bJ \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "()V", "CHARS", "", "", "checkDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkIdentifier", "identifier", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "reportIfNeeded", "name", "", "element", "kotlin-compiler"})
public final class JvmSimpleNameBacktickChecker
implements IdentifierChecker {
    private static final Set<Character> CHARS;
    public static final JvmSimpleNameBacktickChecker INSTANCE;

    @Override
    public void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        if (identifier == null) {
            return;
        }
        String string = identifier.getText();
        Intrinsics.checkExpressionValueIsNotNull(string, "identifier.text");
        this.reportIfNeeded(string, identifier, diagnosticHolder);
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        ASTDelegatePsiElement it;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        if (declaration instanceof KtDestructuringDeclaration) {
            $receiver$iv = ((KtDestructuringDeclaration)declaration).getEntries();
            for (Object element$iv : $receiver$iv) {
                KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = it = (KtDestructuringDeclarationEntry)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(ktDestructuringDeclarationEntry, "it");
                INSTANCE.checkNamed(ktDestructuringDeclarationEntry, diagnosticHolder);
            }
        }
        if (declaration instanceof KtCallableDeclaration) {
            $receiver$iv = ((KtCallableDeclaration)declaration).getValueParameters();
            for (Object element$iv : $receiver$iv) {
                ASTDelegatePsiElement aSTDelegatePsiElement = it = (KtParameter)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(aSTDelegatePsiElement, "it");
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)aSTDelegatePsiElement), diagnosticHolder);
            }
        }
        if (declaration instanceof KtTypeParameterListOwner) {
            $receiver$iv = ((KtTypeParameterListOwner)declaration).getTypeParameters();
            for (Object element$iv : $receiver$iv) {
                ASTDelegatePsiElement aSTDelegatePsiElement = it = (KtTypeParameter)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(aSTDelegatePsiElement, "it");
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)aSTDelegatePsiElement), diagnosticHolder);
            }
        }
        if (declaration instanceof KtNamedDeclaration) {
            this.checkNamed((KtNamedDeclaration)declaration, diagnosticHolder);
        }
    }

    public final void checkNamed(@NotNull KtNamedDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        String string = declaration.getName();
        if (string == null) {
            return;
        }
        String name = string;
        PsiElement psiElement = declaration.getNameIdentifier();
        if (psiElement == null) {
            psiElement = declaration;
        }
        PsiElement element = psiElement;
        String string2 = name;
        Intrinsics.checkExpressionValueIsNotNull(string2, "name");
        this.reportIfNeeded(string2, element, diagnosticHolder);
    }

    private final void reportIfNeeded(String name, PsiElement element, DiagnosticSink diagnosticHolder) {
        String text2 = KtPsiUtil.unquoteIdentifier(name);
        CharSequence charSequence = text2;
        if (charSequence.length() == 0) {
            diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(element, "should not be empty"));
        } else {
            boolean bl;
            block4: {
                CharSequence $receiver$iv;
                CharSequence charSequence2 = $receiver$iv = (CharSequence)text2;
                for (int i = 0; i < charSequence2.length(); ++i) {
                    char element$iv = charSequence2.charAt(i);
                    char it = element$iv;
                    if (!CHARS.contains(Character.valueOf(it))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(element, "contains illegal characters: " + CollectionsKt.joinToString$default(CollectionsKt.intersect((Iterable)CHARS, (Iterable)StringsKt.toSet(text2)), "", null, null, 0, null, null, 62, null)));
            }
        }
    }

    private JvmSimpleNameBacktickChecker() {
        INSTANCE = this;
        CHARS = SetsKt.setOf(new Character[]{Character.valueOf('.'), Character.valueOf(';'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\')});
    }

    static {
        new JvmSimpleNameBacktickChecker();
    }
}

