/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.RangeCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValueKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0016\u001a\u00020\u0007*\u00020\u0017\u001a\u0018\u0010\u0018\u001a\u00020\u0007*\u00020\u00172\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\n\u0010\u0019\u001a\u00020\u0007*\u00020\u0017\u001a\f\u0010\u001a\u001a\u00020\u0007*\u00020\u001bH\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u0007*\u00020\u00172\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\n\u0010\u001d\u001a\u00020\u0007*\u00020\u0017\u001a\n\u0010\u001e\u001a\u00020\u0007*\u00020\u0017\u001a\n\u0010\u001f\u001a\u00020\u0007*\u00020\u0017\u001a\u0018\u0010 \u001a\u00020\u0007*\u00020\u00172\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a.\u0010!\u001a\u00020\u0007*\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00070%\u00a2\u0006\u0002\b&H\u0086\b\u001a\u0018\u0010'\u001a\u00020\u0007*\u00020\u00172\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\n\u0010(\u001a\u00020\u0007*\u00020\u0017\u001a\n\u0010)\u001a\u00020\u0007*\u00020\u0017\u001a\n\u0010*\u001a\u00020\u0007*\u00020\u0017\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"2\u0010\u0004\u001a&\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00010\u0001 \u0002*\u0012\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"JLCLASS_TO_KCLASS", "", "kotlin.jvm.PlatformType", "KCLASS_TO_JLCLASS", "UNBOXING_METHOD_NAMES", "Lorg/jetbrains/kotlin/com/google/common/collect/ImmutableSet;", "areSameTypedBoxedValues", "", "values", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "buildFqNameByInternal", "Lorg/jetbrains/kotlin/name/FqName;", "internalClassName", "canValuesBeUnboxedForAreEqual", "isProgressionClass", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "isUnboxingMethodName", "name", "isWrapperClassName", "isWrapperClassNameOrNumber", "isAreEqualIntrinsic", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isAreEqualIntrinsicForSameTypedBoxedValues", "isBoxing", "isBoxingMethodDescriptor", "Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "isIteratorMethodCallOfProgression", "isJavaLangClassBoxing", "isJavaLangClassUnboxing", "isJavaLangComparableCompareTo", "isJavaLangComparableCompareToForSameTypedBoxedValues", "isMethodInsnWith", "opcode", "", "condition", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "isNextMethodCallOfProgressionIterator", "isPrimitiveBoxing", "isPrimitiveUnboxing", "isUnboxing", "kotlin-compiler"})
public final class BoxingInterpreterKt {
    private static final ImmutableSet<String> UNBOXING_METHOD_NAMES = ImmutableSet.of("booleanValue", "charValue", "byteValue", "shortValue", "intValue", "floatValue", new String[]{"longValue", "doubleValue"});
    private static final String KCLASS_TO_JLCLASS = Type.getMethodDescriptor(AsmTypes.JAVA_CLASS_TYPE, AsmTypes.K_CLASS_TYPE);
    private static final String JLCLASS_TO_KCLASS = Type.getMethodDescriptor(AsmTypes.K_CLASS_TYPE, AsmTypes.JAVA_CLASS_TYPE);

    public static final boolean isUnboxing(@NotNull AbstractInsnNode $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return BoxingInterpreterKt.isPrimitiveUnboxing($receiver) || BoxingInterpreterKt.isJavaLangClassUnboxing($receiver);
    }

    public static final boolean isBoxing(@NotNull AbstractInsnNode $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return BoxingInterpreterKt.isPrimitiveBoxing($receiver) || BoxingInterpreterKt.isJavaLangClassBoxing($receiver);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPrimitiveUnboxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 182;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        String string = $receiver2.owner;
        Intrinsics.checkExpressionValueIsNotNull(string, "owner");
        if (!BoxingInterpreterKt.isWrapperClassNameOrNumber(string)) return false;
        String string2 = $receiver2.name;
        Intrinsics.checkExpressionValueIsNotNull(string2, "name");
        if (!BoxingInterpreterKt.isUnboxingMethodName(string2)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavaLangClassUnboxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.owner, "kotlin/jvm/JvmClassMappingKt")) return false;
        if (!Intrinsics.areEqual($receiver2.name, "getJavaClass")) return false;
        if (!Intrinsics.areEqual($receiver2.desc, KCLASS_TO_JLCLASS)) return false;
        return true;
    }

    public static final boolean isMethodInsnWith(@NotNull AbstractInsnNode $receiver, int opcode, @NotNull Function1<? super MethodInsnNode, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(condition, "condition");
        return $receiver.getOpcode() == opcode && $receiver instanceof MethodInsnNode && condition.invoke((MethodInsnNode)$receiver) != false;
    }

    private static final boolean isWrapperClassNameOrNumber(String internalClassName) {
        return BoxingInterpreterKt.isWrapperClassName(internalClassName) || Intrinsics.areEqual(internalClassName, Type.getInternalName(Number.class));
    }

    private static final boolean isWrapperClassName(String internalClassName) {
        return JvmPrimitiveType.isWrapperClassName(BoxingInterpreterKt.buildFqNameByInternal(internalClassName));
    }

    private static final FqName buildFqNameByInternal(String internalClassName) {
        return new FqName(Type.getObjectType(internalClassName).getClassName());
    }

    private static final boolean isUnboxingMethodName(String name) {
        return UNBOXING_METHOD_NAMES.contains(name);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPrimitiveBoxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        String string = $receiver2.owner;
        Intrinsics.checkExpressionValueIsNotNull(string, "owner");
        if (!BoxingInterpreterKt.isWrapperClassName(string)) return false;
        if (!Intrinsics.areEqual($receiver2.name, "valueOf")) return false;
        if (!BoxingInterpreterKt.isBoxingMethodDescriptor($receiver2)) return false;
        return true;
    }

    private static final boolean isBoxingMethodDescriptor(@NotNull MethodInsnNode $receiver) {
        Type ownerType = Type.getObjectType($receiver.owner);
        return Intrinsics.areEqual($receiver.desc, Type.getMethodDescriptor(ownerType, AsmUtil.unboxType(ownerType)));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavaLangClassBoxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.owner, "kotlin/jvm/internal/Reflection")) return false;
        if (!Intrinsics.areEqual($receiver2.name, "getOrCreateKotlinClass")) return false;
        if (!Intrinsics.areEqual($receiver2.desc, JLCLASS_TO_KCLASS)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNextMethodCallOfProgressionIterator(@NotNull AbstractInsnNode $receiver, @NotNull List<? extends BasicValue> values2) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        if (!(CollectionsKt.firstOrNull(values2) instanceof ProgressionIteratorBasicValue)) return false;
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 185;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.name, "next")) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorMethodCallOfProgression(@NotNull AbstractInsnNode $receiver, @NotNull List<? extends BasicValue> values2) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 185;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        BasicValue basicValue = CollectionsKt.firstOrNull(values2);
        if (basicValue == null) return false;
        Type type2 = basicValue.getType();
        Type firstArgType = type2;
        if (firstArgType == null) return false;
        if (!BoxingInterpreterKt.isProgressionClass(firstArgType)) return false;
        if (!Intrinsics.areEqual($receiver2.name, "iterator")) return false;
        return true;
    }

    public static final boolean isProgressionClass(@NotNull Type type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        String string = type2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "type.internalName");
        return RangeCodegenUtil.isRangeOrProgression(BoxingInterpreterKt.buildFqNameByInternal(string));
    }

    public static final boolean isAreEqualIntrinsicForSameTypedBoxedValues(@NotNull AbstractInsnNode $receiver, @NotNull List<? extends BasicValue> values2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        return BoxingInterpreterKt.isAreEqualIntrinsic($receiver) && BoxingInterpreterKt.areSameTypedBoxedValues(values2);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean areSameTypedBoxedValues(@NotNull List<? extends BasicValue> values2) {
        void v2;
        void v1;
        List<? extends BasicValue> list2;
        Intrinsics.checkParameterIsNotNull(values2, "values");
        if (values2.size() != 2) {
            return false;
        }
        List<? extends BasicValue> list3 = list2 = values2;
        BasicValue basicValue = list3.get(0);
        list3 = list2;
        BasicValue basicValue2 = list3.get(1);
        list2 = null;
        return v1 instanceof BoxedBasicValue && v2 instanceof BoxedBasicValue && Intrinsics.areEqual(((BoxedBasicValue)v1).getDescriptor().getUnboxedType(), ((BoxedBasicValue)v2).getDescriptor().getUnboxedType());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAreEqualIntrinsic(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.name, "areEqual")) return false;
        if (!Intrinsics.areEqual($receiver2.owner, "kotlin/jvm/internal/Intrinsics")) return false;
        if (!Intrinsics.areEqual($receiver2.desc, "(Ljava/lang/Object;Ljava/lang/Object;)Z")) return false;
        return true;
    }

    public static final boolean canValuesBeUnboxedForAreEqual(@NotNull List<? extends BasicValue> values2) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull(values2, "values");
            Iterable $receiver$iv = values2;
            for (Object element$iv : $receiver$iv) {
                BasicValue it = (BasicValue)element$iv;
                Type type2 = it.getType();
                Intrinsics.checkExpressionValueIsNotNull(type2, "it.type");
                Type unboxedType = BoxedBasicValueKt.getUnboxedType(type2);
                boolean bl2 = Intrinsics.areEqual(unboxedType, Type.DOUBLE_TYPE) || Intrinsics.areEqual(unboxedType, Type.FLOAT_TYPE);
                if (!bl2) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return !bl;
    }

    public static final boolean isJavaLangComparableCompareToForSameTypedBoxedValues(@NotNull AbstractInsnNode $receiver, @NotNull List<? extends BasicValue> values2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        return BoxingInterpreterKt.isJavaLangComparableCompareTo($receiver) && BoxingInterpreterKt.areSameTypedBoxedValues(values2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavaLangComparableCompareTo(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 185;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.name, "compareTo")) return false;
        if (!Intrinsics.areEqual($receiver2.owner, "java/lang/Comparable")) return false;
        if (!Intrinsics.areEqual($receiver2.desc, "(Ljava/lang/Object;)I")) return false;
        return true;
    }
}

