/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Factory;
import org.jetbrains.kotlin.com.intellij.openapi.util.NullableLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;

public abstract class VolatileNullableLazyValue<T>
extends NullableLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("VolatileNullableLazyValue");
    private volatile boolean myComputed;
    @Nullable
    private volatile T myValue;

    @Override
    @Nullable
    protected abstract T compute();

    @Override
    @Nullable
    public T getValue() {
        T value = this.myValue;
        if (!this.myComputed) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            value = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value;
                this.myComputed = true;
            }
        }
        return value;
    }

    @NotNull
    public static <T> VolatileNullableLazyValue<T> createValue(final @NotNull Factory<T> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/openapi/util/VolatileNullableLazyValue", "createValue"));
        }
        VolatileNullableLazyValue volatileNullableLazyValue = new VolatileNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.create();
            }
        };
        if (volatileNullableLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/VolatileNullableLazyValue", "createValue"));
        }
        return volatileNullableLazyValue;
    }
}

